/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ws.xml.references.MyReferenceProvider;
import com.intellij.ws.xml.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JaxRPCRiXmlReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String OUR_NS = "http://java.sun.com/xml/ns/jax-rpc/ri/runtime";
    @NonNls
    public static final String SERVICE_ATTR_NAME = "interface";
    @NonNls
    public static final String TIE_ATTR_NAME = "tie";
    @NonNls
    public static final String IMPLEMENTATION_ATTR_NAME = "implementation";
    @NonNls
    private static final String MODEL_ATTR_NAME = "model";
    @NonNls
    private static final String WSDL_ATTR_NAME = "wsdl";
    @NonNls
    private static final String URL_PATTERN_ATTR_NAME = "urlpattern";
    private final MyReferenceProvider myPathProvider;
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();
    private final MyReferenceProvider myDynamicPathProvider;

    public JaxRPCRiXmlReferenceProvider() {
        this.myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(true);
        this.myDynamicPathProvider = WsReferenceProvidersHelper.getInstance().acquireDynamicPathReferenceProvider();
    }

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter(new ElementFilter[]{new TextFilter("endpoint"), new NamespaceFilter(new String[]{OUR_NS})}), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SERVICE_ATTR_NAME, IMPLEMENTATION_ATTR_NAME, TIE_ATTR_NAME, MODEL_ATTR_NAME, URL_PATTERN_ATTR_NAME, WSDL_ATTR_NAME};
    }

    @Override
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            JaxRPCRiXmlReferenceProvider.$$$reportNull$$$0(0);
        }
        if (WSDL_ATTR_NAME.equals(name = ((XmlAttribute)element.getParent()).getName()) || MODEL_ATTR_NAME.equals(name)) {
            PsiReference[] psiReferenceArray = this.myPathProvider != null ? this.myPathProvider.getReferencesByElement(element) : PsiReference.EMPTY_ARRAY;
            if (psiReferenceArray == null) {
                JaxRPCRiXmlReferenceProvider.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }
        if (URL_PATTERN_ATTR_NAME.equals(name)) {
            PsiReference[] psiReferenceArray = this.myDynamicPathProvider != null ? this.myDynamicPathProvider.getReferencesByElement(element) : PsiReference.EMPTY_ARRAY;
            if (psiReferenceArray == null) {
                JaxRPCRiXmlReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.myClassProvider.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            JaxRPCRiXmlReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/references/JaxRPCRiXmlReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/references/JaxRPCRiXmlReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

