/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ws.xml.references.MyReferenceProvider;
import com.intellij.ws.xml.references.TagValueClassReference;
import com.intellij.ws.xml.references.WSDLReferenceProvider;
import com.intellij.ws.xml.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JaxRPCMappingReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String JAVA_TYPE_TAG_NAME = "java-type";
    @NonNls
    public static final String PARAM_TYPE_TAG_NAME = "param-type";
    @NonNls
    public static final String METHOD_RETURN_TYPE_TAG_NAME = "method-return-type";
    @NonNls
    public static final String JAVA_VARIABLE_NAME_TAG_NAME = "java-variable-name";
    @NonNls
    public static final String JAVA_METHOD_NAME_TAG_NAME = "java-method-name";
    @NonNls
    public static final String SERVICE_ENDPOINT_INTERFACE_TAG_NAME = "service-endpoint-interface";
    @NonNls
    public static final String SERVICE_INTERFACE_TAG_NAME = "service-interface";
    @NonNls
    private static final String WSDL_FILE_TAG_NAME = "wsdl-file";
    @NonNls
    private static final String JAXRPC_MAPPING_FILE_TAG_NAME = "jaxrpc-mapping-file";
    private final MyReferenceProvider myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(true);

    @Override
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement) {
        XmlTag parentTag;
        String localName;
        if (psiElement == null) {
            JaxRPCMappingReferenceProvider.$$$reportNull$$$0(0);
        }
        if (JAVA_METHOD_NAME_TAG_NAME.equals(localName = (parentTag = (XmlTag)psiElement).getLocalName())) {
            TextRange valueRange = parentTag.getValue().getTextRange();
            TextRange tagRange = parentTag.getTextRange();
            PsiReference[] psiReferenceArray = new PsiReference[]{new WSDLReferenceProvider.WsdlMethodReference((PsiElement)parentTag, valueRange.getStartOffset() - tagRange.getStartOffset(), valueRange.getEndOffset() - tagRange.getStartOffset()){

                @Override
                protected PsiElement resolveClass() {
                    return JaxRPCMappingReferenceProvider.findClassFromGrandGrandParentTag(parentTag, JaxRPCMappingReferenceProvider.SERVICE_ENDPOINT_INTERFACE_TAG_NAME);
                }

                @Override
                public boolean isSoft() {
                    return false;
                }
            }};
            if (psiReferenceArray == null) {
                JaxRPCMappingReferenceProvider.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }
        if (JAVA_VARIABLE_NAME_TAG_NAME.equals(localName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new WSDLReferenceProvider.WsdlPropertyReference((PsiElement)parentTag){

                @Override
                @Nullable
                protected PsiClass resolveClass() {
                    return JaxRPCMappingReferenceProvider.findClassFromGrandGrandParentTag(parentTag, JaxRPCMappingReferenceProvider.JAVA_TYPE_TAG_NAME);
                }

                @Override
                public boolean isSoft() {
                    return false;
                }
            }};
            if (psiReferenceArray == null) {
                JaxRPCMappingReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (SERVICE_ENDPOINT_INTERFACE_TAG_NAME.equals(localName) || SERVICE_INTERFACE_TAG_NAME.equals(localName) || METHOD_RETURN_TYPE_TAG_NAME.equals(localName) || JAVA_TYPE_TAG_NAME.equals(localName) || PARAM_TYPE_TAG_NAME.equals(localName)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new TagValueClassReference(parentTag)};
            if (psiReferenceArray == null) {
                JaxRPCMappingReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (JAXRPC_MAPPING_FILE_TAG_NAME.equals(localName) || WSDL_FILE_TAG_NAME.equals(localName)) {
            PsiReference[] psiReferenceArray = this.myPathProvider.getReferencesByElement((PsiElement)parentTag);
            if (psiReferenceArray == null) {
                JaxRPCMappingReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JaxRPCMappingReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiClass findClassFromGrandGrandParentTag(XmlTag parentTag, String tagName) {
        XmlTag firstSubTag;
        XmlTag grandGrandParentTag;
        XmlTag grandParentTag = parentTag.getParentTag();
        if (grandParentTag != null && (grandGrandParentTag = grandParentTag.getParentTag()) != null && (firstSubTag = grandGrandParentTag.findFirstSubTag(tagName)) != null) {
            return JaxRPCMappingReferenceProvider.findFirstResolvedClassFromReferences(firstSubTag);
        }
        return null;
    }

    @Nullable
    private static PsiClass findFirstResolvedClassFromReferences(XmlTag firstSubTag) {
        PsiReference[] references = firstSubTag.getReferences();
        for (int i = 2; i < references.length; ++i) {
            PsiElement psiElement = references[i].resolve();
            if (!(psiElement instanceof PsiClass)) continue;
            return (PsiClass)psiElement;
        }
        return null;
    }

    @Override
    public String[] getTagCandidateNames() {
        return new String[]{JAVA_TYPE_TAG_NAME, PARAM_TYPE_TAG_NAME, METHOD_RETURN_TYPE_TAG_NAME, JAVA_VARIABLE_NAME_TAG_NAME, JAVA_METHOD_NAME_TAG_NAME, SERVICE_ENDPOINT_INTERFACE_TAG_NAME, SERVICE_INTERFACE_TAG_NAME, WSDL_FILE_TAG_NAME, JAXRPC_MAPPING_FILE_TAG_NAME};
    }

    @Override
    public ElementFilter getTagFilter() {
        return new AndFilter((ElementFilter)new ParentElementFilter((ElementFilter)XmlTagFilter.INSTANCE, 1), (ElementFilter)new NamespaceFilter(new String[]{"http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/references/JaxRPCMappingReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/references/JaxRPCMappingReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

