/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.references;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.xml.references.BaseRangedReference;
import com.intellij.ws.xml.references.PropOrderReference;
import com.intellij.ws.xml.references.WSReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JAXBJavaReferenceProvider
extends WSReferenceProvider {
    @Override
    public ElementPattern<? extends PsiElement> getPattern() {
        return JAXBJavaReferenceProvider.getReferencePattern();
    }

    @NotNull
    public static ElementPattern<PsiElement> getReferencePattern() {
        PsiJavaElementPattern.Capture name = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.xml.bind.annotation.XmlType"}), "name");
        PsiJavaElementPattern.Capture propOrder = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.xml.bind.annotation.XmlType"}), "propOrder");
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])new ElementPattern[]{name, propOrder});
        if (elementPattern == null) {
            JAXBJavaReferenceProvider.$$$reportNull$$$0(0);
        }
        return elementPattern;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiAnnotation annotation;
        PsiNameValuePair pair;
        String name;
        if (element == null) {
            JAXBJavaReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JAXBJavaReferenceProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiJavaToken) {
            element = element.getParent();
        }
        if (!(element instanceof PsiLiteralExpression)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JAXBJavaReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiArrayInitializerMemberValue) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiNameValuePair && ("name".equals(name = (pair = (PsiNameValuePair)parent).getName()) || "propOrder".equals(name)) && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class)) != null && "javax.xml.bind.annotation.XmlType".equals(annotation.getQualifiedName())) {
            PsiReference[] psiReferenceArray;
            if (name.equals("name")) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = new ClassReference((PsiLiteralExpression)element);
            } else {
                PsiReference[] psiReferenceArray3 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray3;
                psiReferenceArray3[0] = new PropOrderReference((PsiLiteralExpression)element);
            }
            if (psiReferenceArray == null) {
                JAXBJavaReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JAXBJavaReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/references/JAXBJavaReferenceProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencePattern";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/references/JAXBJavaReferenceProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassReference
    extends BaseRangedReference {
        ClassReference(@NotNull PsiLiteralExpression psiElement) {
            if (psiElement == null) {
                ClassReference.$$$reportNull$$$0(0);
            }
            super((PsiElement)psiElement, 1, psiElement.getTextLength() - 1);
        }

        @Nullable
        public PsiElement resolve() {
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
            if (clazz != null && StringUtil.capitalize((String)this.getCanonicalText()).equals(clazz.getName())) {
                return clazz;
            }
            return null;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray;
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
            if (clazz == null) {
                objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = StringUtil.decapitalize((String)StringUtil.notNullize((String)clazz.getName()));
            }
            if (objectArray == null) {
                ClassReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/xml/references/JAXBJavaReferenceProvider$ClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/xml/references/JAXBJavaReferenceProvider$ClassReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

