/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.xml.WSBundle;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CxfSpringBeanReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final String id;

    public CxfSpringBeanReference(XmlAttributeValue value) {
        super((PsiElement)value);
        this.id = value.getValue().substring(1);
    }

    public PsiElement resolve() {
        for (SpringModel model : this.getSpringModels()) {
            CommonSpringBean bean;
            SpringBeanPointer springBeanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)this.id);
            if (springBeanPointer == null || !(bean = springBeanPointer.getSpringBean()).isValid()) continue;
            return bean.getIdentifyingPsiElement();
        }
        return null;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)2, (int)this.id.length());
        if (textRange == null) {
            CxfSpringBeanReference.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    public Object @NotNull [] getVariants() {
        HashSet variants = new HashSet();
        for (SpringModel model : this.getSpringModels()) {
            for (SpringBeanPointer pointer : model.getAllCommonBeans()) {
                ContainerUtil.addIfNotNull(variants, (Object)SpringConverterUtil.createCompletionVariant((SpringBeanPointer)pointer));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            CxfSpringBeanReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = WSBundle.message("cxf.spring.cannot.resolve.bean", this.id);
        if (string == null) {
            CxfSpringBeanReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private Set<SpringModel> getSpringModels() {
        return SpringManager.getInstance((Project)this.myElement.getProject()).getSpringModelsByFile(this.myElement.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ws/xml/references/CxfSpringBeanReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

