/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ws.xml.references.MyReferenceProvider;
import com.intellij.ws.xml.references.WSDDReferenceProvider;
import com.intellij.ws.xml.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Axis2ServicesXmlReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String PARAMETER_TAG_NAME = "parameter";
    @NonNls
    public static final String MESSAGE_RECEIVER_TAG_NAME = "messageReceiver";
    @NonNls
    public static final String CLASS_ATTR_NAME = "class";
    @NonNls
    public static final String SERVICE_TAG_NAME = "service";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    @NonNls
    public static final String OPERATION_TAG_NAME = "operation";
    @NonNls
    public static final String SERVICE_CLASS_ATTR_VALUE = "ServiceClass";
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();

    @Override
    public ElementFilter getTagFilter() {
        return new TextFilter(PARAMETER_TAG_NAME);
    }

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new TextFilter(MESSAGE_RECEIVER_TAG_NAME, OPERATION_TAG_NAME), (ElementFilter)new NamespaceFilter(new String[]{""})), 2);
    }

    @Override
    public String[] getTagCandidateNames() {
        return new String[]{PARAMETER_TAG_NAME};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{CLASS_ATTR_NAME, NAME_ATTR_NAME};
    }

    @Override
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element) {
        XmlTag tag;
        if (element == null) {
            Axis2ServicesXmlReferenceProvider.$$$reportNull$$$0(0);
        }
        PsiReference[] result = PsiReference.EMPTY_ARRAY;
        if (element instanceof XmlAttributeValue) {
            String parentTagName;
            XmlAttribute xmlAttribute = (XmlAttribute)element.getParent();
            String attrName = xmlAttribute.getName();
            String tagName = xmlAttribute.getParent().getName();
            XmlTag parentTag = xmlAttribute.getParent().getParentTag();
            String string = parentTagName = parentTag == null ? null : parentTag.getName();
            if (CLASS_ATTR_NAME.equals(attrName) && MESSAGE_RECEIVER_TAG_NAME.equals(tagName)) {
                result = this.myClassProvider.getReferencesByElement(element);
            } else if (NAME_ATTR_NAME.equals(attrName) && OPERATION_TAG_NAME.equals(tagName) && SERVICE_TAG_NAME.equals(parentTagName) && element.getTextLength() >= 2) {
                result = new PsiReference[]{new WSDDReferenceProvider.WSMethodReference(element, new TextRange(1, element.getTextLength() - 1)){

                    @Override
                    protected PsiReference findReference(XmlTag p) {
                        if (Axis2ServicesXmlReferenceProvider.SERVICE_CLASS_ATTR_VALUE.equals(p.getAttributeValue(Axis2ServicesXmlReferenceProvider.NAME_ATTR_NAME))) {
                            PsiReference[] references = p.getReferences();
                            return references[references.length - 1];
                        }
                        return null;
                    }
                }};
            }
        } else if (element instanceof XmlTag && PARAMETER_TAG_NAME.equals((tag = (XmlTag)element).getName()) && SERVICE_CLASS_ATTR_VALUE.equals(tag.getAttributeValue(NAME_ATTR_NAME))) {
            PsiReference[] psiReferenceArray = this.myClassProvider.getReferencesByElement(element);
            if (psiReferenceArray == null) {
                Axis2ServicesXmlReferenceProvider.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }
        if (result == null) {
            Axis2ServicesXmlReferenceProvider.$$$reportNull$$$0(2);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/references/Axis2ServicesXmlReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/references/Axis2ServicesXmlReferenceProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

