/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.common.BaseWSFromFileAction;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.WsJavaExternalProcessHandler;
import com.intellij.ws.xml.actions.WebServicePlatformUtils;
import com.intellij.ws.xml.engines.ExternalEngine;
import com.intellij.ws.xml.jaxb.GenerateJavaFromJAXBSchemasDialog;
import com.intellij.ws.xml.utils.LibUtils;
import com.intellij.ws.xml.utils.WSInvokeExternalCodeUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateJavaFromJAXBSchemasAction
extends BaseWSFromFileAction {
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.jaxb.java");
    @NonNls
    static final String DTD_FILE_EXTENTION = "dtd";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateJavaFromJAXBSchemasAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        this.runAction(project, null, (PsiFile)e.getData(CommonDataKeys.PSI_FILE));
    }

    private void runAction(Project project, @Nullable GenerateJavaFromJAXBSchemasDialog previousDialog, PsiFile file) {
        GenerateJavaFromJAXBSchemasDialog dialog = new GenerateJavaFromJAXBSchemasDialog(project, previousDialog);
        if (file != null) {
            dialog.setCurrentFile(file);
        }
        if (dialog.showAndGet()) {
            this.doAction(project, dialog);
        }
    }

    private void doAction(Project project, GenerateJavaFromJAXBSchemasDialog dialog) {
        VirtualFile parent;
        VirtualFile virtualFile;
        List files;
        File path;
        ApplicationManager.getApplication().saveAll();
        LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("generate.java.code.from.jaxb.schemas.lvcs.action", new Object[0]));
        LinkedList<String> parameters2 = new LinkedList<String>();
        String packagePrefix = dialog.getPackagePrefix().getText();
        String outputPath = (String)dialog.getOutputPaths().getSelectedItem();
        Module moduleForFile = LibUtils.findModuleByOutputPath(project, outputPath);
        if (packagePrefix.length() > 0) {
            WebServicesPluginSettings.getInstance().addLastPackagePrefix(packagePrefix);
            parameters2.add("-p");
            parameters2.add(packagePrefix);
            new File(outputPath + File.separator + packagePrefix.replace('.', File.separatorChar)).mkdirs();
        }
        parameters2.add("-d");
        parameters2.add(outputPath);
        String moduleClassPath = InvokeExternalCodeUtil.buildClasspathForModule(moduleForFile);
        ArrayList<String> classPath = new ArrayList<String>(StringUtil.split((String)moduleClassPath, (String)InvokeExternalCodeUtil.CLASS_PATH_SEPARATOR));
        if (moduleClassPath.length() > 0 && !WebServicePlatformUtils.isJdk1_6SetUpForModule(moduleForFile) && (path = new File(WebServicesPluginSettings.getInstance().getJwsdpPath())).exists() && path.isDirectory() && (files = FileUtil.findFilesByMask((Pattern)Pattern.compile("jaxb(.)*\\.jar"), (File)path)).size() > 0) {
            Function file2Name = file -> file.getName();
            for (File file2 : files) {
                classPath.add(file2.getPath());
            }
        }
        if (!StringUtil.isEmptyOrSpaces((String)dialog.getExternalBinding())) {
            parameters2.add("-b");
            parameters2.add(dialog.getExternalBinding());
        }
        if (dialog.toMarkGeneratedCodeWithAnnotations()) {
            parameters2.add("-mark-generated");
        }
        if (dialog.toEnableSourceLocationSupport()) {
            parameters2.add("-Xlocator");
        }
        if (dialog.toCreateSynchronizedMethods()) {
            parameters2.add("-Xsync-methods");
        }
        if (dialog.toMakeGeneratedCodeReadOnly()) {
            parameters2.add("-readOnly");
        }
        if (!dialog.toCreatePackageLevelAnnotations()) {
            parameters2.add("-npa");
        }
        if (dialog.doNotGenerateHeader()) {
            parameters2.add("-no-header");
        }
        parameters2.add("-quiet");
        parameters2.add("-encoding");
        parameters2.add(this.getEncoding(dialog).name());
        String url = (String)dialog.getUrl().getComboBox().getSelectedItem();
        Object[] urls = url.split("\u0000");
        WebServicesPluginSettings.getInstance().addLastJAXBUrl(urls[urls.length - 1]);
        ContainerUtil.addAll(parameters2, (Object[])urls);
        if (url.endsWith("wsdl")) {
            parameters2.add("-wsdl");
        } else if (url.endsWith(DTD_FILE_EXTENTION)) {
            parameters2.add("-dtd");
        }
        Consumer atFailure = e -> {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)WSBundle.message("generate.java.xjc.error", new Object[0]));
            LOG.debug((Throwable)e);
        };
        ExternalEngine engine = WebServicesPluginSettings.getInstance().getEngineManager().getExternalEngineByName("JAXB 2");
        String basePath = engine.getBasePath();
        String[] classpath = ArrayUtil.mergeArrays((String[])LibUtils.getLibUrlsForToolRunning(engine, moduleForFile), (String[])ArrayUtilRt.toStringArray(classPath));
        WsJavaExternalProcessHandler processHandler = new WsJavaExternalProcessHandler("XJC", basePath != null ? "com.sun.tools.xjc.XJCFacade" : "com.sun.tools.internal.xjc.Driver", classpath, ArrayUtilRt.toStringArray(parameters2), moduleForFile, true);
        PsiClass currentClass = dialog.getCurrentClass();
        if (currentClass != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)currentClass)) != null && (parent = virtualFile.getParent()) != null) {
            processHandler.setLaunchDir(VfsUtilCore.virtualToIoFile((VirtualFile)parent));
        }
        WSInvokeExternalCodeUtil.addEndorsedJarDirectory(processHandler, engine, moduleForFile);
        InvokeExternalCodeUtil.invokeExternalProcess2(processHandler, project, () -> GenerateJavaFromJAXBSchemasAction.lambda$doAction$2(dialog, moduleForFile, engine, (String[])urls, outputPath, packagePrefix, atFailure), (Consumer<? super Exception>)atFailure, (Computable<Boolean>)((Computable)() -> true), () -> this.runAction(project, dialog, null));
    }

    @NotNull
    private Charset getEncoding(@NotNull GenerateJavaFromJAXBSchemasDialog dialog) {
        PsiFile file;
        if (dialog == null) {
            GenerateJavaFromJAXBSchemasAction.$$$reportNull$$$0(1);
        }
        if ((file = dialog.getCurrentFile()) != null) {
            VirtualFile virtualFile = file.getVirtualFile();
            Charset encoding = EncodingManager.getInstance().getEncoding(virtualFile, true);
            if (encoding != null) {
                Charset charset = encoding;
                if (charset == null) {
                    GenerateJavaFromJAXBSchemasAction.$$$reportNull$$$0(2);
                }
                return charset;
            }
        }
        Charset charset = EncodingManager.getInstance().getDefaultCharset();
        if (charset == null) {
            GenerateJavaFromJAXBSchemasAction.$$$reportNull$$$0(3);
        }
        return charset;
    }

    static boolean isAcceptableFileForGenerateJAXBJavaFromSchema(VirtualFile virtualFile) {
        String extension = virtualFile.getExtension();
        return "xsd".equals(extension) || DTD_FILE_EXTENTION.equals(extension) || "wsdl".equals(extension);
    }

    @Override
    public boolean isAcceptableFile(VirtualFile file) {
        return GenerateJavaFromJAXBSchemasAction.isAcceptableFileForGenerateJAXBJavaFromSchema(file);
    }

    private static /* synthetic */ void lambda$doAction$2(GenerateJavaFromJAXBSchemasDialog dialog, Module moduleForFile, ExternalEngine engine, String[] urls, String outputPath, String packagePrefix, Consumer atFailure) {
        if (dialog.getAddLibs().isSelected()) {
            LibUtils.setupLibsForGeneratedCode(moduleForFile, engine, null);
        }
        try {
            for (String schema : urls) {
                LibUtils.saveSourceGeneratedFile(schema, outputPath, packagePrefix);
            }
        }
        catch (IOException e) {
            atFailure.consume((Object)e);
            return;
        }
        CommonWsUtils.doFileSystemRefresh();
        InvokeExternalCodeUtil.navigateToPackage(moduleForFile, packagePrefix, outputPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/jaxb/GenerateJavaFromJAXBSchemasAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/jaxb/GenerateJavaFromJAXBSchemasAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEncoding";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

