/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeElement;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.engines.jsdwp.JWSDPWSEngine;
import com.intellij.ws.xml.inspections.BaseWebServicesInspection;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class OneWayWebMethodInspection
extends BaseWebServicesInspection {
    @Override
    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @Override
    protected void checkMember(ProblemsHolder problemsHolder, PsiMember member) {
        PsiTypeElement returnTypeElement;
        PsiMethod method;
        PsiAnnotation annotation;
        if (member instanceof PsiMethod && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)(method = (PsiMethod)member), JWSDPWSEngine.wsOneWayMethodSet)) != null && (returnTypeElement = method.getReturnTypeElement()) != null && !returnTypeElement.getText().equals("void")) {
            ArrayList<Object> quickfixes = new ArrayList<Object>(2);
            quickfixes.add(new RemoveElementFix((PsiElement)annotation));
            quickfixes.add(new ReplaceTypeElementFix((PsiElement)returnTypeElement, "void"));
            problemsHolder.registerProblem((PsiElement)returnTypeElement, WSBundle.message("webservices.inspections.oneway.operation.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static class RemoveElementFix
    implements LocalQuickFix {
        private final PsiElement annotation;

        RemoveElementFix(@NotNull PsiElement annotation) {
            if (annotation == null) {
                RemoveElementFix.$$$reportNull$$$0(0);
            }
            this.annotation = annotation;
        }

        @NotNull
        public String getFamilyName() {
            String string = WSBundle.message("webservices.inspections.oneway.operation.remove.annotation.fix.name", new Object[0]);
            if (string == null) {
                RemoveElementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveElementFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveElementFix.$$$reportNull$$$0(3);
            }
            this.annotation.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/xml/inspections/OneWayWebMethodInspection$RemoveElementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/xml/inspections/OneWayWebMethodInspection$RemoveElementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceTypeElementFix
    implements LocalQuickFix {
        private final PsiElement annotation;
        private final String text;

        ReplaceTypeElementFix(@NotNull PsiElement annotation, @NotNull String text) {
            if (annotation == null) {
                ReplaceTypeElementFix.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ReplaceTypeElementFix.$$$reportNull$$$0(1);
            }
            this.annotation = annotation;
            this.text = text;
        }

        @NotNull
        public String getFamilyName() {
            String string = WSBundle.message("webservices.inspections.oneway.operation.replace.returntype.with.void.fix.name", new Object[0]);
            if (string == null) {
                ReplaceTypeElementFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplaceTypeElementFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                ReplaceTypeElementFix.$$$reportNull$$$0(4);
            }
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiTypeElement replacement = psiElementFactory.createTypeElement(psiElementFactory.createTypeFromText(this.text, this.annotation));
            this.annotation.replace((PsiElement)replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/xml/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/xml/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

