/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.inspections;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.ws.common.JavaElementVisitor;
import com.intellij.ws.common.WSUtilsBundle;
import com.intellij.ws.xml.jaxb.Jaxb;
import com.intellij.ws.xml.references.JAXBJavaReferenceProvider;
import com.intellij.ws.xml.references.PropOrderReference;
import org.jetbrains.annotations.NotNull;

public final class JaxbPropertyReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            JaxbPropertyReferenceInspection.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile())) == null || !Jaxb.isAvailable(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JaxbPropertyReferenceInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final ElementPattern<PsiElement> pattern = JAXBJavaReferenceProvider.getReferencePattern();
        return new JavaElementVisitor(){

            @Override
            public void checkElement(PsiElement element) {
                if (!(element instanceof PsiLanguageInjectionHost)) {
                    return;
                }
                if (pattern.accepts((Object)element)) {
                    JaxbPropertyReferenceInspection.checkElement(element, holder);
                }
            }
        };
    }

    private static void checkElement(PsiElement element, ProblemsHolder holder) {
        for (PsiReference reference : element.getReferences()) {
            if (reference.resolve() != null) continue;
            if (reference instanceof PropOrderReference) {
                TextRange range = reference.getRangeInElement();
                String message = ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern();
                if (range.isEmpty() && range.getStartOffset() == 1 && "\"\"".equals(element.getText())) {
                    holder.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                    continue;
                }
                holder.registerProblem(reference, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                continue;
            }
            if (!(reference instanceof JavaClassReference)) continue;
            holder.registerProblem(element, WSUtilsBundle.message("webservices.inspections.unresolved.symbol", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/inspections/JaxbPropertyReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/inspections/JaxbPropertyReferenceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

