/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ws.common.JavaElementVisitor;
import com.intellij.ws.xml.WSAnnotations;
import com.intellij.ws.xml.engines.jsdwp.JWSDPWSEngine;
import com.intellij.ws.xml.index.FileBasedWSIndex;
import com.intellij.ws.xml.index.WSIndexEntry;
import com.intellij.ws.xml.inspections.AbstractWebServicesInspection;
import com.intellij.ws.xml.jaxb.JaxbMappingEngine;
import com.intellij.ws.xml.utils.WsModuleUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWebServicesInspection
extends AbstractWebServicesInspection {
    static final String WEB_SERVICE_ANNOTATION_NAME = "WebService";
    private static final Set<String> ourAnnotationsForExternallyBoundClasses = new HashSet<String>();
    private static final Key<CachedValue<ExternallyBoundClassContext>> ourClassContextKey = Key.create((String)"webservices.externally.bound.class");

    @Override
    protected boolean isSimpleMethodInXmlTypeClass(PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"javax.xml.bind.annotation.XmlType", (int)0) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, Arrays.asList(WSAnnotations.WEB_SERVICE.all()), (int)0);
    }

    protected static ExternallyBoundClassContext getClassContext(@NotNull PsiClass containingClass) {
        CachedValue value;
        if (containingClass == null) {
            BaseWebServicesInspection.$$$reportNull$$$0(0);
        }
        if ((value = (CachedValue)containingClass.getUserData(ourClassContextKey)) == null) {
            value = CachedValuesManager.getManager((Project)containingClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new ExternallyBoundClassContext(containingClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            containingClass.putUserData(ourClassContextKey, (Object)value);
        }
        return (ExternallyBoundClassContext)value.getValue();
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            BaseWebServicesInspection.$$$reportNull$$$0(1);
        }
        if (!WsModuleUtil.isJaxWSLibAttached(problemsHolder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BaseWebServicesInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod psiMethod) {
                if (BaseWebServicesInspection.this.isNotAcceptableMember((PsiMember)psiMethod)) {
                    return;
                }
                BaseWebServicesInspection.this.checkMember(problemsHolder, (PsiMember)psiMethod);
            }

            @Override
            public void visitField(PsiField psiField) {
                if (BaseWebServicesInspection.this.isNotAcceptableMember((PsiMember)psiField)) {
                    return;
                }
                BaseWebServicesInspection.this.checkMember(problemsHolder, (PsiMember)psiField);
            }

            @Override
            public void visitClass(PsiClass c) {
                if (BaseWebServicesInspection.this.isNotAcceptableMember((PsiMember)c)) {
                    return;
                }
                BaseWebServicesInspection.this.doCheckClass(c, problemsHolder);
            }
        };
    }

    @Override
    protected abstract void checkMember(ProblemsHolder var1, PsiMember var2);

    @Override
    protected abstract void doCheckClass(PsiClass var1, ProblemsHolder var2);

    static {
        ourAnnotationsForExternallyBoundClasses.addAll(JWSDPWSEngine.wsClassesSet);
        ourAnnotationsForExternallyBoundClasses.addAll(JaxbMappingEngine.mappedClassesSet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/inspections/BaseWebServicesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/inspections/BaseWebServicesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ExternallyBoundClassContext {
        final boolean externallyBound;
        final boolean containingClassIsExternallyBound;
        final boolean isInterface;
        final PsiAnnotation annotation;
        private final String key;

        ExternallyBoundClassContext(PsiClass c) {
            this.key = c.getName();
            this.annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)c, ourAnnotationsForExternallyBoundClasses);
            boolean bl = this.containingClassIsExternallyBound = this.annotation != null;
            if (FileBasedWSIndex.getWsEntries(c).length == 0 && !this.containingClassIsExternallyBound) {
                this.externallyBound = false;
                this.isInterface = false;
            } else {
                this.externallyBound = true;
                this.isInterface = c.isInterface();
            }
        }

        final boolean isExternallyBound() {
            return this.externallyBound && !this.isInterface;
        }

        public WSIndexEntry[] getEntries(Module module) {
            return FileBasedWSIndex.getEntries(module, this.key);
        }
    }
}

