/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.facet;

import com.intellij.DynamicBundle;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginConfigurable;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.xml.actions.WebServicePlatformUtils;
import com.intellij.ws.xml.engines.jsdwp.JWSDPWSEngine;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.engines.wsengine.WSEngineManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWebServicesFacetConfiguration
implements FacetConfiguration {
    private WSEngine wsEngine;
    @NonNls
    private static final String WS_ENGINE_KEY = "ws.engine";

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager facetValidatorsManager) {
        return new FacetEditorTab[]{new MyFacetEditorTab(editorContext, facetValidatorsManager, this.getHelpId())};
    }

    protected abstract String getHelpId();

    public void readExternal(Element element) throws InvalidDataException {
        String wsEngineName = element.getAttributeValue(WS_ENGINE_KEY);
        this.wsEngine = wsEngineName != null ? WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(wsEngineName) : null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.wsEngine != null) {
            element.setAttribute(WS_ENGINE_KEY, this.wsEngine.getName());
        }
    }

    public void setWsEngine(WSEngine _wsEngine) {
        this.wsEngine = _wsEngine;
    }

    protected abstract boolean isServerSideSupport();

    protected abstract String[] getEngines(WSEngineManager var1);

    public WSEngine getWsEngine() {
        return this.wsEngine;
    }

    private class MyFacetEditorTab
    extends FacetEditorTab {
        private JPanel myPanel;
        private JComboBox wsEngineSelect;
        private final FacetEditorContext facetEditorContext;
        private final String helpId;
        private final WSEngineManager wsEngineManager;

        MyFacetEditorTab(FacetEditorContext _facetEditorContext, FacetValidatorsManager facetValidatorsManager, String helpId) {
            this.facetEditorContext = _facetEditorContext;
            this.helpId = helpId;
            this.$$$setupUI$$$();
            this.wsEngineManager = WebServicesPluginSettings.getInstance().getEngineManager();
            String[] strings = BaseWebServicesFacetConfiguration.this.getEngines(this.wsEngineManager);
            this.wsEngineSelect.setModel(new DefaultComboBoxModel<String>(strings));
            this.reset();
            facetValidatorsManager.registerValidator(new FacetEditorValidator(){

                @NotNull
                public ValidationResult check() {
                    String message;
                    WSEngine engine = MyFacetEditorTab.this.wsEngineManager.getWSEngineByName((String)MyFacetEditorTab.this.wsEngineSelect.getSelectedItem());
                    if (engine == null) {
                        return new ValidationResult(WSBundle.message("nonspecified.webservices.engine.name.validation.message", new Object[0]));
                    }
                    if (!engine.isConfigured() && (message = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(engine, MyFacetEditorTab.this.facetEditorContext.getModule())) != null) {
                        return new ValidationResult(message, new FacetConfigurationQuickFix(){

                            public void run(JComponent jComponent) {
                                WebServicesPluginConfigurable settings = new WebServicesPluginConfigurable();
                                ShowSettingsUtil.getInstance().editConfigurable(MyFacetEditorTab.this.facetEditorContext.getProject(), (Configurable)settings);
                            }
                        });
                    }
                    ValidationResult validationResult = ValidationResult.OK;
                    if (validationResult == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return validationResult;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/xml/facet/BaseWebServicesFacetConfiguration$MyFacetEditorTab$1", "check"));
                }
            }, new JComponent[]{this.wsEngineSelect});
        }

        @Nls
        public String getDisplayName() {
            return WSBundle.message("webservices.facet.config.name", new Object[0]);
        }

        @NotNull
        public JComponent createComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                MyFacetEditorTab.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        public boolean isModified() {
            return BaseWebServicesFacetConfiguration.this.wsEngine != null && !BaseWebServicesFacetConfiguration.this.wsEngine.getName().equals(this.wsEngineSelect.getSelectedItem()) || BaseWebServicesFacetConfiguration.this.wsEngine == null && this.wsEngineSelect.getSelectedItem() != null;
        }

        public void apply() {
            WSEngine newWsEngine = this.wsEngineManager.getWSEngineByName((String)this.wsEngineSelect.getSelectedItem());
            if (BaseWebServicesFacetConfiguration.this.wsEngine == newWsEngine) {
                return;
            }
            BaseWebServicesFacetConfiguration.this.wsEngine = newWsEngine;
            if (!BaseWebServicesFacetConfiguration.this.wsEngine.isConfigured()) {
                String message = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(newWsEngine, this.facetEditorContext.getModule());
                message = message == null ? WSBundle.message("webservices.facet.configure.message", new Object[0]) : message;
                Messages.showWarningDialog((Project)this.facetEditorContext.getProject(), (String)message, (String)WSBundle.message("settings.engine.not.configured", new Object[0]));
                return;
            }
            Module module = this.facetEditorContext.getModule();
            EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(this.facetEditorContext.getProject(), false, module, BaseWebServicesFacetConfiguration.this.wsEngine, BaseWebServicesFacetConfiguration.this.isServerSideSupport(), null, (WebFacet)this.facetEditorContext.getParentFacet());
        }

        public void reset() {
            this.wsEngineSelect.setSelectedItem(BaseWebServicesFacetConfiguration.this.wsEngine != null ? BaseWebServicesFacetConfiguration.this.wsEngine.getName() : JWSDPWSEngine.getJwsdpPlatform());
        }

        public void disposeUIResources() {
        }

        public String getHelpTopic() {
            return this.helpId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/xml/facet/BaseWebServicesFacetConfiguration$MyFacetEditorTab", "createComponent"));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JComboBox jComboBox;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WSBundle", MyFacetEditorTab.class).getString("select.ws.engine.facet.configuration.name"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.wsEngineSelect = jComboBox = new JComboBox();
            jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            jLabel.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

