/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.engines.websphere;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.ws.common.ExternalProcessHandler;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.common.engines.LibraryDescriptor;
import com.intellij.ws.common.engines.LibraryInfo;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.xml.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.xml.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.utils.LibUtils;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereWSEngine
implements WSEngine {
    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return true;
    }

    @Override
    public String @Nullable [] getSupportedMappingTypesForJavaFromWsdl() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getDeploymentServletName() {
        return null;
    }

    @Override
    public String getDeploymentServletClassName() {
        return null;
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<? super File> onSuccessAction, Consumer<? super Exception> onException, Runnable editAgain) {
        PsiClass psiClass = options.getClassForOperation();
        String generateWsdlDir = psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
        File tempFile = new File(generateWsdlDir + "/" + psiClass.getName() + ".wsdl");
        ArrayList<String> params = new ArrayList<String>();
        params.add("-location");
        params.add(options.getWebServiceURL());
        params.add("-namespace");
        params.add(options.getWebServiceNamespace());
        params.add("-classpath");
        params.add(InvokeExternalCodeUtil.buildClasspathForModule(options.getModule()));
        params.add("-output");
        params.add(tempFile.getPath());
        params.add("-methods");
        params.add(options.getMethods());
        params.add("-style");
        params.add(options.getBindingStyle());
        params.add("-soapAction");
        params.add(options.getSoapAction());
        params.add("-use");
        params.add(options.getUseOfItems());
        params.add(psiClass.getQualifiedName());
        InvokeExternalCodeUtil.BatchExternalProcessHandler batchExternalProcessHandler = new InvokeExternalCodeUtil.BatchExternalProcessHandler(WebSphereWSEngine.getWebspherePlatform() + " WSDL from Java", "Java2WSDL", params);
        batchExternalProcessHandler.setLaunchDir(new File(this.getBasePath(), "bin"));
        InvokeExternalCodeUtil.invokeExternalProcess2(batchExternalProcessHandler, options.getModule().getProject(), options.getSuccessRunnable(onSuccessAction, tempFile), onException, options.isParametersStillValidPredicate(), editAgain);
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            WebSphereWSEngine.$$$reportNull$$$0(0);
        }
        if (onExceptionAction == null) {
            WebSphereWSEngine.$$$reportNull$$$0(1);
        }
        onSuccessAction.run();
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            WebSphereWSEngine.$$$reportNull$$$0(2);
        }
        if (onExceptionAction == null) {
            WebSphereWSEngine.$$$reportNull$$$0(3);
        }
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) throws InvokeExternalCodeUtil.ExternalCodeException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("-o");
        params.add(options.getOutputPath());
        if (options.isServersideSkeletonGeneration()) {
            params.add("-role");
            params.add("server");
            params.add("-container");
            params.add("web");
        } else {
            params.add("-role");
            params.add("client");
        }
        params.add("-genJava");
        params.add("Overwrite");
        params.add("-genXML");
        params.add("Overwrite");
        if (options.isToGenerateTestCase()) {
            params.add("-testCase");
        }
        if (!options.isSupportWrappedStyleOperation()) {
            params.add("-noWrappedOperations");
        }
        if (options.generateClassesForArrays()) {
            params.add("-noWrappedArrays");
        }
        if (options.isGenerateAllElements()) {
            params.add("-all");
        }
        if (options.getUser().length() > 0) {
            params.add("-user");
            params.add(options.getUser());
            params.add("-password");
            params.add(new String(options.getPassword()));
        }
        params.add("-NStoPkg");
        File savedWsdlFile = options.getSavedWsdlFile();
        String detectedNsFromWsdl = LibUtils.retrieveTargetNamespace(savedWsdlFile);
        String nsFromUrl = detectedNsFromWsdl != null ? detectedNsFromWsdl : options.getWsdlUrl();
        nsFromUrl = StringUtil.trimEnd((String)nsFromUrl, (String)"?wsdl");
        params.add(nsFromUrl + "=" + options.getPackagePrefix());
        params.add(options.getWsdlUrl());
        InvokeExternalCodeUtil.BatchExternalProcessHandler batchExternalProcessHandler = new InvokeExternalCodeUtil.BatchExternalProcessHandler(WebSphereWSEngine.getWebspherePlatform() + " Java from WSDL", "WSDL2Java", params){};
        batchExternalProcessHandler.setLaunchDir(new File(this.getBasePath(), "bin"));
        return batchExternalProcessHandler;
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    @Override
    public String getName() {
        return WebSphereWSEngine.getWebspherePlatform();
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        if (isForGeneratedCode) {
            String basePath = this.getBasePath();
            String runtimesDir = "runtimes";
            File file = new File(basePath, "runtimes");
            File[] files = file.listFiles((dir, name) -> name.endsWith(".jar") && name.contains("webservices.thinclient"));
            if (files != null && files.length == 1) {
                return new LibraryDescriptor[]{new LibraryInfo("IBM WebServices Thin Client Library", "runtimes/" + files[0].getName()), new LibraryInfo("Xerces", "java/jre/lib/xml.jar"), new LibraryInfo("J2EE", "lib/j2ee.jar")};
            }
        }
        return LibraryDescriptor.EMPTY_ARRAY;
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getWebSphereWSPath();
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return false;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "iwws";
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "j2ee1_4.webservice.java";
    }

    public static String getWebspherePlatform() {
        return WSBundle.message("websphere.platform.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onExceptionAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/xml/engines/websphere/WebSphereWSEngine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deployWebService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undeployWebService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

