/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.engines.jaxrpc;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.ExternalProcessHandler;
import com.intellij.ws.common.FileUtils;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.common.WsPsiUtil;
import com.intellij.ws.common.engines.LibraryDescriptor;
import com.intellij.ws.common.engines.LibraryInfo;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.engines.axis.AxisUtil;
import com.intellij.ws.xml.engines.jsdwp.JWSDPWSEngine;
import com.intellij.ws.xml.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.xml.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.xml.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.utils.DeployUtils;
import com.intellij.ws.xml.utils.LibUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JaxRPCWSEngine
implements WSEngine {
    public static final String JAX_RPC = "JAX_RPC";
    private final String[] pathComponents = new String[]{"WEB-INF", "jaxrpc-ri-runtime.xml"};

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return false;
    }

    @Override
    public String @Nullable [] getSupportedMappingTypesForJavaFromWsdl() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getDeploymentServletName() {
        return "JAXRPCServlet";
    }

    @Override
    public String getDeploymentServletClassName() {
        return "com.sun.xml.rpc.server.http.JAXRPCServlet";
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
        CommonWsUtils.addFileToModuleFromTemplate(currentModule, this.pathComponents, LibUtils.getResourcesStream("jaxrpc-ri-runtime.xml"), true, false, webFacet);
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        if (clazz.isInterface() || JaxRPCWSEngine.findWSInterface(clazz) == null) {
            return WSBundle.message("jaxrpc.select.proper.implementation", new Object[0]);
        }
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<? super File> onSuccessAction, Consumer<? super Exception> onException, Runnable editAgain) {
        PsiClass psiClass = options.getClassForOperation();
        PsiFile file = psiClass.getContainingFile();
        try {
            File tempDir = FileUtils.createTempDir("jaxrpcgen");
            PsiClass remoteInterface = JaxRPCWSEngine.findWSInterface(psiClass);
            @NonNls String serviceFileContent = "<service name=\"" + psiClass.getName() + "\"  \ntargetNamespace=\"" + options.getWebServiceNamespace() + "\"  \n      typeNamespace=\"" + options.getWebServiceNamespace() + "\"  \n      packageName=\"" + JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory()).getQualifiedName() + "\">  \n    <interface name=\"" + remoteInterface.getQualifiedName() + "\"  \n          servantName=\"" + psiClass.getQualifiedName() + "\"/>  \n</service>\n";
            String additionalOptions = "    \t       server=\"true\"\n" + JaxRPCWSEngine.buildWsStyleAndUseInBindings(options.getBindingStyle(), options.getUseOfItems());
            String resultsDir = InvokeExternalCodeUtil.toAntPath(tempDir.getPath());
            ExternalProcessHandler externalProcessHandler = this.createWsCompileHandler(serviceFileContent, additionalOptions, resultsDir, options.getClassPathEntries(), options.getModule(), false);
            File wsdlFile = new File(tempDir, psiClass.getName() + ".wsdl");
            InvokeExternalCodeUtil.invokeExternalProcess2(externalProcessHandler, options.getModule().getProject(), options.getSuccessRunnable((Consumer<? super File>)((Consumer)s -> {
                if (s.exists()) {
                    try {
                        File f = new File(file.getContainingDirectory().getVirtualFile().getPath(), psiClass.getName() + ".wsdl");
                        FileUtils.copyWsdlWithReplacementOfSoapAddress(wsdlFile, f, options.getWebServiceURL());
                        onSuccessAction.consume((Object)f);
                    }
                    catch (IOException e) {
                        onException.consume((Object)e);
                    }
                }
            }), wsdlFile), onException, options.isParametersStillValidPredicate(), editAgain);
        }
        catch (IOException e) {
            onException.consume((Object)e);
        }
    }

    private ExternalProcessHandler createWsCompileHandler(String configurationText, String additionalAntTaskOptions, String resultsDir, String[] classPathEntries, Module module, boolean generatedCode) throws IOException {
        File configFile = FileUtil.createTempFile((String)"jaxrpc", (String)".xml");
        configFile.deleteOnExit();
        @NonNls StringBuilder configText = new StringBuilder();
        configText.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<configuration \n    xmlns=\"http://java.sun.com/xml/ns/jax-rpc/ri/config\">\n" + configurationText + "</configuration>");
        FileUtil.writeToFile((File)configFile, (String)configText.toString());
        LibraryDescriptor[] libraryDescriptors = JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(this.getBasePath(), generatedCode);
        @NonNls StringBuilder myBuffer = new StringBuilder();
        myBuffer.append("<project default=\"dowsgen\">\n").append("<property name=\"jwsdp.home\" value=\"").append(InvokeExternalCodeUtil.toAntPath(this.getBasePath())).append("\"/>\n<path id=\"build.classpath\">\n");
        if (libraryDescriptors == null) {
            myBuffer.append("    <fileset dir=\"${jwsdp.home}/jaxrpc/lib\"/>\n").append("    <fileset dir=\"${jwsdp.home}/jwsdp-shared/lib\">\n").append("      <include name=\"activation.jar\"/>\n").append("      <include name=\"mail.jar\"/> \n").append("      <include name=\"jax-qname.jar\"/>\n").append("    </fileset>\n").append("    <fileset dir=\"${jwsdp.home}/saaj/lib\"/>\n").append("    <fileset dir=\"${jwsdp.home}/jaxp/lib\"/>\n");
        } else if (JWSDPWSEngine.isGlassfish3(this.getBasePath())) {
            SdkTypeId type;
            myBuffer.append("    <fileset dir=\"${jwsdp.home}/glassfish/modules\">\n").append("      <include name=\"webservices-osgi.jar\"/>\n").append("      <include name=\"jaxrpc-api-osgi.jar\"/>\n").append("      <include name=\"jaxb-osgi.jar\"/>\n").append("      <include name=\"javax.mail.jar\"/>\n").append("    </fileset>\n");
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && (type = sdk.getSdkType()) instanceof JavaSdk) {
                myBuffer.append("<fileset file=\"").append(((JavaSdk)type).getToolsPath(sdk)).append("\"/>");
            }
        } else {
            myBuffer.append("    <fileset dir=\"${jwsdp.home}/lib\">\n").append("      <include name=\"webservices-rt.jar\"/>\n").append("      <include name=\"webservices-tools.jar\"/>\n").append("      <include name=\"appserv-ws.jar\"/>\n").append("      <include name=\"javaee.jar\"/>\n").append("    </fileset>\n");
        }
        myBuffer.append("  </path>\n").append("<taskdef name=\"wscompile\" classname=\"com.sun.xml.rpc.tools.ant.Wscompile\">\n").append("    <classpath refid=\"build.classpath\"/>\n").append("  </taskdef>\n").append("<target name=\"dowsgen\">\n").append("<wscompile keep=\"true\"\n");
        if (additionalAntTaskOptions != null) {
            myBuffer.append(additionalAntTaskOptions);
        }
        myBuffer.append("\t       base=\"").append(resultsDir).append("\"\n").append("\t       config=\"").append(InvokeExternalCodeUtil.toAntPath(configFile.getPath())).append("\">\n").append("\t       <classpath refid=\"build.classpath\"/>\n").append("    </wscompile>\n").append("</target>").append("</project>");
        InvokeExternalCodeUtil.ANTExternalProcessHandler externalProcessHandler = new InvokeExternalCodeUtil.ANTExternalProcessHandler("JAXRPC wscompile", myBuffer.toString(), classPathEntries, module);
        externalProcessHandler.setOutputConsumer(new InvokeExternalCodeUtil.OutputConsumer(){

            @Override
            public boolean handle(String output, String errOutput) throws InvokeExternalCodeUtil.ExternalCodeException {
                String errorMarker = "error:";
                int errorIndex = output.indexOf("error:");
                if (errorIndex != -1) {
                    throw new InvokeExternalCodeUtil.ExternalCodeException(output.substring(errorIndex + "error:".length()));
                }
                return true;
            }
        });
        return externalProcessHandler;
    }

    private static PsiClass findWSInterface(PsiClass psiClass) {
        PsiClass remoteInterface = null;
        PsiClass rmiInterface = WsPsiUtil.findClass("java.rmi.Remote", psiClass.getProject(), null);
        if (rmiInterface == null) {
            return null;
        }
        for (PsiClass cls : psiClass.getSupers()) {
            if (!cls.isInterface() || !cls.isInheritor(rmiInterface, true)) continue;
            remoteInterface = cls;
            break;
        }
        return remoteInterface;
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            JaxRPCWSEngine.$$$reportNull$$$0(0);
        }
        if (onExceptionAction == null) {
            JaxRPCWSEngine.$$$reportNull$$$0(1);
        }
        try {
            PsiClass clazz = createOptions.getWsClass();
            PsiFile file = clazz.getContainingFile();
            @NonNls String configText = "<service name=\"" + createOptions.getWsName() + "\"  \ntargetNamespace=\"" + createOptions.getWsNamespace() + "\"  \n      typeNamespace=\"" + createOptions.getWsNamespace() + "\"  \n      packageName=\"" + JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory()).getQualifiedName() + "\">  \n    <interface name=\"" + JaxRPCWSEngine.findWSInterface(clazz).getQualifiedName() + "\"  \n          servantName=\"" + createOptions.getWsClassName() + "\"/>  \n</service>\n";
            String wsStyleOption = JaxRPCWSEngine.buildWsStyleAndUseInBindings(createOptions.getUseOfItems(), createOptions.getBindingStyle());
            String sourceOutputDir = LibUtils.findOutputDir(module);
            @NonNls String additionalAntTaskOptions = "\tserver=\"true\"\n\tsourceBase=\"" + sourceOutputDir + "\"\n" + wsStyleOption + "\tmapping=\"" + DeployUtils.determineWhereToPlaceTheFileUnderWebInf(module, createOptions.getWsName() + ".model.xml") + "\"\n";
            String[] classPathForModule = InvokeExternalCodeUtil.buildClasspathStringsForModule(module);
            ExternalProcessHandler externalProcessHandler = this.createWsCompileHandler(configText, additionalAntTaskOptions, sourceOutputDir, classPathForModule, module, true);
            InvokeExternalCodeUtil.runViaConsole(externalProcessHandler, module.getProject(), () -> {
                try {
                    this.continueDeployment(createOptions, module, sourceOutputDir);
                    onSuccessAction.run();
                }
                catch (IOException ex) {
                    onExceptionAction.consume((Object)ex);
                }
            }, onExceptionAction, null, null);
        }
        catch (IOException e) {
            onExceptionAction.consume((Object)e);
        }
    }

    private void continueDeployment(DeployWebServiceOptions createOptions, Module module, String sourceOutputDir) throws IOException {
        PsiClass psiClass = JaxRPCWSEngine.findWSInterface(createOptions.getWsClass());
        String interfaceQName = psiClass.getQualifiedName();
        String interfaceName = psiClass.getName();
        String wsdlFileName = createOptions.getWsName() + ".wsdl";
        File generatedFileName = new File(sourceOutputDir + "/" + wsdlFileName);
        FileUtils.copyWsdlWithReplacementOfSoapAddress(generatedFileName, new File(DeployUtils.determineWhereToPlaceTheFileUnderWebInf(module, wsdlFileName)), AxisUtil.getWebServiceUrlReference("", createOptions.getWsName()));
        FileUtil.asyncDelete((File)generatedFileName);
        DeployUtils.addToConfigFile(this.pathComponents, true, module, "<endpoint\n    name='" + createOptions.getWsName() + "'\n    interface='" + interfaceQName + "'\n    implementation='" + createOptions.getWsClassName() + "'\n    tie='" + interfaceQName + "_Tie'\n    model='/WEB-INF/" + createOptions.getWsName() + ".model.xml'\n    wsdl='/WEB-INF/" + createOptions.getWsName() + ".wsdl'\n    service='{" + createOptions.getWsNamespace() + "}" + createOptions.getWsName() + "'\n    port='{" + createOptions.getWsNamespace() + "}" + interfaceName + "'\n    urlpattern='" + JaxRPCWSEngine.createUrlPatternForWebService(createOptions) + "'/>", this);
    }

    public static String createUrlPatternForWebService(DeployWebServiceOptions createOptions) {
        return StringUtil.escapeXmlEntities((String)(WebServicesPluginSettings.getInstance().getWebServicesUrlPathPrefix() + "/" + createOptions.getWsName()));
    }

    private static String buildWsStyleAndUseInBindings(String wsStyle, String wsUseStyle) {
        String wsStyleOption = wsStyle.equals("DOCUMENT") ? "documentliteral" : (wsStyle.equals("RPC") ? "rpcliteral" : (wsStyle.equals("WRAPPED") ? "documentliteral,wsi,unwrap" : null));
        return wsStyleOption != null ? "\tfeatures=\"" + wsStyleOption + "\"\n" : "";
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            JaxRPCWSEngine.$$$reportNull$$$0(2);
        }
        if (onExceptionAction == null) {
            JaxRPCWSEngine.$$$reportNull$$$0(3);
        }
        DeployUtils.removeFromConfigFile(this.pathComponents, true, module, (Processor<? super XmlTag>)((Processor)xmlTag -> webServiceName.equals(xmlTag.getAttributeValue("name"))));
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        ArrayList availableWS = new ArrayList(1);
        DeployUtils.processTagsInConfigFile(this.pathComponents, true, module, (Processor<? super XmlTag>)((Processor)xmlTag -> {
            String wsname = xmlTag.getAttributeValue("name");
            if (wsname != null) {
                availableWS.add(wsname);
            }
            return true;
        }));
        return ArrayUtilRt.toStringArray(availableWS);
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) throws InvokeExternalCodeUtil.ExternalCodeException {
        @NonNls String configText = "<wsdl \n    location=\"" + options.getSavedWsdlFile().getPath() + "\" \n    packageName=\"" + options.getPackagePrefix() + "\" /> \n";
        @NonNls String additionalAntTaskOptions = (options.isServersideSkeletonGeneration() ? "\tserver=\"true\"" : "\tclient=\"true\"\n") + "\tsourceBase=\"" + options.getOutputPath() + "\"\n";
        try {
            return this.createWsCompileHandler(configText, additionalAntTaskOptions, options.getOutputPath(), null, options.getSelectedModule(), false);
        }
        catch (IOException e) {
            throw new InvokeExternalCodeUtil.ExternalCodeException(e);
        }
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    @Override
    public String getName() {
        return JAX_RPC;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        String basePath = this.getBasePath();
        if (basePath == null) {
            return LibraryDescriptor.EMPTY_ARRAY;
        }
        LibraryDescriptor[] glassFishLibs = JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, isForGeneratedCode);
        if (glassFishLibs != null) {
            return glassFishLibs;
        }
        return new LibraryDescriptor[]{new LibraryInfo("JaxRPC", new String[]{"jaxrpc/lib/jaxrpc-impl.jar", "jaxrpc/lib/jaxrpc-api.jar", "jaxrpc/lib/jaxrpc-spi.jar", "saaj/lib" + File.separator + "saaj-api.jar", "saaj/lib" + File.separator + "saaj-impl.jar", "fastinfoset/lib" + File.separator + "FastInfoset.jar", "jwsdp-shared/lib" + File.separator + "mail.jar", "sjsxp/lib" + File.separator + "sjsxp.jar", "sjsxp/lib" + File.separator + "jsr173_api.jar"}), new LibraryInfo("Activation", new String[]{"jwsdp-shared/lib/activation.jar"})};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getJwsdpPath();
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return true;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "ijrws";
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "j2ee1_4.webservice.java";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onExceptionAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/xml/engines/jaxrpc/JaxRPCWSEngine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deployWebService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undeployWebService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

