/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.engines.axis2;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.ExternalProcessHandler;
import com.intellij.ws.common.FileUtils;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.common.engines.LibraryDescriptor;
import com.intellij.ws.common.engines.LibraryInfo;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.xml.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.xml.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.engines.wsengine.WSEngineUtils;
import com.intellij.ws.xml.utils.DeployUtils;
import com.intellij.ws.xml.utils.LibUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class Axis2WSEngine
implements WSEngine {
    private static final String AXIS2_LIBRARY_NAME = "Axis2";
    private static final String ADB_MAPPING_TYPE = "ADB";
    private static final String JIBX_MAPPING_TYPE = "JibX";
    private static final String JAXBRI_MAPPING_TYPE = "JAXBRI";
    private static final String XMLBEANS_MAPPING_TYPE = "XmlBeans";
    private final String[] pathComponents = new String[]{"META-INF", "services.xml"};
    private final String[] pathComponents2 = new String[]{"WEB-INF", "conf", "axis2.xml"};
    private static final boolean CREATE_IN_CONTENT_ROOT = false;
    private static final Logger LOG = Logger.getInstance(Axis2WSEngine.class);

    @Override
    public String getName() {
        return Axis2WSEngine.getAXIS2_PLATFORM();
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        String axis2BasePath = WebServicesPluginSettings.getInstance().getAxis2Path();
        File[] axis2LibFiles = new File(axis2BasePath + "/lib").listFiles((file, filename) -> {
            boolean jarFile = filename.endsWith(".jar");
            if (jarFile && filename.startsWith("servletapi") && isForGeneratedCode) {
                return false;
            }
            return jarFile;
        });
        String[] axis2LibPathes = new String[axis2LibFiles.length];
        for (int i = 0; i < axis2LibFiles.length; ++i) {
            axis2LibPathes[i] = WSEngineUtils.stripPrefixPath(axis2LibFiles[i].getAbsolutePath(), axis2BasePath);
        }
        return new LibraryDescriptor[]{new LibraryInfo(AXIS2_LIBRARY_NAME, axis2LibPathes)};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getAxis2Path();
    }

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return true;
    }

    @Override
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return new String[]{ADB_MAPPING_TYPE, XMLBEANS_MAPPING_TYPE, JAXBRI_MAPPING_TYPE};
    }

    @Override
    public String getDeploymentServletName() {
        return "Axis2Servlet";
    }

    @Override
    public String getDeploymentServletClassName() {
        return "org.apache.axis2.transport.http.AxisServlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
        CommonWsUtils.addFileToModuleFromTemplate(currentModule, this.pathComponents, LibUtils.getResourcesStream("Axis2.services.xml"), false, false, webFacet);
        File axis2ConfFile = new File(new File(this.getBasePath(), "conf"), "axis2.xml");
        if (axis2ConfFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(axis2ConfFile);
                CommonWsUtils.addFileToModuleFromTemplate(currentModule, this.pathComponents2, inputStream, true, false, webFacet);
            }
            catch (FileNotFoundException e) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        } else {
            InputStream bundledTemplateStream = LibUtils.getResourcesStream("Axis2.conf_axis2.xml");
            CommonWsUtils.addFileToModuleFromTemplate(currentModule, this.pathComponents2, bundledTemplateStream, true, false, webFacet);
        }
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return true;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "itaws";
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<? super File> onSuccessAction, Consumer<? super Exception> onException, Runnable editAgain) {
        LinkedList<String> parametersList = new LinkedList<String>();
        PsiClass psiClass = options.getClassForOperation();
        String wsdlFileName = psiClass.getName() + ".wsdl";
        File tempFile = new File(psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath() + "/" + wsdlFileName);
        parametersList.add("-o");
        parametersList.add(tempFile.getParentFile().getPath());
        parametersList.add("-st");
        parametersList.add(StringUtil.toLowerCase((String)options.getBindingStyle()));
        parametersList.add("-tn");
        String webServiceNamespace = options.getWebServiceNamespace();
        parametersList.add(webServiceNamespace);
        parametersList.add("-stn");
        parametersList.add(webServiceNamespace);
        parametersList.add("-l");
        parametersList.add(options.getWebServiceURL());
        parametersList.add("-u");
        parametersList.add(StringUtil.toLowerCase((String)options.getUseOfItems()));
        parametersList.add("-cn");
        parametersList.add(psiClass.getQualifiedName());
        InvokeExternalCodeUtil.invokeExternalProcess2(new InvokeExternalCodeUtil.JavaExternalProcessHandler("Axis2 Java 2 WSDL", "org.apache.ws.java2wsdl.Java2WSDL", options.getClassPathEntries(), ArrayUtilRt.toStringArray(parametersList), options.getModule(), false), options.getModule().getProject(), options.getSuccessRunnable(onSuccessAction, tempFile), onException, options.isParametersStillValidPredicate(), editAgain);
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        ArrayList result = new ArrayList();
        DeployUtils.processTagsInConfigFile(this.pathComponents, false, module, (Processor<? super XmlTag>)((Processor)xmlTag -> {
            if (xmlTag.getAttributeValue("name") != null && "operation".equals(xmlTag.getName())) {
                result.add(xmlTag.getAttributeValue("name"));
            }
            return true;
        }));
        return ArrayUtilRt.toStringArray(result);
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            Axis2WSEngine.$$$reportNull$$$0(0);
        }
        if (onExceptionAction == null) {
            Axis2WSEngine.$$$reportNull$$$0(1);
        }
        DeployUtils.addToConfigFile(this.pathComponents, false, module, "<service name=\"" + createOptions.getWsName() + "\">\n    <parameter name=\"ServiceClass\" locked=\"false\">" + createOptions.getWsClassName() + "</parameter>\n    <operation name=\"*\">\n    <messageReceiver  class=\"org.apache.axis2.rpc.receivers.RPCMessageReceiver\" />\n    </operation>\n</service>", this);
        onSuccessAction.run();
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            Axis2WSEngine.$$$reportNull$$$0(2);
        }
        if (onExceptionAction == null) {
            Axis2WSEngine.$$$reportNull$$$0(3);
        }
        DeployUtils.removeFromConfigFile(this.pathComponents, false, module, (Processor<? super XmlTag>)((Processor)t -> webServiceName.equals(t.getAttributeValue("name"))));
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        ArrayList availableWS = new ArrayList(1);
        DeployUtils.processTagsInConfigFile(this.pathComponents, false, module, (Processor<? super XmlTag>)((Processor)xmlTag -> {
            String wsname = xmlTag.getAttributeValue("name");
            if (wsname != null) {
                availableWS.add(wsname);
            }
            return true;
        }));
        return ArrayUtilRt.toStringArray(availableWS);
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) {
        ArrayList<Object> parameters2 = new ArrayList<Object>(3);
        parameters2.add("-uri");
        parameters2.add(FileUtils.removeFileProtocolPrefixIfPresent(options.getWsdlUrl()));
        parameters2.add("-o");
        String outputPathForAxis2 = options.getOutputPath();
        if (outputPathForAxis2.endsWith(File.separator + "src")) {
            outputPathForAxis2 = outputPathForAxis2.substring(0, outputPathForAxis2.length() - 4);
        }
        parameters2.add(outputPathForAxis2 + File.separator);
        parameters2.add("-p");
        parameters2.add(options.getPackagePrefix());
        if (options.isToGenerateTestCase()) {
            parameters2.add("-t");
        }
        parameters2.add("-d");
        parameters2.add(StringUtil.toLowerCase((String)options.getBindingType()));
        if (options.isServersideSkeletonGeneration()) {
            parameters2.add("-ss");
            parameters2.add("-sd");
        }
        return new InvokeExternalCodeUtil.JavaExternalProcessHandler("Axis 2 WSDL2Java", "org.apache.axis2.wsdl.WSDL2Java", LibUtils.getLibsUrlsFromLibInfos(this.getLibraryDescriptors(options.getBindingType(), false), this.getBasePath()), ArrayUtilRt.toStringArray(parameters2), null, true);
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "j2ee1_4.webservice.java";
    }

    public static String getAXIS2_PLATFORM() {
        return WSBundle.message("axis2.display.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onExceptionAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/xml/engines/axis2/Axis2WSEngine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deployWebService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undeployWebService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

