/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.engines.axis;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;

public class AxisSOAPMonitor {
    private final JPanel main_panel = new JPanel();
    private final JTabbedPane tabbed_pane;
    private final List<SOAPMonitorPage> pages;

    public AxisSOAPMonitor() {
        this.main_panel.setBackground((Color)JBColor.WHITE);
        this.main_panel.setLayout(new BorderLayout());
        this.tabbed_pane = new JBTabbedPane(1);
        this.main_panel.add((Component)this.tabbed_pane, "Center");
        this.pages = new ArrayList<SOAPMonitorPage>(1);
    }

    public boolean hasPageWithPort(int port) {
        for (SOAPMonitorPage page : this.pages) {
            if (page.getPort() != port) continue;
            return true;
        }
        return false;
    }

    public void addPage(int port) {
        if (this.hasPageWithPort(port)) {
            return;
        }
        SOAPMonitorPage pg = new SOAPMonitorPage(WebServicesPluginSettings.getInstance().getHostName(), port);
        this.addPage(pg);
        pg.start();
    }

    public JPanel getMainPanel() {
        return this.main_panel;
    }

    private void addPage(SOAPMonitorPage pg) {
        this.tabbed_pane.addTab("  " + pg.getHost() + "  ", pg);
        this.pages.add(pg);
    }

    static class SOAPMonitorTextArea
    extends JTextArea {
        private boolean format;
        private String original = "";
        private String formatted;

        SOAPMonitorTextArea() {
        }

        @Override
        public void setText(String text) {
            this.original = text;
            this.formatted = null;
            if (this.format) {
                this.doFormat();
                super.setText(this.formatted);
            } else {
                super.setText(this.original);
            }
        }

        public void setReflowXML(boolean reflow) {
            this.format = reflow;
            if (this.format) {
                if (this.formatted == null) {
                    this.doFormat();
                }
                super.setText(this.formatted);
            } else {
                super.setText(this.original);
            }
        }

        public void doFormat() {
            String part;
            int index;
            ArrayList<String> parts = new ArrayList<String>();
            char[] chars = this.original.toCharArray();
            int first = 0;
            for (index = 0; index < chars.length; ++index) {
                if (chars[index] == '<') {
                    if (first < index) {
                        part = new String(chars, first, index - first);
                        if (!(part = part.trim()).isEmpty()) {
                            parts.add(part);
                        }
                    }
                    first = index;
                }
                if (chars[index] == '>') {
                    part = new String(chars, first, index - first + 1);
                    parts.add(part);
                    first = index + 1;
                }
                if (chars[index] != '\n' && chars[index] != '\r') continue;
                if (first < index) {
                    part = new String(chars, first, index - first);
                    if (!(part = part.trim()).isEmpty()) {
                        parts.add(part);
                    }
                }
                first = index + 1;
            }
            StringBuilder buf = new StringBuilder();
            Object[] list = parts.toArray();
            int indent = 0;
            for (index = 0; index < list.length; ++index) {
                part = (String)list[index];
                if (buf.length() == 0) {
                    buf.append(part);
                    continue;
                }
                buf.append('\n');
                if (part.startsWith("</")) {
                    --indent;
                }
                for (int pad = 0; pad < indent; ++pad) {
                    buf.append("  ");
                }
                buf.append(part);
                if (!part.startsWith("<") || part.startsWith("</") || part.endsWith("/>")) continue;
                ++indent;
                if (index + 2 >= list.length || !(part = (String)list[index + 2]).startsWith("</") || (part = (String)list[index + 1]).startsWith("<")) continue;
                buf.append(part);
                part = (String)list[index + 2];
                buf.append(part);
                index += 2;
                --indent;
            }
            this.formatted = new String(buf);
        }
    }

    static class SOAPMonitorFilter
    implements ActionListener {
        private JDialog dialog;
        private JButton ok_button;
        private JButton cancel_button;
        private ServiceFilterPanel include_panel;
        private ServiceFilterPanel exclude_panel;
        private JCheckBox status_box;
        private JRadioButton status_active;
        private JRadioButton status_complete;
        private List<String> filter_include_list;
        private List<String> filter_exclude_list = new ArrayList<String>();
        private boolean filter_active;
        private boolean filter_complete;
        private boolean ok_pressed;

        SOAPMonitorFilter() {
            this.filter_exclude_list.add("NotificationService");
            this.filter_exclude_list.add("EventViewerService");
        }

        public List<String> getFilterIncludeList() {
            return this.filter_include_list;
        }

        public List<String> getFilterExcludeList() {
            return this.filter_exclude_list;
        }

        public boolean getFilterActive() {
            return this.filter_active;
        }

        public boolean getFilterComplete() {
            return this.filter_complete;
        }

        public void showDialog() {
            JBEmptyBorder empty_border = JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5);
            JBEmptyBorder indent_border = JBUI.Borders.empty((int)5, (int)25, (int)5, (int)5);
            this.include_panel = new ServiceFilterPanel(WSBundle.message("axis.monitor.include.messages", new Object[0]), this.filter_include_list);
            this.exclude_panel = new ServiceFilterPanel(WSBundle.message("axis.monitor.exclude.messages", new Object[0]), this.filter_exclude_list);
            this.status_box = new JCheckBox(WSBundle.message("axis.monitor.filter.by.status", new Object[0]));
            this.status_box.addActionListener(this);
            this.status_active = new JRadioButton(WSBundle.message("axis.monitor.filter.active.only", new Object[0]));
            this.status_active.setSelected(true);
            this.status_active.setEnabled(false);
            this.status_complete = new JRadioButton(WSBundle.message("axis.monitor.filter.complete.only", new Object[0]));
            this.status_complete.setEnabled(false);
            ButtonGroup status_group = new ButtonGroup();
            status_group.add(this.status_active);
            status_group.add(this.status_complete);
            if (this.filter_active || this.filter_complete) {
                this.status_box.setSelected(true);
                this.status_active.setEnabled(true);
                this.status_complete.setEnabled(true);
                if (this.filter_complete) {
                    this.status_complete.setSelected(true);
                }
            }
            JPanel status_options = new JPanel();
            status_options.setLayout(new BoxLayout(status_options, 1));
            status_options.add(this.status_active);
            status_options.add(this.status_complete);
            status_options.setBorder((Border)indent_border);
            JPanel status_panel = new JPanel();
            status_panel.setLayout(new BorderLayout());
            status_panel.add((Component)this.status_box, "North");
            status_panel.add((Component)status_options, "Center");
            status_panel.setBorder((Border)empty_border);
            this.ok_button = new JButton(WSBundle.message("axis.monitor.ok", new Object[0]));
            this.ok_button.addActionListener(this);
            this.cancel_button = new JButton(WSBundle.message("axis.monitor.cancel", new Object[0]));
            this.cancel_button.addActionListener(this);
            JPanel buttons = new JPanel();
            buttons.setLayout(new FlowLayout());
            buttons.add(this.ok_button);
            buttons.add(this.cancel_button);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(this.include_panel);
            panel.add(this.exclude_panel);
            panel.add(status_panel);
            panel.add(buttons);
            this.dialog = new JDialog();
            this.dialog.setTitle(WSBundle.message("axis.monitor.title", new Object[0]));
            this.dialog.setContentPane(panel);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setModal(true);
            this.dialog.pack();
            Dimension d = this.dialog.getToolkit().getScreenSize();
            this.dialog.setLocation((d.width - this.dialog.getWidth()) / 2, (d.height - this.dialog.getHeight()) / 2);
            this.ok_pressed = false;
            this.dialog.show();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.ok_button) {
                this.filter_include_list = this.include_panel.getServiceList();
                this.filter_exclude_list = this.exclude_panel.getServiceList();
                if (this.status_box.isSelected()) {
                    this.filter_active = this.status_active.isSelected();
                    this.filter_complete = this.status_complete.isSelected();
                } else {
                    this.filter_active = false;
                    this.filter_complete = false;
                }
                this.ok_pressed = true;
                this.dialog.dispose();
            }
            if (e.getSource() == this.cancel_button) {
                this.dialog.dispose();
            }
            if (e.getSource() == this.status_box) {
                this.status_active.setEnabled(this.status_box.isSelected());
                this.status_complete.setEnabled(this.status_box.isSelected());
            }
        }

        public boolean okPressed() {
            return this.ok_pressed;
        }
    }

    static class ServiceFilterPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener,
    DocumentListener {
        private final JCheckBox service_box;
        private final List<String> service_data;
        private final JList<String> service_list;
        private final JButton remove_service_button;
        private final JTextField add_service_field;
        private final JButton add_service_button;

        ServiceFilterPanel(@Nls String text, List<String> list) {
            JBEmptyBorder empty_border = JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5);
            JBEmptyBorder indent_border = JBUI.Borders.empty((int)5, (int)25, (int)5, (int)5);
            this.service_box = new JCheckBox(text);
            this.service_box.addActionListener(this);
            if (list != null) {
                this.service_box.setSelected(true);
                this.service_data = new ArrayList<String>(list);
            } else {
                this.service_data = new ArrayList<String>();
            }
            this.service_list = new JBList(this.service_data);
            this.service_list.setBorder(new EtchedBorder());
            this.service_list.setVisibleRowCount(5);
            this.service_list.addListSelectionListener(this);
            this.service_list.setEnabled(this.service_box.isSelected());
            JScrollPane service_scroll = ScrollPaneFactory.createScrollPane(this.service_list);
            service_scroll.setBorder(new EtchedBorder());
            this.remove_service_button = new JButton(WSBundle.message("axis.monitor.remove", new Object[0]));
            this.remove_service_button.addActionListener(this);
            this.remove_service_button.setEnabled(false);
            JPanel remove_service_panel = new JPanel();
            remove_service_panel.setLayout(new FlowLayout());
            remove_service_panel.add(this.remove_service_button);
            JPanel service_area = new JPanel();
            service_area.setLayout(new BorderLayout());
            service_area.add((Component)service_scroll, "Center");
            service_area.add((Component)remove_service_panel, "East");
            service_area.setBorder((Border)indent_border);
            this.add_service_field = new JTextField();
            this.add_service_field.addActionListener(this);
            this.add_service_field.getDocument().addDocumentListener(this);
            this.add_service_field.setEnabled(this.service_box.isSelected());
            this.add_service_button = new JButton(WSBundle.message("axis.monitor.add", new Object[0]));
            this.add_service_button.addActionListener(this);
            this.add_service_button.setEnabled(false);
            JPanel add_service_panel = new JPanel();
            add_service_panel.setLayout(new BorderLayout());
            JPanel dummy = new JPanel();
            dummy.setBorder((Border)empty_border);
            add_service_panel.add((Component)dummy, "West");
            add_service_panel.add((Component)this.add_service_button, "East");
            JPanel add_service_area = new JPanel();
            add_service_area.setLayout(new BorderLayout());
            add_service_area.add((Component)this.add_service_field, "Center");
            add_service_area.add((Component)add_service_panel, "East");
            add_service_area.setBorder((Border)indent_border);
            this.setLayout(new BorderLayout());
            this.add((Component)this.service_box, "North");
            this.add((Component)service_area, "Center");
            this.add((Component)add_service_area, "South");
            this.setBorder((Border)empty_border);
        }

        public List<String> getServiceList() {
            if (this.service_box.isSelected()) {
                return this.service_data;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.service_box) {
                this.service_list.setEnabled(this.service_box.isSelected());
                this.service_list.clearSelection();
                this.remove_service_button.setEnabled(false);
                this.add_service_field.setEnabled(this.service_box.isSelected());
                this.add_service_field.setText("");
                this.add_service_button.setEnabled(false);
            }
            if (e.getSource() == this.add_service_button || e.getSource() == this.add_service_field) {
                String text = this.add_service_field.getText();
                if (text != null && text.length() > 0) {
                    this.service_data.add(text);
                    this.service_list.setListData((String[])this.service_data.toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
                }
                this.add_service_field.setText("");
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.add_service_field, true));
            }
            if (e.getSource() == this.remove_service_button) {
                for (String sel : this.service_list.getSelectedValuesList()) {
                    this.service_data.remove(sel);
                }
                this.service_list.setListData((String[])this.service_data.toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
                this.service_list.clearSelection();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String text = this.add_service_field.getText();
            if (text != null && !text.isEmpty()) {
                this.add_service_button.setEnabled(true);
            } else {
                this.add_service_button.setEnabled(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.service_list.getSelectedIndex() == -1) {
                this.remove_service_button.setEnabled(false);
            } else {
                this.remove_service_button.setEnabled(true);
            }
        }
    }

    static class SOAPMonitorTableModel
    extends AbstractTableModel {
        private final String[] column_names = new String[]{"Time", "Target Service", "Status"};
        private final List<SOAPMonitorData> data = new ArrayList<SOAPMonitorData>();
        private List<String> filter_include;
        private List<String> filter_exclude;
        private boolean filter_active;
        private boolean filter_complete;
        private List<SOAPMonitorData> filter_data;

        SOAPMonitorTableModel() {
            SOAPMonitorData soap = new SOAPMonitorData(null, null, null);
            this.data.add(soap);
            this.filter_include = null;
            this.filter_exclude = null;
            this.filter_active = false;
            this.filter_complete = false;
            this.filter_data = null;
            this.filter_exclude = new ArrayList<String>();
            this.filter_exclude.add("NotificationService");
            this.filter_exclude.add("EventViewerService");
            this.filter_data = new ArrayList<SOAPMonitorData>();
            this.filter_data.add(soap);
        }

        @Override
        public int getColumnCount() {
            return this.column_names.length;
        }

        @Override
        public int getRowCount() {
            int count = this.data.size();
            if (this.filter_data != null) {
                count = this.filter_data.size();
            }
            return count;
        }

        @Override
        public String getColumnName(int col) {
            return this.column_names[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            String value = null;
            SOAPMonitorData soap = this.data.get(row);
            if (this.filter_data != null) {
                soap = this.filter_data.get(row);
            }
            switch (col) {
                case 0: {
                    value = soap.getTime();
                    break;
                }
                case 1: {
                    value = soap.getTargetService();
                    break;
                }
                case 2: {
                    value = soap.getStatus();
                }
            }
            return value;
        }

        public boolean filterMatch(SOAPMonitorData soap) {
            String service;
            Iterator<String> e;
            boolean match = true;
            if (this.filter_include != null) {
                e = this.filter_include.iterator();
                match = false;
                while (e.hasNext() && !match) {
                    service = e.next();
                    if (!service.equals(soap.getTargetService())) continue;
                    match = true;
                }
            }
            if (this.filter_exclude != null) {
                e = this.filter_exclude.iterator();
                while (e.hasNext() && match) {
                    service = e.next();
                    if (!service.equals(soap.getTargetService())) continue;
                    match = false;
                }
            }
            if (this.filter_active && soap.getSOAPResponse() != null) {
                match = false;
            }
            if (this.filter_complete && soap.getSOAPResponse() == null) {
                match = false;
            }
            if (soap.getId() == null) {
                match = true;
            }
            return match;
        }

        public void addData(SOAPMonitorData soap) {
            int row = this.data.size();
            this.data.add(soap);
            if (this.filter_data != null) {
                if (this.filterMatch(soap)) {
                    row = this.filter_data.size();
                    this.filter_data.add(soap);
                    this.fireTableRowsInserted(row, row);
                }
            } else {
                this.fireTableRowsInserted(row, row);
            }
        }

        public SOAPMonitorData findData(Long id) {
            SOAPMonitorData soap = null;
            for (int row = this.data.size(); row > 0 && soap == null; --row) {
                soap = this.data.get(row - 1);
                if (soap.getId().longValue() == id.longValue()) continue;
                soap = null;
            }
            return soap;
        }

        public int findRow(SOAPMonitorData soap) {
            if (this.filter_data != null) {
                return this.filter_data.indexOf(soap);
            }
            return this.data.indexOf(soap);
        }

        public void clearAll() {
            int last_row = this.data.size() - 1;
            if (last_row > 0) {
                this.data.clear();
                SOAPMonitorData soap = new SOAPMonitorData(null, null, null);
                this.data.add(soap);
                if (this.filter_data != null) {
                    this.filter_data.clear();
                    this.filter_data.add(soap);
                }
                this.fireTableDataChanged();
            }
        }

        public void removeRow(int row) {
            SOAPMonitorData soap = this.filter_data == null ? this.data.get(row) : this.filter_data.remove(row);
            this.data.remove(soap);
            this.fireTableRowsDeleted(row, row);
        }

        public void setFilter(SOAPMonitorFilter filter) {
            this.filter_include = filter.getFilterIncludeList();
            this.filter_exclude = filter.getFilterExcludeList();
            this.filter_active = filter.getFilterActive();
            this.filter_complete = filter.getFilterComplete();
            this.applyFilter();
        }

        public void applyFilter() {
            this.filter_data = null;
            if (this.filter_include != null || this.filter_exclude != null || this.filter_active || this.filter_complete) {
                this.filter_data = new ArrayList<SOAPMonitorData>();
                for (SOAPMonitorData datum : this.data) {
                    SOAPMonitorData soap = datum;
                    if (!this.filterMatch(soap)) continue;
                    this.filter_data.add(soap);
                }
            }
            this.fireTableDataChanged();
        }

        public SOAPMonitorData getData(int row) {
            if (this.filter_data == null) {
                return this.data.get(row);
            }
            return this.filter_data.get(row);
        }

        public void updateData(SOAPMonitorData soap) {
            if (this.filter_data == null) {
                int row = this.data.indexOf(soap);
                if (row != -1) {
                    this.fireTableRowsUpdated(row, row);
                }
            } else {
                int row = this.filter_data.indexOf(soap);
                if (row == -1) {
                    if (this.filterMatch(soap)) {
                        int index = -1;
                        for (row = this.data.indexOf(soap) + 1; row < this.data.size() && index == -1; ++row) {
                            index = this.filter_data.indexOf(this.data.get(row));
                            if (index == -1) continue;
                            this.filter_data.add(index, soap);
                        }
                        if (index == -1) {
                            index = this.filter_data.size();
                            this.filter_data.add(soap);
                        }
                        this.fireTableRowsInserted(index, index);
                    }
                } else if (this.filterMatch(soap)) {
                    this.fireTableRowsUpdated(row, row);
                } else {
                    this.filter_data.remove(soap);
                    this.fireTableRowsDeleted(row, row);
                }
            }
        }
    }

    static class SOAPMonitorData {
        private final Long id;
        private final String time;
        private final String target;
        private final String soap_request;
        private String soap_response;

        SOAPMonitorData(Long id, String target, String soap_request) {
            this.id = id;
            if (id == null) {
                this.time = "Most Recent";
                this.target = "---";
                this.soap_request = null;
            } else {
                this.time = DateFormat.getTimeInstance().format(new Date());
                this.target = target;
                this.soap_request = soap_request;
            }
            this.soap_response = null;
        }

        public Long getId() {
            return this.id;
        }

        @NlsSafe
        public String getTime() {
            return this.time;
        }

        @NlsSafe
        public String getTargetService() {
            return this.target;
        }

        @Nls
        public String getStatus() {
            String status = "---";
            if (this.id != null) {
                status = WSBundle.message("axis.monitor.response.complete", new Object[0]);
                if (this.soap_response == null) {
                    status = WSBundle.message("axis.monitor.response.active", new Object[0]);
                }
            }
            return status;
        }

        public String getSOAPRequest() {
            return this.soap_request;
        }

        public void setSOAPResponse(String response) {
            this.soap_response = response;
        }

        public String getSOAPResponse() {
            return this.soap_response;
        }
    }

    static class SOAPMonitorPage
    extends JPanel
    implements Runnable,
    ListSelectionListener,
    ActionListener {
        private final String host;
        private Socket socket;
        private ObjectInputStream in;
        private ObjectOutputStream out;
        private final SOAPMonitorTableModel model;
        private final JTable table;
        private final JButton remove_button;
        private final JButton remove_all_button;
        private final JButton filter_button;
        private final JPanel details_panel;
        private JSplitPane details_soap;
        private final JLabel details_time_value;
        private final JLabel details_target_value;
        private final JLabel details_status_value;
        private final JPanel request_panel;
        private final JPanel response_panel;
        private final SOAPMonitorTextArea request_text;
        private final SOAPMonitorTextArea response_text;
        private final JButton layout_button;
        private final JButton start_button;
        private final JButton stop_button;
        private final JLabel status_text;
        private final SOAPMonitorFilter filter;
        private final JCheckBox reflow_xml;
        private final int port;

        SOAPMonitorPage(String host_name, int _port) {
            this.host = host_name;
            this.port = _port;
            this.filter = new SOAPMonitorFilter();
            EtchedBorder etched_border = new EtchedBorder();
            this.model = new SOAPMonitorTableModel();
            this.table = new JBTable((TableModel)this.model);
            this.table.setSelectionMode(0);
            this.table.setRowSelectionInterval(0, 0);
            this.table.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)600, (int)96));
            this.table.getSelectionModel().addListSelectionListener(this);
            JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)this.table);
            this.remove_button = new JButton(WSBundle.message("axis.monitor.remove", new Object[0]));
            this.remove_button.addActionListener(this);
            this.remove_button.setEnabled(false);
            this.remove_all_button = new JButton(WSBundle.message("axis.monitor.remove.all", new Object[0]));
            this.remove_all_button.addActionListener(this);
            this.filter_button = new JButton(WSBundle.message("axis.monitor.filter.options", new Object[0]));
            this.filter_button.addActionListener(this);
            JPanel list_buttons = new JPanel();
            list_buttons.setLayout(new FlowLayout());
            list_buttons.add(this.remove_button);
            list_buttons.add(this.remove_all_button);
            list_buttons.add(this.filter_button);
            JPanel list_panel = new JPanel();
            list_panel.setLayout(new BorderLayout());
            list_panel.add((Component)scroll, "Center");
            list_panel.add((Component)list_buttons, "South");
            list_panel.setBorder(null);
            JLabel details_time = new JLabel(WSBundle.message("axis.monitor.time", new Object[0]), 4);
            JLabel details_target = new JLabel(WSBundle.message("axis.monitor.target.service", new Object[0]), 4);
            JLabel details_status = new JLabel(WSBundle.message("axis.monitor.status", new Object[0]), 4);
            this.details_time_value = new JLabel();
            this.details_target_value = new JLabel();
            this.details_status_value = new JLabel();
            Dimension preferred_size = details_time.getPreferredSize();
            preferred_size.width = 1;
            details_time.setPreferredSize(preferred_size);
            details_target.setPreferredSize(preferred_size);
            details_status.setPreferredSize(preferred_size);
            this.details_time_value.setPreferredSize(preferred_size);
            this.details_target_value.setPreferredSize(preferred_size);
            this.details_status_value.setPreferredSize(preferred_size);
            JPanel details_header = new JPanel();
            GridBagLayout details_header_layout = new GridBagLayout();
            details_header.setLayout(details_header_layout);
            GridBagConstraints details_header_constraints = new GridBagConstraints();
            details_header_constraints.fill = 1;
            details_header_constraints.weightx = 0.5;
            details_header_layout.setConstraints(details_time, details_header_constraints);
            details_header.add(details_time);
            details_header_layout.setConstraints(this.details_time_value, details_header_constraints);
            details_header.add(this.details_time_value);
            details_header_layout.setConstraints(details_target, details_header_constraints);
            details_header.add(details_target);
            details_header_constraints.weightx = 1.0;
            details_header_layout.setConstraints(this.details_target_value, details_header_constraints);
            details_header.add(this.details_target_value);
            details_header_constraints.weightx = 0.5;
            details_header_layout.setConstraints(details_status, details_header_constraints);
            details_header.add(details_status);
            details_header_layout.setConstraints(this.details_status_value, details_header_constraints);
            details_header.add(this.details_status_value);
            details_header.setBorder(etched_border);
            JLabel request_label = new JLabel(WSBundle.message("axis.monitor.soap.request", new Object[0]), 0);
            this.request_text = new SOAPMonitorTextArea();
            this.request_text.setEditable(false);
            JScrollPane request_scroll = ScrollPaneFactory.createScrollPane((Component)this.request_text);
            this.request_panel = new JPanel();
            this.request_panel.setLayout(new BorderLayout());
            this.request_panel.add((Component)request_label, "North");
            this.request_panel.add((Component)request_scroll, "Center");
            JLabel response_label = new JLabel(WSBundle.message("axis.monitor.soap.response", new Object[0]), 0);
            this.response_text = new SOAPMonitorTextArea();
            this.response_text.setEditable(false);
            JScrollPane response_scroll = ScrollPaneFactory.createScrollPane((Component)this.response_text);
            this.response_panel = new JPanel();
            this.response_panel.setLayout(new BorderLayout());
            this.response_panel.add((Component)response_label, "North");
            this.response_panel.add((Component)response_scroll, "Center");
            this.details_soap = new JSplitPane(1);
            this.details_soap.setTopComponent(this.request_panel);
            this.details_soap.setRightComponent(this.response_panel);
            this.details_soap.setResizeWeight(0.5);
            this.details_panel = new JPanel();
            this.layout_button = new JButton(WSBundle.message("axis.monitor.switch.layout", new Object[0]));
            this.layout_button.addActionListener(this);
            this.reflow_xml = new JCheckBox(WSBundle.message("axis.monitor.reflow.xml", new Object[0]));
            this.reflow_xml.addActionListener(this);
            JPanel details_buttons = new JPanel();
            details_buttons.setLayout(new FlowLayout());
            details_buttons.add(this.reflow_xml);
            details_buttons.add(this.layout_button);
            this.details_panel.setLayout(new BorderLayout());
            this.details_panel.add((Component)details_header, "North");
            this.details_panel.add((Component)this.details_soap, "Center");
            this.details_panel.add((Component)details_buttons, "South");
            this.details_panel.setBorder(null);
            JSplitPane split = new JSplitPane(0);
            split.setTopComponent(list_panel);
            split.setRightComponent(this.details_panel);
            this.start_button = new JButton(WSBundle.message("axis.monitor.start", new Object[0]));
            this.start_button.addActionListener(this);
            this.stop_button = new JButton(WSBundle.message("axis.monitor.stop", new Object[0]));
            this.stop_button.addActionListener(this);
            JPanel status_buttons = new JPanel();
            status_buttons.setLayout(new FlowLayout());
            status_buttons.add(this.start_button);
            status_buttons.add(this.stop_button);
            this.status_text = new JLabel();
            this.status_text.setBorder(new BevelBorder(1));
            JPanel status_text_panel = new JPanel();
            status_text_panel.setLayout(new BorderLayout());
            status_text_panel.add((Component)this.status_text, "Center");
            status_text_panel.setBorder(null);
            JPanel status_area = new JPanel();
            status_area.setLayout(new BorderLayout());
            status_area.add((Component)status_buttons, "West");
            status_area.add((Component)status_text_panel, "Center");
            status_area.setBorder(etched_border);
            this.setLayout(new BorderLayout());
            this.add((Component)split, "Center");
            this.add((Component)status_area, "South");
        }

        public int getPort() {
            return this.port;
        }

        @NlsSafe
        public String getHost() {
            return this.host;
        }

        public void setStatus(@Nls String txt) {
            this.status_text.setForeground(JBColor.foreground());
            this.status_text.setText("  " + txt);
        }

        public void setErrorStatus(@Nls String txt) {
            this.status_text.setForeground((Color)JBColor.RED);
            this.status_text.setText("  " + txt);
        }

        public void start() {
            if (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, this.port);
                    this.out = new ObjectOutputStream(this.socket.getOutputStream());
                    this.out.flush();
                    this.in = new ObjectInputStream(this.socket.getInputStream());
                    new Thread((Runnable)this, "axis soap monitor").start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setErrorStatus(WSBundle.message("axis.monitor.status.no.connect", new Object[0]));
                    this.socket = null;
                }
            }
            if (this.socket != null) {
                this.start_button.setEnabled(false);
                this.stop_button.setEnabled(true);
                this.setStatus(WSBundle.message("axis.monitor.status.active", new Object[0]));
            }
        }

        public void stop() {
            if (this.socket != null) {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.out = null;
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.in = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
            this.setStatus(WSBundle.message("axis.monitor.status.stopped", new Object[0]));
        }

        @Override
        public void run() {
            while (this.socket != null) {
                try {
                    Integer message_type = (Integer)this.in.readObject();
                    switch (message_type) {
                        case 0: {
                            Long id = (Long)this.in.readObject();
                            String target = (String)this.in.readObject();
                            String soap = (String)this.in.readObject();
                            SOAPMonitorData data = new SOAPMonitorData(id, target, soap);
                            this.model.addData(data);
                            int selected = this.table.getSelectedRow();
                            if (selected != 0 || !this.model.filterMatch(data)) break;
                            this.valueChanged(null);
                            break;
                        }
                        case 1: {
                            int row;
                            Long id = (Long)this.in.readObject();
                            String soap = (String)this.in.readObject();
                            SOAPMonitorData data = this.model.findData(id);
                            if (data == null) break;
                            boolean update_needed = false;
                            int selected = this.table.getSelectedRow();
                            if (selected == 0) {
                                update_needed = true;
                            }
                            if ((row = this.model.findRow(data)) != -1 && row == selected) {
                                update_needed = true;
                            }
                            data.setSOAPResponse(soap);
                            this.model.updateData(data);
                            if (!update_needed) break;
                            this.valueChanged(null);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.stop_button.isEnabled()) continue;
                    this.stop();
                    this.setErrorStatus(WSBundle.message("axis.monitor.status.closed", new Object[0]));
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = this.table.getSelectedRow();
            if (row > 0) {
                this.remove_button.setEnabled(true);
            } else {
                this.remove_button.setEnabled(false);
            }
            if (row == 0 && (row = this.model.getRowCount() - 1) == 0) {
                row = -1;
            }
            if (row == -1) {
                this.details_time_value.setText("");
                this.details_target_value.setText("");
                this.details_status_value.setText("");
                this.request_text.setText("");
                this.response_text.setText("");
            } else {
                SOAPMonitorData soap = this.model.getData(row);
                this.details_time_value.setText(soap.getTime());
                this.details_target_value.setText(soap.getTargetService());
                this.details_status_value.setText(soap.getStatus());
                if (soap.getSOAPRequest() == null) {
                    this.request_text.setText("");
                } else {
                    this.request_text.setText(soap.getSOAPRequest());
                    this.request_text.setCaretPosition(0);
                }
                if (soap.getSOAPResponse() == null) {
                    this.response_text.setText("");
                } else {
                    this.response_text.setText(soap.getSOAPResponse());
                    this.response_text.setCaretPosition(0);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.remove_button) {
                int row = this.table.getSelectedRow();
                this.model.removeRow(row);
                this.table.clearSelection();
                this.table.repaint();
                this.valueChanged(null);
            }
            if (e.getSource() == this.remove_all_button) {
                this.model.clearAll();
                this.table.setRowSelectionInterval(0, 0);
                this.table.repaint();
                this.valueChanged(null);
            }
            if (e.getSource() == this.filter_button) {
                this.filter.showDialog();
                if (this.filter.okPressed()) {
                    this.model.setFilter(this.filter);
                    this.table.repaint();
                }
            }
            if (e.getSource() == this.start_button) {
                this.start();
            }
            if (e.getSource() == this.stop_button) {
                this.stop();
            }
            if (e.getSource() == this.layout_button) {
                this.details_panel.remove(this.details_soap);
                this.details_soap.removeAll();
                this.details_soap = this.details_soap.getOrientation() == 1 ? new JSplitPane(0) : new JSplitPane(1);
                this.details_soap.setTopComponent(this.request_panel);
                this.details_soap.setRightComponent(this.response_panel);
                this.details_soap.setResizeWeight(0.5);
                this.details_panel.add((Component)this.details_soap, "Center");
                this.details_panel.validate();
                this.details_panel.repaint();
            }
            if (e.getSource() == this.reflow_xml) {
                this.request_text.setReflowXML(this.reflow_xml.isSelected());
                this.response_text.setReflowXML(this.reflow_xml.isSelected());
            }
        }
    }
}

