/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.actions;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.actions.WebServicePlatformUtils;
import com.intellij.ws.xml.engines.wsengine.DialogWithWebServicePlatform;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.engines.wsengine.WSEngineManager;
import com.intellij.ws.xml.utils.ui.MyDialogWrapper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndeployWebServiceDialog
extends MyDialogWrapper
implements DialogWithWebServicePlatform {
    private ComboBox webServicePlatform;
    private JLabel webServicePlatformText;
    private JPanel myPanel;
    private WSEngine currentEngine;
    private JLabel myWSNameText;
    private ComboBox myTargetModule;
    private JLabel myTargetModuleText;
    private ComboBox myWSName;

    public UndeployWebServiceDialog(Project project, @Nullable UndeployWebServiceDialog previousDialog) {
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("remove.web.service.dialog.title", objectArray));
        this.doInitFor(this.myWSNameText, (JComponent)this.myWSName, 'W');
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        LinkedList<Module> modulesList = new LinkedList<Module>();
        for (Module module : modules) {
            if (!CommonWsUtils.isWebModule(module)) continue;
            modulesList.add(module);
        }
        this.myTargetModule.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(modulesList)));
        if (modulesList.size() > 0) {
            this.myTargetModule.setSelectedIndex(0);
        }
        this.doInitFor(this.myTargetModuleText, (JComponent)this.myTargetModule, 'M');
        this.myTargetModule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    UndeployWebServiceDialog.this.setupAvailableServices();
                }
            }
        });
        if (previousDialog != null) {
            this.myTargetModule.setSelectedItem(previousDialog.myTargetModule.getSelectedItem());
            this.myWSName.setSelectedItem(previousDialog.myWSName.getSelectedItem());
        }
        WebServicePlatformUtils.initWSPlatforms(this);
        this.setupWSPlatformSpecificFields();
        this.init();
    }

    public void preselect(Module module, @NlsSafe String service) {
        this.myTargetModule.setSelectedItem((Object)module);
        this.myWSName.setSelectedItem((Object)service);
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        ValidationInfo result = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(this, this.currentEngine);
        if (result != null) {
            return result;
        }
        ValidationData data = new ValidationData();
        data.acquire();
        if (data.module == null) {
            return new ValidationInfo(WSBundle.message("invalid.web.module.selected.validation.message", new Object[0]), (JComponent)this.myTargetModule);
        }
        if (data.wsName == null) {
            return new ValidationInfo(WSBundle.message("invalid.web.service.selected.validation.message", new Object[0]), (JComponent)this.myWSName);
        }
        return null;
    }

    @Override
    protected MyDialogWrapper.ValidationData createValidationData() {
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    public JComboBox getWebServicePlatformCombo() {
        return this.webServicePlatform;
    }

    @Override
    public JLabel getWebServicePlaformText() {
        return this.webServicePlatformText;
    }

    @Override
    public void setupWSPlatformSpecificFields() {
        String currentPlatform = (String)this.webServicePlatform.getSelectedItem();
        this.currentEngine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(currentPlatform);
        this.setupAvailableServices();
    }

    @Override
    public Module getSelectedModule() {
        return (Module)this.myTargetModule.getSelectedItem();
    }

    @Override
    public JComboBox getModuleChooser() {
        return this.myTargetModule;
    }

    @Override
    public String[] getAvailableEngineNames() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        WSEngineManager engineManager = instance.getEngineManager();
        return engineManager.getAvailableWSEngineNamesWithSupportedDeployment();
    }

    private void setupAvailableServices() {
        Module module = (Module)this.myTargetModule.getSelectedItem();
        this.myWSName.setModel(new DefaultComboBoxModel<Object>(module != null ? this.currentEngine.getAvailableWebServices(module) : ArrayUtilRt.EMPTY_OBJECT_ARRAY));
    }

    public WSEngine getCurrentEngine() {
        return this.currentEngine;
    }

    protected void doOKAction() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        instance.setLastPlatform(this.getWebServicePlatformCombo().getSelectedItem().toString());
        super.doOKAction();
    }

    @Override
    @NonNls
    @NotNull
    protected String getHelpId() {
        return "UndeployWebServices.html";
    }

    public String getWSName() {
        return this.myWSName.getSelectedItem().toString();
    }

    public Module getWsModule() {
        return (Module)this.myTargetModule.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JLabel jLabel2;
        ComboBox comboBox2;
        JLabel jLabel3;
        ComboBox comboBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.webServicePlatform = comboBox3 = new ComboBox();
        comboBox3.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.wstoolkit.tooltip"));
        jPanel.add((Component)comboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myWSNameText = jLabel3 = new JLabel();
        jLabel3.setInheritsPopupMenu(true);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WSBundle", UndeployWebServiceDialog.class).getString("webservice.name"));
        jLabel3.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.name.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetModule = comboBox2 = new ComboBox();
        comboBox2.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.name.of.module.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.webServicePlatformText = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WSBundle", UndeployWebServiceDialog.class).getString("webservice.platform"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.wstoolkit.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetModuleText = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WSBundle", UndeployWebServiceDialog.class).getString("webservice.web.module"));
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.name.of.module.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWSName = comboBox = new ComboBox();
        comboBox.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.name.of.module.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    class ValidationData
    extends MyDialogWrapper.ValidationData {
        Module module;
        String wsName;

        ValidationData() {
        }

        @Override
        protected void doAcquire() {
            this.module = (Module)UndeployWebServiceDialog.this.myTargetModule.getSelectedItem();
            this.wsName = (String)UndeployWebServiceDialog.this.myWSName.getSelectedItem();
        }
    }
}

