/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.common.BaseWSAction;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPlugin;
import com.intellij.ws.xml.actions.ShowDeployedWebSevicesDialog;
import com.intellij.ws.xml.engines.axis.AxisUtil;
import com.intellij.ws.xml.engines.jsdwp.JWSDPWSEngine;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.references.WSDLReferenceProvider;
import com.intellij.ws.xml.utils.WsModuleUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

public class ShowDeployedWebServicesAction
extends BaseWSAction {
    private static final Logger LOG = Logger.getInstance(ShowDeployedWebServicesAction.class);

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDeployedWebServicesAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module != null && CommonWsUtils.isWebModule(module)) {
            presentation.setEnabled(WsModuleUtil.getEngineFromModule(module) instanceof JWSDPWSEngine);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Project project;
        if (anActionEvent == null) {
            ShowDeployedWebServicesAction.$$$reportNull$$$0(1);
        }
        if ((project = anActionEvent.getProject()) == null) {
            return;
        }
        ShowDeployedWebSevicesDialog dialog = new ShowDeployedWebSevicesDialog(project, WSBundle.message("show.deployed.web.services.dialog.title", new Object[0]), "ShowDeployedWebServices.html", null);
        if (dialog.showAndGet()) {
            String contextName = dialog.getContextName();
            WebServicesPlugin plugin = WebServicesPlugin.getInstance(project);
            plugin.addLastContext(contextName);
            Module module = (Module)anActionEvent.getData(LangDataKeys.MODULE);
            WSEngine wsEngine = WsModuleUtil.getEngineFromModule(module);
            LOG.assertTrue(wsEngine != null);
            String[] services = wsEngine.getAvailableWebServices(module);
            ShowDeployedWebServicesAction.getWebServices(project, contextName, services).onSuccess(wsdlWebServices -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                ArrayList<String> wsdlUrlList = new ArrayList<String>();
                ArrayList<String> wsdlList = new ArrayList<String>();
                for (WsdlWebService wsItem : wsdlWebServices) {
                    wsdlUrlList.add(AxisUtil.getWebServiceUrlReference(contextName, wsItem.getServiceName()) + "?wsdl");
                    wsdlList.add(wsItem.getWsdl());
                }
                ShowDeployedWebServicesAction.showWebServicesPage(project, wsdlUrlList, wsdlList);
            }));
        }
    }

    private static AsyncPromise<List<WsdlWebService>> getWebServices(Project project, String contextName, String[] services) {
        final List loaders = ContainerUtil.map((Object[])services, ws -> AxisUtil.getServiceWsdlLoader(contextName, ws));
        final AsyncPromise promise = new AsyncPromise();
        new Task.Modal(project, WSBundle.message("show.deployed.web.services.loading", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                List wsdlWebServices = ContainerUtil.map((Collection)loaders, loader -> {
                    indicator.checkCanceled();
                    return new WsdlWebService(loader.getServiceName(), loader.loadWsdlFromService());
                });
                indicator.checkCanceled();
                promise.setResult((Object)wsdlWebServices);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/xml/actions/ShowDeployedWebServicesAction$1", "run"));
            }
        }.queue();
        return promise;
    }

    private static void showWebServicesPage(Project project, List<String> wsdlUrlList, List<String> wsdlList) {
        if (wsdlList.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)WSBundle.message("webservices.deploy.no.deployed.services", new Object[0]), (String)WSBundle.message("webservices.deploy.info", new Object[0]));
            return;
        }
        @NonNls StringBuilder text = new StringBuilder();
        text.append(String.format("<h2>%s</h2>", WSBundle.message("webservices.list.header", new Object[0])));
        text.append("<ul>\n");
        for (int i = 0; i < wsdlUrlList.size(); ++i) {
            XmlTag[] wsdlTags;
            XmlTag rootTag;
            String wsdlUrl = wsdlUrlList.get(i);
            String wsdl = StringUtil.defaultIfEmpty((String)wsdlList.get(i), (String)"");
            int qPos = wsdlUrl.lastIndexOf("?");
            int sPos = wsdlUrl.lastIndexOf(47, qPos);
            String serviceName = wsdlUrl.substring(sPos + 1, qPos);
            text.append("<li>").append(serviceName).append(" <a href=\"").append(wsdlUrl).append("\">").append("<i>wsdl</i>").append("</a></li>");
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)project).createFileFromText("__1.wsdl", wsdl);
            if (!(fileFromText instanceof XmlFile)) continue;
            XmlDocument document = ((XmlFile)fileFromText).getDocument();
            XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
            if (rootTag == null) continue;
            for (XmlTag t : wsdlTags = WSDLReferenceProvider.getWsdlTags(rootTag, "portType")) {
                XmlTag[] operations;
                if (!serviceName.equals(t.getAttributeValue("name"))) continue;
                for (XmlTag o : operations = WSDLReferenceProvider.getWsdlTags(t, "operation")) {
                    String name = o.getAttributeValue("name");
                    if (name == null) continue;
                    text.append("<ul><li>").append(name).append("</ul>\n");
                }
            }
        }
        text.append("</ul></html>");
        try {
            File tempFile = FileUtil.createTempFile((String)"url", (String)".html");
            tempFile.deleteOnExit();
            FileUtil.writeToFile((File)tempFile, (String)text.toString());
            BrowserUtil.browse((URI)tempFile.toURI());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anActionEvent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/xml/actions/ShowDeployedWebServicesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WsdlWebService {
        private final String myServiceName;
        private final String myWsdl;

        private WsdlWebService(String serviceName, String wsdl) {
            this.myServiceName = serviceName;
            this.myWsdl = wsdl;
        }

        private String getServiceName() {
            return this.myServiceName;
        }

        private String getWsdl() {
            return this.myWsdl;
        }
    }
}

