/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.Consumer;
import com.intellij.ws.common.BaseWSFromFileAction;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.ExternalProcessHandler;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.WebServicesPluginSettings;
import com.intellij.ws.xml.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.xml.actions.GenerateJavaFromWsdlDialog;
import com.intellij.ws.xml.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.utils.LibUtils;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateJavaFromWsdlAction
extends BaseWSFromFileAction {
    @NonNls
    static final String WSDL_EXTENSION = "wsdl";
    @NonNls
    static final String WADL_EXTENSION = "wadl";

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            GenerateJavaFromWsdlAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = event.getDataContext();
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        GenerateJavaFromWsdlAction.runAction(project, null, null, null, dataContext);
    }

    public static void runAction(Project project, @Nullable GenerateJavaFromWsdlDialog previousDialog, @Nullable Module module, Runnable onSuccess, final DataContext dataContext) {
        GenerateJavaFromWsdlDialog dialog = new GenerateJavaFromWsdlDialog(project, previousDialog, module, onSuccess){

            @Override
            protected DataContext getDataContext() {
                return dataContext != null ? dataContext : super.getDataContext();
            }
        };
        if (dialog.showAndGet()) {
            GenerateJavaFromWsdlAction.doOkAction(project, dialog);
        }
    }

    public static void doOkAction(Project project, GenerateJavaFromWsdlDialog dialog) {
        GenerateJavaFromWsdlAction.doOkAction(project, dialog, true);
    }

    public static void doOkAction(final Project project, final GenerateJavaFromWsdlDialog dialog, boolean requestFocusInProjectView) {
        FileDocumentManager.getInstance().saveAllDocuments();
        LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("generate.java.wsdl.action", new Object[0]));
        String packagePrefix = ((EditorComboBox)dialog.packagePrefix).getText();
        if (packagePrefix != null) {
            packagePrefix = packagePrefix.trim();
        }
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        if (packagePrefix != null && packagePrefix.length() == 0) {
            packagePrefix = null;
        }
        if (packagePrefix != null) {
            instance.addLastPackagePrefix(packagePrefix);
        }
        final String wsdlUrl = ((String)dialog.wsdlUrl.getComboBox().getSelectedItem()).trim();
        instance.addLastWsdlUrl(wsdlUrl);
        final String packagePrefix1 = packagePrefix;
        Consumer onException = e -> {
            String message = e.getMessage();
            if (message != null && StringUtil.toLowerCase((String)message).startsWith("warning")) {
                return;
            }
            Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
        };
        try {
            final String outputPath = (String)dialog.outputPathes.getSelectedItem();
            WSEngine currentWsEngine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(dialog.getWebServicePlatform());
            final Module currentModule = LibUtils.findModuleByOutputPath(project, outputPath);
            final String bindingType = dialog.getBindingType();
            final File savedWsdl = LibUtils.saveSourceGeneratedFile(wsdlUrl, outputPath, packagePrefix);
            final boolean serverSideGeneration = dialog.outputMode.getSelectedItem().equals("server");
            ExternalProcessHandler wsdlHandler = currentWsEngine.getGenerateJavaFromWsdlHandler(new GenerateJavaFromWsdlOptions(){

                @Override
                public String getPackagePrefix() {
                    return packagePrefix1;
                }

                @Override
                public String getWsdlUrl() {
                    return wsdlUrl;
                }

                @Override
                public String getOutputPath() {
                    return outputPath;
                }

                @Override
                public String getBindingType() {
                    return bindingType;
                }

                @Override
                public boolean isServersideSkeletonGeneration() {
                    return serverSideGeneration;
                }

                @Override
                public boolean isToGenerateTestCase() {
                    return dialog.generateTestCase.isSelected();
                }

                @Override
                public String getUser() {
                    return dialog.user.getText();
                }

                @Override
                public char[] getPassword() {
                    return dialog.password.getPassword();
                }

                @Override
                public boolean generateClassesForArrays() {
                    return dialog.generateClassesForSchemaArrays.isSelected();
                }

                @Override
                public String getTypeVersion() {
                    return dialog.typeMappingVersion.getSelectedItem().toString();
                }

                @Override
                public boolean isGenerateAllElements() {
                    return dialog.generateUnreferencedElements.isSelected();
                }

                @Override
                public boolean isSupportWrappedStyleOperation() {
                    return dialog.wrappedDocumentSupport.isSelected();
                }

                @Override
                public Project getProject() {
                    return project;
                }

                @Override
                public File getSavedWsdlFile() {
                    return savedWsdl;
                }

                @Override
                public Module getSelectedModule() {
                    return currentModule;
                }

                @Override
                public boolean useExtensions() {
                    return dialog.useExtensions();
                }
            });
            File currentDir = new File(wsdlUrl).getParentFile();
            if (currentDir != null && currentDir.exists()) {
                wsdlHandler.setLaunchDir(currentDir);
            }
            InvokeExternalCodeUtil.invokeExternalProcess2(wsdlHandler, project, () -> {
                if (dialog.addLibs.isSelected()) {
                    EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(project, false, currentModule, currentWsEngine, serverSideGeneration, bindingType);
                }
                LibUtils.setupLibsForGeneratedCode(currentModule, currentWsEngine, "Wsdl2Java");
                CommonWsUtils.doFileSystemRefresh();
                InvokeExternalCodeUtil.navigateToPackage(currentModule, packagePrefix1, outputPath, requestFocusInProjectView);
                Runnable runnable = dialog.getOnSuccess();
                if (runnable != null) {
                    runnable.run();
                }
            }, (Consumer<? super Exception>)onException, (Computable<Boolean>)((Computable)() -> Boolean.TRUE), () -> GenerateJavaFromWsdlAction.runAction(project, dialog, null, null, null));
        }
        catch (Exception e2) {
            onException.consume((Object)e2);
        }
    }

    static boolean isAcceptableFileForGenerateJavaFromWsdl(VirtualFile virtualFile) {
        String extension = virtualFile.getExtension();
        return WSDL_EXTENSION.equals(extension);
    }

    @Override
    public boolean isAcceptableFile(VirtualFile file) {
        return file.isDirectory() || GenerateJavaFromWsdlAction.isAcceptableFileForGenerateJavaFromWsdl(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ws/xml/actions/GenerateJavaFromWsdlAction", "actionPerformed"));
    }
}

