/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.actions;

import com.intellij.facet.FacetTypeId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.actions.CreateWSActionBase;
import com.intellij.ws.xml.actions.GenerateJavaFromWsdlAction;
import com.intellij.ws.xml.actions.GenerateJavaFromWsdlDialog;
import com.intellij.ws.xml.engines.axis.AxisWSEngine;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.facet.WebServicesClientFacet;
import com.intellij.ws.xml.utils.WsModuleUtil;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CreateWebServiceClientAction
extends CreateWSActionBase<WebServicesClientFacet> {
    public CreateWebServiceClientAction() {
        super("create.webservice.client.action.text", "create.webservice.client.action.description", AllIcons.Javaee.WebServiceClient);
    }

    @Override
    protected String getKindName() {
        return WSBundle.message("webserviceclient.create.action.name", new Object[0]);
    }

    @Override
    protected String buildText(String packageQName, String className, PsiFile file) {
        return CommonWsUtils.getDefaultClientCode(file.getProject(), packageQName, className, "default.webservice.client.java");
    }

    @Override
    protected FacetTypeId<WebServicesClientFacet> getFacetID() {
        return WebServicesClientFacet.ID;
    }

    @Override
    protected PsiElement @NotNull [] invokeDialog(Project project, PsiDirectory psiDirectory) {
        final CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, psiDirectory);
        final JTextField nameField = new JTextField();
        Runnable onSuccess = () -> {
            Editor editor;
            VirtualFile clientFile;
            String className = nameField.getText();
            Pair<String, PsiDirectory> pair = this.getTargetFileDirectoryPair(className, psiDirectory);
            PsiFile file = ((PsiDirectory)pair.second).findFile((String)pair.first + ".java");
            if (file != null && (clientFile = file.getVirtualFile()) != null && (editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, clientFile), true)) != null) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiDirectory.getVirtualFile(), (Project)psiDirectory.getProject());
                assert (module != null);
                WSEngine engineFromModule = WsModuleUtil.getEngineFromModule(module);
                if (engineFromModule != null) {
                    CommonWsUtils.runTemplate(editor, engineFromModule.getServiceInvocationTemplateName());
                }
            }
        };
        GenerateJavaFromWsdlDialog dialog = new GenerateJavaFromWsdlDialog(project, null, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory), onSuccess){
            {
                super(_project, previousDialog, module, _onSuccess);
                this.setTitle(WSBundle.message("create.webservice.client.action.text", new Object[0]));
                this.outputPathes.setVisible(false);
                this.outputPathesText.setVisible(false);
                this.packagePrefix.setVisible(false);
                this.packagePrefixText.setVisible(false);
            }

            protected JComponent createNorthPanel() {
                LabeledComponent component = LabeledComponent.create((JComponent)nameField, (String)WSBundle.message("create.webservice.client.name", new Object[0]));
                component.setLabelLocation("West");
                return component;
            }

            public JComponent getPreferredFocusedComponent() {
                return nameField;
            }

            @Override
            protected void doOKAction() {
                String text = nameField.getText().trim();
                if (!validator.canClose(text)) {
                    return;
                }
                super.doOKAction();
            }
        };
        if (dialog.showAndGet()) {
            GenerateJavaFromWsdlAction.doOkAction(project, dialog, false);
        }
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            CreateWebServiceClientAction.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    public static void runTemplate(@NotNull Editor editor, @NotNull WSEngine wsEngine) {
        if (editor == null) {
            CreateWebServiceClientAction.$$$reportNull$$$0(1);
        }
        if (wsEngine == null) {
            CreateWebServiceClientAction.$$$reportNull$$$0(2);
        }
        String templateName = wsEngine instanceof AxisWSEngine ? "itws" : "ijws";
        CommonWsUtils.runTemplate(editor, templateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/xml/actions/CreateWebServiceClientAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsEngine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/xml/actions/CreateWebServiceClientAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

