/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.actions;

import com.intellij.facet.FacetTypeId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.ws.xml.WSBundle;
import com.intellij.ws.xml.actions.CreateWSActionBase;
import com.intellij.ws.xml.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.xml.engines.wsengine.WSEngine;
import com.intellij.ws.xml.facet.WebServicesFacet;
import com.intellij.ws.xml.utils.WsModuleUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CreateWebServiceAction
extends CreateWSActionBase<WebServicesFacet> {
    public CreateWebServiceAction() {
        super("create.webservice.action.text", "create.webservice.action.description", AllIcons.Javaee.WebService);
    }

    @Override
    protected String getKindName() {
        return WSBundle.message("webservice.create.action.name", new Object[0]);
    }

    @Override
    protected String buildText(String packageQName, String className, PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        WSEngine engineFromModule = WsModuleUtil.getEngineFromModule(module);
        return EnableWebServicesSupportUtils.getWebServiceTemplateText(packageQName, className, engineFromModule, file.getProject());
    }

    @Override
    protected FacetTypeId<WebServicesFacet> getFacetID() {
        return WebServicesFacet.ID;
    }

    @Override
    protected void createAdditionalFiles(@NotNull String className, String packageQName, PsiDirectory psiDirectory, Editor editor, VirtualFile vfile) throws Exception {
        if (className == null) {
            CreateWebServiceAction.$$$reportNull$$$0(0);
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiDirectory.getVirtualFile(), (Project)psiDirectory.getProject());
        assert (module != null);
        WSEngine engineFromModule = WsModuleUtil.getEngineFromModule(module);
        if (engineFromModule != null) {
            ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
            VirtualFile interfaceFile = EnableWebServicesSupportUtils.createInterfaceFile(module, engineFromModule, packageQName, className);
            if (interfaceFile != null) {
                filesToCompile.add(interfaceFile);
            }
            EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(module.getProject(), false, module, engineFromModule, true, null);
            filesToCompile.add(vfile);
            EnableWebServicesSupportUtils.compileAndRunDeployment(module, StringUtil.getQualifiedName((String)packageQName, (String)className), filesToCompile, engineFromModule, null, (Consumer<? super Exception>)((Consumer)e -> e.printStackTrace()), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/ws/xml/actions/CreateWebServiceAction", "createAdditionalFiles"));
    }
}

