/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.xml.WSAnnotations;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JwsImplicitUsagesProvider
implements ImplicitUsageProvider {
    private static final Collection<String> ourMethodAnnotations = Arrays.asList(WSAnnotations.WEB_METHOD.javax(), WSAnnotations.WEB_METHOD.jakarta());
    private static final Collection<String> ourClassAnnotations = Arrays.asList(WSAnnotations.WEB_SERVICE.javax(), WSAnnotations.WEB_SERVICE.jakarta());

    JwsImplicitUsagesProvider() {
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JwsImplicitUsagesProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        if (element instanceof PsiClass && JwsImplicitUsagesProvider.isWebServiceClass((PsiClass)element)) {
            return true;
        }
        return element instanceof PsiMethod && !((PsiMethod)element).hasModifier(JvmModifier.PRIVATE) && !((PsiMethod)element).hasModifier(JvmModifier.STATIC) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), ourMethodAnnotations, (int)1) && JwsImplicitUsagesProvider.isWebServiceClass(((PsiMethod)element).getContainingClass());
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            JwsImplicitUsagesProvider.$$$reportNull$$$0(1);
        }
        return this.isImplicitRead(element);
    }

    private static boolean isWebServiceClass(@Nullable PsiClass psiClass) {
        return psiClass != null && !psiClass.isAnnotationType() && !psiClass.isEnum() && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, ourClassAnnotations, (int)1);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            JwsImplicitUsagesProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/ws/xml/JwsImplicitUsagesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

