/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.common;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.facet.FacetManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.DocumentUtil;
import com.intellij.ws.common.engines.LibraryDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonWsUtils {
    public static final Logger LOG = Logger.getInstance((String)"webservicesplugin.enablewssupport");
    public static final String FILE_URL_PREFIX = "file:";
    public static final boolean hasJ2EE;
    private static final String ourMarker = "// Please, do not remove this line from file template, here invocation of web service will be inserted";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static VirtualFile addFileToModuleFromTemplate(final String @NotNull [] pathComponents, final @NotNull InputStream templateInputStream, final boolean createInContentRoot, final boolean overwriteExisitingFile, VirtualFile[] sourceRoots, final WebFacet webFacet) {
        if (templateInputStream == null) {
            CommonWsUtils.$$$reportNull$$$0(0);
        }
        if (pathComponents == null) {
            CommonWsUtils.$$$reportNull$$$0(1);
        }
        if (sourceRoots.length == 0) {
            VirtualFile virtualFile = null;
            return virtualFile;
        }
        final VirtualFile[] sourceRoots1 = sourceRoots;
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile[] fileComponents = new VirtualFile[pathComponents.length];
                int i = 0;
                if (createInContentRoot && hasJ2EE && webFacet != null) {
                    for (i = fileComponents.length - 1; i >= 0; --i) {
                        String string = CommonWsUtils.buildPath(pathComponents, i + 1);
                        for (WebRoot webRoot : webFacet.getWebRoots()) {
                            VirtualFile virtualFile;
                            VirtualFile webRootFile = webRoot.getFile();
                            if (webRootFile == null || (virtualFile = webRootFile.findFileByRelativePath(string)) == null) continue;
                            fileComponents[i] = virtualFile;
                            break;
                        }
                        if (fileComponents[i] == null) continue;
                        ++i;
                        break;
                    }
                } else {
                    for (VirtualFile file : sourceRoots1) {
                        for (i = 0; i < fileComponents.length; ++i) {
                            fileComponents[i] = (i == 0 ? file : fileComponents[i - 1]).findFileByRelativePath(pathComponents[i]);
                            if (fileComponents[i] == null) break;
                        }
                        if (i <= 0) {
                            continue;
                        }
                        break;
                    }
                }
                try {
                    boolean bl;
                    boolean bl2;
                    boolean bl3 = bl2 = i == fileComponents.length;
                    if (bl2 && overwriteExisitingFile) {
                        bl = false;
                    }
                    for (int j = Math.max(i, 0); j < fileComponents.length; ++j) {
                        VirtualFile parentVirtualFile = j == 0 ? sourceRoots1[0] : fileComponents[j - 1];
                        LOG.assertTrue(parentVirtualFile != null, (Object)("src: " + sourceRoots1[0] + "; file component: " + (Serializable)((Object)(j == 0 ? "<no>" : fileComponents[j - 1]))));
                        fileComponents[j] = j + 1 != fileComponents.length ? parentVirtualFile.createChildDirectory((Object)LocalFileSystem.getInstance(), pathComponents[j]) : parentVirtualFile.createChildData((Object)LocalFileSystem.getInstance(), pathComponents[j]);
                    }
                    if (fileComponents[fileComponents.length - 1] != null && !bl) {
                        OutputStream outputStream = fileComponents[fileComponents.length - 1].getOutputStream((Object)this);
                        FileUtil.copy((InputStream)templateInputStream, (OutputStream)outputStream);
                        outputStream.flush();
                        outputStream.close();
                        return fileComponents[fileComponents.length - 1];
                    }
                }
                catch (IOException iOException) {
                    LOG.error((Throwable)iOException);
                }
                return null;
            }
        });
        return virtualFile;
        finally {
            try {
                templateInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    public static VirtualFile addFileToModuleFromTemplate(@NotNull Module module, String @NotNull [] pathComponents, @NotNull InputStream templateInputStream, boolean createInContentRoot, boolean overwriteExisitingFile, WebFacet webFacet) {
        VirtualFile[] sourceRoots;
        if (module == null) {
            CommonWsUtils.$$$reportNull$$$0(2);
        }
        if (templateInputStream == null) {
            CommonWsUtils.$$$reportNull$$$0(3);
        }
        if (pathComponents == null) {
            CommonWsUtils.$$$reportNull$$$0(4);
        }
        ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module);
        if (createInContentRoot) {
            if (hasJ2EE && webFacet != null) {
                ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
                for (WebRoot webRoot : webFacet.getWebRoots()) {
                    roots.add(webRoot.getFile());
                }
                sourceRoots = VfsUtilCore.toVirtualFileArray(roots);
                if (sourceRoots.length == 0) {
                    sourceRoots = moduleManager.getContentRoots();
                }
            } else {
                sourceRoots = moduleManager.getContentRoots();
            }
        } else {
            sourceRoots = moduleManager.getSourceRoots();
        }
        return CommonWsUtils.addFileToModuleFromTemplate(pathComponents, templateInputStream, createInContentRoot, overwriteExisitingFile, sourceRoots, webFacet);
    }

    @Nullable
    public static VirtualFile addFileToModuleFromTemplate(@NotNull Module module, String @NotNull [] pathComponents, @NotNull InputStream templateInputStream, boolean createInContentRoot, boolean overwriteExisitingFile) {
        if (module == null) {
            CommonWsUtils.$$$reportNull$$$0(5);
        }
        if (templateInputStream == null) {
            CommonWsUtils.$$$reportNull$$$0(6);
        }
        if (pathComponents == null) {
            CommonWsUtils.$$$reportNull$$$0(7);
        }
        return CommonWsUtils.addFileToModuleFromTemplate(module, pathComponents, templateInputStream, createInContentRoot, overwriteExisitingFile, (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID));
    }

    private static String buildPath(String[] pathComponents, int last) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < last; ++i) {
            String pathComponent = pathComponents[i];
            if (pathBuilder.length() > 0) {
                pathBuilder.append('/');
            }
            pathBuilder.append(pathComponent);
        }
        return pathBuilder.toString();
    }

    @Nullable
    public static VirtualFile findFileByPath(Module module, String[] pathComponents, boolean findInContentRoot) {
        VirtualFile[] sourceRoots;
        WebFacet webFacet;
        ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module);
        if (hasJ2EE && findInContentRoot && (webFacet = (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID)) != null) {
            String relativePath = CommonWsUtils.buildPath(pathComponents, pathComponents.length);
            for (WebRoot webRoot : webFacet.getWebRoots()) {
                VirtualFile virtualFile;
                VirtualFile webRootFile = webRoot.getFile();
                if (webRootFile == null || (virtualFile = webRootFile.findFileByRelativePath(relativePath)) == null) continue;
                return virtualFile;
            }
            WebDirectoryElement element = CommonWsUtils.findWebDirectoryByElement(relativePath, webFacet);
            if (element != null) {
                return element.getOriginalVirtualFile();
            }
            return null;
        }
        VirtualFile[] virtualFileArray = sourceRoots = findInContentRoot ? moduleManager.getContentRoots() : moduleManager.getSourceRoots();
        if (sourceRoots.length == 0) {
            return null;
        }
        VirtualFile[] virtualFileArray2 = sourceRoots;
        int n = virtualFileArray2.length;
        for (int i = 0; i < n; ++i) {
            String pathComponent;
            VirtualFile file;
            VirtualFile current = file = virtualFileArray2[i];
            String[] stringArray = pathComponents;
            int n2 = stringArray.length;
            for (int j = 0; j < n2 && (current = current.findChild(pathComponent = stringArray[j])) != null; ++j) {
            }
            if (current == null) continue;
            return current;
        }
        return null;
    }

    public static boolean isWebModule(Module module) {
        return hasJ2EE && FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID) != null;
    }

    @Nullable
    public static WebDirectoryElement findWebDirectoryByElement(String path, WebFacet webFacet) {
        if (!hasJ2EE) {
            return null;
        }
        if (webFacet == null) {
            return null;
        }
        return WebUtil.getWebUtil().findWebDirectoryElement(path, webFacet);
    }

    public static void setupLibsForDeployment(Module currentModule, LibraryDescriptor[] libInfos) {
        CommonWsUtils.setupLibsForDeployment(currentModule, libInfos, (WebFacet)FacetManager.getInstance((Module)currentModule).getFacetByType(WebFacet.ID));
    }

    public static void setupLibsForDeployment(Module currentModule, LibraryDescriptor[] libInfos, WebFacet facet) {
        if (!hasJ2EE) {
            return;
        }
        if (facet == null) {
            return;
        }
        LibraryTable projectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(currentModule.getProject());
        for (LibraryDescriptor libInfo : libInfos) {
            Library library;
            String libraryName;
            if (!libInfo.isToIncludeInJavaEEContainerDeployment() || (libraryName = libInfo.getName()) == null || (library = projectLibraryTable.getLibraryByName(libraryName)) == null) continue;
            ApplicationManager.getApplication().runWriteAction(() -> JavaeeArtifactUtil.getInstance().addLibraryToAllArtifactsContainingFacet(library, (JavaeeFacet)facet));
        }
    }

    public static boolean hasJ2EE() {
        return hasJ2EE;
    }

    public static String getFromFileTemplateWithCustomParameters(Project project, String templateName, String ... additionalParameters) {
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        if (additionalParameters != null) {
            for (int i = 0; i < additionalParameters.length; ++i) {
                String paramName = additionalParameters[i];
                if (i + 1 >= additionalParameters.length) continue;
                properties.setProperty(paramName, additionalParameters[++i]);
            }
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(templateName);
        try {
            return fileTemplate.getText(properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDefaultClientCode(Project project, String packageQName, String className, String templateName) {
        return CommonWsUtils.getFromFileTemplateWithCustomParameters(project, templateName, "PACKAGE_NAME", packageQName, "CLASS_NAME", className);
    }

    public static void runTemplate(@NotNull Editor editor, String templateName) {
        if (editor == null) {
            CommonWsUtils.$$$reportNull$$$0(8);
        }
        CommonWsUtils.doFileSystemRefresh();
        int i = editor.getDocument().getText().indexOf(ourMarker);
        assert (i != -1) : "Web Services Client template does not have insertion point // Please, do not remove this line from file template, here invocation of web service will be inserted";
        editor.getCaretModel().moveToOffset(i);
        DocumentUtil.writeInRunUndoTransparentAction(() -> editor.getDocument().replaceString(i, i + ourMarker.length(), (CharSequence)""));
        Project project = editor.getProject();
        assert (project != null);
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            TemplateImpl template = TemplateSettings.getInstance().getTemplate(templateName, "Web Services");
            if (template != null) {
                TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template);
            }
        });
    }

    public static void doFileSystemRefresh() {
        ApplicationManager.getApplication().runWriteAction(() -> VirtualFileManager.getInstance().syncRefresh());
    }

    public static void scanFile(File file, FileProcessor processor) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
        CommonWsUtils.doScanFile(reader, processor);
    }

    public static void doScanFile(LineNumberReader reader, FileProcessor processor) throws IOException {
        String s = reader.readLine();
        while (s != null && processor.process(s)) {
            s = reader.readLine();
        }
        reader.close();
        processor.fileScanningEnded();
    }

    public static String getVMExecutablePathForSdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            CommonWsUtils.$$$reportNull$$$0(9);
        }
        return ((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk);
    }

    public static String getToolsJarPathForSdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            CommonWsUtils.$$$reportNull$$$0(10);
        }
        return ((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk);
    }

    public static boolean isAcceptableSdk(@Nullable Sdk jdk) {
        return jdk != null && jdk.getSdkType() instanceof JavaSdkType;
    }

    public static CloseAction createRunnerAction(RunContentDescriptor myDescriptor, Project project) {
        return new CloseAction(DefaultRunExecutor.getRunExecutorInstance(), myDescriptor, project);
    }

    public static void showRunContent(@NotNull RunContentManager contentManager, RunContentDescriptor myDescriptor) {
        if (contentManager == null) {
            CommonWsUtils.$$$reportNull$$$0(11);
        }
        contentManager.showRunContent(DefaultRunExecutor.getRunExecutorInstance(), myDescriptor);
    }

    public static Sdk getInternalJdk() {
        return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
    }

    static {
        boolean found = false;
        try {
            Class.forName("com.intellij.javaee.web.facet.WebFacet");
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.intellij.javaee"));
            if (descriptor != null && descriptor.isEnabled()) {
                found = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            hasJ2EE = found;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateInputStream";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathComponents";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/common/CommonWsUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileToModuleFromTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getVMExecutablePathForSdk";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolsJarPathForSdk";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "showRunContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileProcessor {
        public void fileScanningEnded() throws IOException;

        public boolean process(String var1) throws IOException;
    }
}

