/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.postProcessing.processings;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.RedundantUnitReturnTypeInspection;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.nj2k.postProcessing.InspectionLikeProcessingForElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/nj2k/postProcessing/processings/RemoveExplicitUnitTypeProcessing;", "Lorg/jetbrains/kotlin/nj2k/postProcessing/InspectionLikeProcessingForElement;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "()V", "apply", "", "element", "isApplicableTo", "", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "kotlin.j2k.services"})
public final class RemoveExplicitUnitTypeProcessing
extends InspectionLikeProcessingForElement<KtNamedFunction> {
    @Override
    protected boolean isApplicableTo(@NotNull KtNamedFunction element, @Nullable ConverterSettings settings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtTypeReference ktTypeReference = element.getTypeReference();
        if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTypeElement()) == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        if (!typeReference.textMatches((CharSequence)"Unit")) {
            return false;
        }
        return RedundantUnitReturnTypeInspection.Companion.hasRedundantUnitReturnType(element);
    }

    @Override
    protected void apply(@NotNull KtNamedFunction element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setTypeReference((KtTypeReference)null);
    }

    public RemoveExplicitUnitTypeProcessing() {
        super(KtNamedFunction.class);
    }
}

