/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.templates.postfix;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReactiveStreamsTemplatesUtil {
    @NotNull
    public static String buildType(@NotNull String type, String ... typeParameters) {
        Object joinedTypeParameters;
        if (type == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(0);
        }
        if (typeParameters == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(1);
        }
        joinedTypeParameters = !((String)(joinedTypeParameters = String.join((CharSequence)",", typeParameters))).isEmpty() ? "<" + (String)joinedTypeParameters + ">" : "";
        String string = type + (String)joinedTypeParameters;
        if (string == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String buildSupplier(@Nullable String parameter) {
        return parameter != null ? ReactiveStreamsTemplatesUtil.buildType("java.util.function.Supplier", parameter) : ReactiveStreamsTemplatesUtil.buildType("java.util.function.Supplier", new String[0]);
    }

    @NotNull
    public static String buildFunction(@NotNull String argumentType, @NotNull String returnType) {
        if (argumentType == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(3);
        }
        if (returnType == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(4);
        }
        return ReactiveStreamsTemplatesUtil.buildType("java.util.function.Function", argumentType, returnType);
    }

    public static boolean isAcceptable(PsiElement element, PsiType elementType, String expectedType) {
        PsiType expectedCalculatedType = JavaPsiFacade.getElementFactory((Project)element.getProject()).createTypeFromText(expectedType, element);
        return ReactiveStreamsTemplatesUtil.isAssignable(elementType, expectedCalculatedType) || element instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)element).isAcceptable(expectedCalculatedType);
    }

    private static boolean isAssignable(@Nullable PsiType actualType, @NotNull PsiType expectedType) {
        if (expectedType == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(5);
        }
        if (actualType == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)actualType, (boolean)false);
    }

    public static void countPostfixCompletionUsage(@NotNull PsiElement element, @NotNull String frameworkName) {
        if (element == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(6);
        }
        if (frameworkName == null) {
            ReactiveStreamsTemplatesUtil.$$$reportNull$$$0(7);
        }
        FUCounterUsageLogger.getInstance().logEvent("reactivestreams.usage", "postfix.completion.used", new FeatureUsageData().addProject(element.getProject()).addData("reactivestreams_implementation", frameworkName));
    }

    private ReactiveStreamsTemplatesUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/templates/postfix/ReactiveStreamsTemplatesUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/templates/postfix/ReactiveStreamsTemplatesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildType";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countPostfixCompletionUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

