/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.rxjava;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.reactivestreams.implementations.ReactiveStreamsImplementation;
import com.intellij.reactivestreams.implementations.info.ThrowReplacementInfo;
import com.intellij.reactivestreams.rxjava.RxJavaNonBlockingAnalysisManager;
import com.intellij.reactivestreams.rxjava.RxJavaThrowReplacementInfo;
import com.intellij.reactivestreams.rxjava.util.RxJavaVersion;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0018H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0012\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0018H\u0016J\u0010\u00102\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00063"}, d2={"Lcom/intellij/reactivestreams/rxjava/RxJavaReactiveStreamsImplementation;", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation;", "()V", "publisherImplementationsTypes", "", "", "getPublisherImplementationsTypes", "()Ljava/lang/Iterable;", "publisherInterfacesTypes", "getPublisherInterfacesTypes", "rxJavaVersion", "Lcom/intellij/reactivestreams/rxjava/util/RxJavaVersion;", "getRxJavaVersion", "()Lcom/intellij/reactivestreams/rxjava/util/RxJavaVersion;", "canMethodLambdaReturnNull", "", "method", "Lcom/intellij/psi/PsiMethod;", "functionalParameter", "Lcom/intellij/psi/PsiParameter;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiParameter;)Ljava/lang/Boolean;", "createThrowReplacementInfo", "Lcom/intellij/reactivestreams/implementations/info/ThrowReplacementInfo;", "methodCall", "Lorg/jetbrains/uast/UCallExpression;", "functionalObject", "Lorg/jetbrains/uast/UElement;", "findEmitterIndex", "", "signature", "Lcom/intellij/psi/util/MethodSignature;", "(Lcom/intellij/psi/util/MethodSignature;)Ljava/lang/Integer;", "getBlockingNonBlockingAnalysisManager", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation$NonBlockingAnalysisManager;", "getMethodType", "Lcom/intellij/reactivestreams/implementations/info/ThrowReplacementInfo$MethodType;", "callExpression", "getReferenceNameByType", "type", "Lcom/intellij/psi/PsiType;", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "isMethodAcceptNullableReturnLambdas", "isOperatorMethodName", "methodName", "provideQuickFixForLambdaReturningNull", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "shouldBeCollapsed", "shouldCheckUsageOfReturnValue", "intellij.reactivestreams.rxjava"})
public abstract class RxJavaReactiveStreamsImplementation
implements ReactiveStreamsImplementation {
    @NotNull
    public abstract RxJavaVersion getRxJavaVersion();

    @Override
    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getRxJavaVersion().hasRxJavaLibraryInProject(project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldCheckUsageOfReturnValue(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!this.getRxJavaVersion().isRxPublisherImplementation(method.getContainingClass())) {
            PsiClass psiClass = method.getContainingClass();
            if (!this.getRxJavaVersion().isInRxExtension(psiClass != null ? psiClass.getQualifiedName() : null)) return false;
        }
        if (!ReactiveStreamsUtils.isPublisher(method.getReturnType())) return false;
        return true;
    }

    @Override
    public boolean isOperatorMethodName(@Nullable String methodName) {
        return true;
    }

    @Override
    @NotNull
    public ReactiveStreamsImplementation.NonBlockingAnalysisManager getBlockingNonBlockingAnalysisManager() {
        return new RxJavaNonBlockingAnalysisManager(this.getRxJavaVersion());
    }

    @Override
    @Nullable
    public ThrowReplacementInfo createThrowReplacementInfo(@NotNull UCallExpression methodCall, @NotNull UElement functionalObject2) {
        Object object;
        PsiClassType psiClassType;
        UExpression it;
        Object object2;
        block18: {
            block17: {
                block16: {
                    block15: {
                        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
                        Intrinsics.checkNotNullParameter((Object)functionalObject2, (String)"functionalObject");
                        if (!this.getRxJavaVersion().isRxPublisherImplementation(methodCall.getReturnType())) break block15;
                        PsiMethod psiMethod = methodCall.resolve();
                        if (this.getRxJavaVersion().isRxPublisherImplementation((PsiClass)(psiMethod != null ? psiMethod.getContainingClass() : null))) break block16;
                    }
                    return null;
                }
                UElement uElement = functionalObject2;
                if (!(uElement instanceof UExpression)) {
                    uElement = null;
                }
                if ((object2 = (UExpression)uElement) == null) break block17;
                UExpression uExpression = object2;
                boolean bl = false;
                boolean bl2 = false;
                it = uExpression;
                boolean bl3 = false;
                object2 = UastUtils.getParameterForArgument((UCallExpression)methodCall, (UExpression)it);
                if (object2 == null || (object2 = object2.getType()) == null) break block17;
                uExpression = object2;
                bl = false;
                bl2 = false;
                it = uExpression;
                boolean bl4 = false;
                object2 = LambdaUtil.isFunctionalType((PsiType)it) ? uExpression : null;
                if (object2 != null) break block18;
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"(functionalObject as? UE\u2026Type(it) } ?: return null");
        UExpression functionalType = object2;
        ThrowReplacementInfo.MethodType methodType = this.getMethodType(methodCall);
        if (methodType == null) {
            return null;
        }
        ThrowReplacementInfo.MethodType methodType2 = methodType;
        PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalType);
        if (ReactiveStreamsUtils.isPublisher(returnType)) {
            PsiType psiType = GenericsUtil.eliminateWildcards((PsiType)returnType);
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"GenericsUtil.eliminateWildcards(returnType)");
            String string = this.getReferenceNameByType(psiType);
            if (string == null) {
                return null;
            }
            String referenceName = string;
            return new RxJavaThrowReplacementInfo(new ThrowReplacementInfo.ReplaceType.ReplaceWithReturnType("error", referenceName), methodType2, methodCall, this.getRxJavaVersion().getFrameworkName());
        }
        it = functionalType;
        boolean bl = false;
        boolean bl5 = false;
        UExpression it2 = it;
        boolean bl6 = false;
        UExpression uExpression = it2;
        if (!(uExpression instanceof PsiClassType)) {
            uExpression = null;
        }
        if ((psiClassType = (PsiClassType)uExpression) != null && (psiClassType = psiClassType.resolveGenerics()) != null && (psiClassType = psiClassType.getSubstitutor()) != null) {
            PsiClassType psiClassType2 = psiClassType;
            boolean bl7 = false;
            boolean bl8 = false;
            PsiClassType substitutor = psiClassType2;
            boolean bl9 = false;
            PsiMethod psiMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)it2);
            object = psiMethod != null ? psiMethod.getSignature((PsiSubstitutor)substitutor) : null;
        } else {
            object = null;
        }
        if (object == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"functionalType\n         \u2026         } ?: return null");
        MethodSignature functionalInterfaceTypeSignature = object;
        Integer n = this.findEmitterIndex(functionalInterfaceTypeSignature);
        if (n == null) {
            return null;
        }
        int emitterIndex = n;
        return new RxJavaThrowReplacementInfo(new ThrowReplacementInfo.ReplaceType.ReplaceWithMethodCallType("onError", emitterIndex), methodType2, methodCall, this.getRxJavaVersion().getFrameworkName());
    }

    private final ThrowReplacementInfo.MethodType getMethodType(UCallExpression callExpression) {
        PsiMethod psiMethod = callExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod resolved = psiMethod;
        if (resolved.hasModifier(JvmModifier.STATIC)) {
            return ThrowReplacementInfo.MethodType.FACTORY;
        }
        return ThrowReplacementInfo.MethodType.OPERATOR;
    }

    private final Integer findEmitterIndex(MethodSignature signature) {
        Integer n;
        Object v1;
        boolean bl;
        Iterable iterable;
        block3: {
            Object[] objectArray = signature.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"signature.parameterTypes");
            iterable = ArraysKt.withIndex((Object[])objectArray);
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                IndexedValue $dstr$_u24__u24$type = (IndexedValue)t;
                boolean bl3 = false;
                PsiType type = (PsiType)$dstr$_u24__u24$type.component2();
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)this.getRxJavaVersion().getClasses().getEMITTER())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        IndexedValue indexedValue = v1;
        if (indexedValue != null) {
            iterable = indexedValue;
            bl = false;
            boolean bl4 = false;
            Iterable $dstr$index$_u24__u24 = iterable;
            boolean bl5 = false;
            int index = $dstr$index$_u24__u24.component1();
            n = index;
        } else {
            n = null;
        }
        return n;
    }

    private final String getReferenceNameByType(PsiType type) {
        String string;
        PsiClassType psiClassType;
        PsiType psiType = type;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        String string2 = (psiClassType = (PsiClassType)psiType) != null && (psiClassType = psiClassType.rawType()) != null ? psiClassType.getCanonicalText() : (string = null);
        return Intrinsics.areEqual((Object)string, (Object)this.getRxJavaVersion().getClasses().getOBSERVABLE_SOURCE()) ? this.getRxJavaVersion().getClasses().getOBSERVABLE() : (Intrinsics.areEqual((Object)string, (Object)this.getRxJavaVersion().getClasses().getSINGLE_SOURCE()) ? this.getRxJavaVersion().getClasses().getSINGLE() : (Intrinsics.areEqual((Object)string, (Object)this.getRxJavaVersion().getClasses().getMAYBE_SOURCE()) ? this.getRxJavaVersion().getClasses().getMAYBE() : (Intrinsics.areEqual((Object)string, (Object)this.getRxJavaVersion().getClasses().getCOMPLETABLE_SOURCE()) ? this.getRxJavaVersion().getClasses().getCOMPLETABLE() : (Intrinsics.areEqual((Object)string, (Object)"org.reactivestreams.Publisher") ? this.getRxJavaVersion().getClasses().getFLOWABLE() : null))));
    }

    @Override
    public boolean shouldBeCollapsed(@NotNull UCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return this.getRxJavaVersion().isRxPublisherImplementation(callExpression.getReceiverType());
    }

    @Override
    @NotNull
    public Iterable<String> getPublisherImplementationsTypes() {
        return this.getRxJavaVersion().getClasses().getPUBLISHERS_IMPLEMENTATIONS();
    }

    @Override
    @NotNull
    public Iterable<String> getPublisherInterfacesTypes() {
        return this.getRxJavaVersion().getClasses().getPUBLISHERS_INTERFACES();
    }

    @Override
    @Nullable
    public Boolean canMethodLambdaReturnNull(@NotNull PsiMethod method, @Nullable PsiParameter functionalParameter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!this.getRxJavaVersion().isRxType(method.getContainingClass()) || !this.getRxJavaVersion().isRxType(method.getReturnType())) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        String string = psiClass != null ? psiClass.getQualifiedName() : null;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual((Object)it, (Object)this.getRxJavaVersion().getClasses().getMAYBE()) || Intrinsics.areEqual((Object)it, (Object)this.getRxJavaVersion().getClasses().getCOMPLETABLE());
        boolean methodInMaybeOrCompletable = bl4;
        if (methodInMaybeOrCompletable && this.isMethodAcceptNullableReturnLambdas(method)) {
            return true;
        }
        return ReactiveStreamsUtils.isLambdaReturnTypeAcceptsNulls(functionalParameter);
    }

    protected abstract boolean isMethodAcceptNullableReturnLambdas(@NotNull PsiMethod var1);

    @Override
    @NotNull
    public List<LocalQuickFix> provideQuickFixForLambdaReturningNull(@NotNull PsiMethod method, @Nullable PsiParameter functionalParameter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return CollectionsKt.emptyList();
    }
}

