/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.util;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reactivestreams.reactor.util.ReactorConstants;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0005\u00a8\u0006\u0012"}, d2={"isReactorPublisher", "", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)Z", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiType;)Z", "hasClassInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "fqName", "", "hasReactorLibrary", "project", "Lcom/intellij/openapi/project/Project;", "hasReactorLibraryAtLeast330", "hasReactorTestLibraryInScope", "element", "Lcom/intellij/psi/PsiElement;", "intellij.reactivestreams.reactor"})
@JvmName(name="ReactorLibraryUtil")
public final class ReactorLibraryUtil {
    public static final boolean isReactorPublisher(@Nullable PsiType $this$isReactorPublisher) {
        PsiType psiType = GenericsUtil.eliminateWildcards((PsiType)$this$isReactorPublisher);
        boolean bl = false;
        boolean bl2 = false;
        PsiType type = psiType;
        boolean bl3 = false;
        PsiType psiType2 = type;
        if (!(psiType2 instanceof PsiClassType)) {
            psiType2 = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType2;
        return ReactorLibraryUtil.isReactorPublisher((PsiClass)(psiClassType != null ? psiClassType.resolve() : null));
    }

    public static final boolean isReactorPublisher(@Nullable PsiClass $this$isReactorPublisher) {
        PsiClass psiClass = $this$isReactorPublisher;
        return ReactorConstants.ALL_REACTIVE_ROOT_TYPES.contains(psiClass != null ? psiClass.getQualifiedName() : null);
    }

    public static final boolean hasReactorLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<Boolean> compute() {
                DumbService dumbService;
                DumbService dumbService2 = dumbService = DumbService.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)dumbService2, (String)"dumbService");
                if (dumbService2.isDumb()) {
                    return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{dumbService.getModificationTracker()});
                }
                boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)this.$project).findClass("reactor.core.publisher.Flux", ProjectScope.getAllScope((Project)this.$project)) != null;
                return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)this.$project));
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026getInstance(project))\n  }");
        return (Boolean)object;
    }

    public static final boolean hasReactorLibrary(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ReactorLibraryUtil.hasClassInScope(scope, "reactor.core.publisher.Flux");
    }

    public static final boolean hasReactorLibraryAtLeast330(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ReactorLibraryUtil.hasClassInScope(scope, "reactor.core.CorePublisher");
    }

    public static final boolean hasClassInScope(@NotNull GlobalSearchScope scope, @NotNull String fqName) {
        Project project;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                project = scope.getProject();
                if (project == null) break block2;
                DumbService dumbService = DumbService.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(project)");
                if (!dumbService.isDumb()) break block3;
            }
            return false;
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName, scope) != null;
    }

    public static final boolean hasReactorTestLibraryInScope(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DumbService dumbService = DumbService.getInstance((Project)element.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(element.project)");
        return dumbService.isDumb() ? false : JavaPsiFacade.getInstance((Project)element.getProject()).findClass("reactor.test.StepVerifier", element.getResolveScope()) != null;
    }
}

