/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.intention;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reactivestreams.intention.ReactiveStreamsOperatorsIntention;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.util.ReactorLibraryUtil;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J#\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/reactivestreams/reactor/intention/ReactorFinishStepVerifierQuickFix;", "Lcom/intellij/reactivestreams/intention/ReactiveStreamsOperatorsIntention;", "Lcom/intellij/codeInspection/LocalQuickFix;", "methodName", "", "baseReturnClass", "(Ljava/lang/String;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailableInternal", "", "isImplementationAvailable", "Companion", "intellij.reactivestreams.reactor"})
public final class ReactorFinishStepVerifierQuickFix
extends ReactiveStreamsOperatorsIntention
implements LocalQuickFix {
    private final String methodName;
    private final String baseReturnClass;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    @NotNull
    public String getFamilyName() {
        String string = ReactorCoreBundle.message("intention.finish.step.verifier.quickfix.name", this.methodName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ReactorCoreBundle.messag\u2026ickfix.name\", methodName)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public boolean isImplementationAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ReactorLibraryUtil.hasReactorLibrary(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean isAvailableInternal(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PsiClass psiClass;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$toUElementOfType$iv = element;
        boolean $i$f$toUElementOfType = false;
        UIdentifier uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UIdentifier.class);
        UIdentifier uIdentifier2 = uIdentifier;
        if (uIdentifier == null) return false;
        UCallExpression uCallExpression = UastUtils.getUCallExpression((UElement)((UElement)uIdentifier2), (int)3);
        uIdentifier2 = uCallExpression;
        if (uCallExpression == null) return false;
        UIdentifier methodCall = uIdentifier2;
        if (ReactiveStreamsUtils.getNextCallInChain((UCallExpression)methodCall) != null) {
            return false;
        }
        PsiType psiType = methodCall.getReturnType();
        if (psiType != null) {
            PsiType $this$castSafelyTo$iv = psiType;
            boolean $i$f$castSafelyTo = false;
            PsiType psiType2 = $this$castSafelyTo$iv;
            if (!(psiType2 instanceof PsiClassType)) {
                psiType2 = null;
            }
            if ((psiType = (PsiClassType)psiType2) != null) {
                psiClass = psiType.resolve();
                return InheritanceUtil.isInheritor(psiClass, (boolean)false, (String)this.baseReturnClass);
            }
        }
        psiClass = null;
        return InheritanceUtil.isInheritor(psiClass, (boolean)false, (String)this.baseReturnClass);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$toUElementOfType$iv = element;
        boolean $i$f$toUElementOfType = false;
        UIdentifier uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UIdentifier.class);
        if (uIdentifier == null || (uIdentifier = UastUtils.getUCallExpression((UElement)((UElement)uIdentifier), (int)3)) == null) {
            return;
        }
        UIdentifier methodCall = uIdentifier;
        UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPluginKt.getGenerationPlugin((UElement)((UElement)methodCall));
        if (uastCodeGenerationPlugin == null || (uastCodeGenerationPlugin = uastCodeGenerationPlugin.getElementFactory(project)) == null) {
            return;
        }
        UastCodeGenerationPlugin factory = uastCodeGenerationPlugin;
        boolean bl = false;
        UCallExpression uCallExpression = UastElementFactory.DefaultImpls.createCallExpression$default((UastElementFactory)factory, (UExpression)((UExpression)methodCall), (String)this.methodName, (List)CollectionsKt.emptyList(), null, (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
        if (uCallExpression == null) {
            return;
        }
        UCallExpression newCallExpression = uCallExpression;
        UElement $this$replace$iv = (UElement)methodCall;
        boolean $i$f$replace = false;
        UastCodeGenerationPlugin uastCodeGenerationPlugin2 = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
        UElement uElement = uastCodeGenerationPlugin2 != null ? uastCodeGenerationPlugin2.replace($this$replace$iv, (UElement)newCallExpression, UCallExpression.class) : null;
        boolean bl2 = false;
        boolean bl3 = false;
        UElement it$iv = uElement;
        boolean bl4 = false;
        if (it$iv == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("failed replacing the " + $this$replace$iv + " with " + (UElement)newCallExpression);
        }
    }

    private ReactorFinishStepVerifierQuickFix(String methodName, String baseReturnClass) {
        this.methodName = methodName;
        this.baseReturnClass = baseReturnClass;
    }

    public /* synthetic */ ReactorFinishStepVerifierQuickFix(String methodName, String baseReturnClass, DefaultConstructorMarker $constructor_marker) {
        this(methodName, baseReturnClass);
    }

    @JvmStatic
    @NotNull
    public static final ReactorFinishStepVerifierQuickFix newAddVerifyQuickFix() {
        return Companion.newAddVerifyQuickFix();
    }

    @JvmStatic
    @NotNull
    public static final ReactorFinishStepVerifierQuickFix newAddVerifyCompleteQuickFix() {
        return Companion.newAddVerifyCompleteQuickFix();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/reactivestreams/reactor/intention/ReactorFinishStepVerifierQuickFix$Companion;", "", "()V", "newAddVerifyCompleteQuickFix", "Lcom/intellij/reactivestreams/reactor/intention/ReactorFinishStepVerifierQuickFix;", "newAddVerifyQuickFix", "intellij.reactivestreams.reactor"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ReactorFinishStepVerifierQuickFix newAddVerifyQuickFix() {
            return new ReactorFinishStepVerifierQuickFix("verify", "reactor.test.StepVerifier", null);
        }

        @JvmStatic
        @NotNull
        public final ReactorFinishStepVerifierQuickFix newAddVerifyCompleteQuickFix() {
            return new ReactorFinishStepVerifierQuickFix("verifyComplete", "reactor.test.StepVerifier.LastStep", null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

