/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reactivestreams.implementations.ReactiveStreamsImplementation;
import com.intellij.reactivestreams.implementations.info.ThrowReplacementInfo;
import com.intellij.reactivestreams.reactor.ReactorNonBlockingAnalysisManager;
import com.intellij.reactivestreams.reactor.ReactorReactiveStreamsImplementationKt;
import com.intellij.reactivestreams.reactor.inspections.ReactorReplaceMapWithMapNotNullQuickFix;
import com.intellij.reactivestreams.reactor.util.ReactorConstants;
import com.intellij.reactivestreams.reactor.util.ReactorLibraryUtil;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0012\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u001cH\u0016J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010*\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\u00a8\u00060"}, d2={"Lcom/intellij/reactivestreams/reactor/ReactorReactiveStreamsImplementation;", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation;", "()V", "APPROPRIATE_METHODS", "", "", "HANDLE_LAMBDA_PARAMETER_INDEX", "", "USING_LAMBDA_INDEX", "publisherImplementationsTypes", "", "getPublisherImplementationsTypes", "()Ljava/lang/Iterable;", "publisherInterfacesTypes", "getPublisherInterfacesTypes", "isReferencesOnReactorPublisher", "", "Lorg/jetbrains/uast/UExpression;", "(Lorg/jetbrains/uast/UExpression;)Z", "canMethodLambdaReturnNull", "method", "Lcom/intellij/psi/PsiMethod;", "functionalParameter", "Lcom/intellij/psi/PsiParameter;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiParameter;)Ljava/lang/Boolean;", "createThrowReplacementInfo", "Lcom/intellij/reactivestreams/implementations/info/ThrowReplacementInfo;", "methodCall", "Lorg/jetbrains/uast/UCallExpression;", "functionalObject", "Lorg/jetbrains/uast/UElement;", "getBlockingNonBlockingAnalysisManager", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation$NonBlockingAnalysisManager;", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "isFunctionalObjectInRightPosition", "argument", "isOperatorMethodName", "methodName", "lambdaIndexByMethod", "lambdaParameterIndexByMethod", "provideQuickFixForLambdaReturningNull", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "shouldBeCollapsed", "callExpression", "shouldCheckUsageOfReturnValue", "intellij.reactivestreams.reactor"})
public final class ReactorReactiveStreamsImplementation
implements ReactiveStreamsImplementation {
    private final int USING_LAMBDA_INDEX;
    private final int HANDLE_LAMBDA_PARAMETER_INDEX;
    private final Set<String> APPROPRIATE_METHODS = SetsKt.setOf((Object[])new String[]{"handle", "flatMap", "generate", "using", "create"});

    @Override
    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ReactorLibraryUtil.hasReactorLibrary(project);
    }

    @Override
    public boolean isOperatorMethodName(@Nullable String methodName) {
        return ReactorConstants.TRANSFORM_METHODS.contains(methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldCheckUsageOfReturnValue(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!ReactorLibraryUtil.isReactorPublisher(method.getReturnType())) return false;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) return false;
        PsiClass psiClass2 = psiClass;
        boolean bl = false;
        boolean bl2 = false;
        PsiClass it = psiClass2;
        boolean bl3 = false;
        if (ReactorLibraryUtil.isReactorPublisher(it)) return true;
        Iterable iterable = ReactorReactiveStreamsImplementationKt.access$getExtensionsClasses$p();
        PsiClass psiClass3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"it");
        if (!CollectionsKt.contains((Iterable)iterable, (Object)psiClass3.getQualifiedName())) return false;
        return true;
    }

    @Override
    public boolean shouldBeCollapsed(@NotNull UCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return ReactorLibraryUtil.isReactorPublisher(callExpression.getReceiverType());
    }

    @Override
    @Nullable
    public ThrowReplacementInfo createThrowReplacementInfo(@NotNull UCallExpression methodCall, @NotNull UElement functionalObject2) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
                Intrinsics.checkNotNullParameter((Object)functionalObject2, (String)"functionalObject");
                if (!CollectionsKt.contains((Iterable)this.APPROPRIATE_METHODS, (Object)methodCall.getMethodName())) {
                    return null;
                }
                if (!this.isFunctionalObjectInRightPosition(methodCall, functionalObject2)) {
                    return null;
                }
                if (!ReactorLibraryUtil.isReactorPublisher(methodCall.getReceiverType()) && !this.isReferencesOnReactorPublisher(methodCall.getReceiver())) break block5;
                PsiMethod psiMethod = methodCall.resolve();
                if (ReactorLibraryUtil.isReactorPublisher((PsiClass)(psiMethod != null ? psiMethod.getContainingClass() : null))) break block6;
            }
            return null;
        }
        return new ThrowReplacementInfo(this, methodCall, functionalObject2){
            final /* synthetic */ ReactorReactiveStreamsImplementation this$0;
            final /* synthetic */ UCallExpression $methodCall;
            final /* synthetic */ UElement $functionalObject;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public ThrowReplacementInfo.ReplaceType getReplaceType() {
                block7: {
                    block6: {
                        block5: {
                            if (!Intrinsics.areEqual((Object)this.$methodCall.getMethodName(), (Object)"flatMap") && !Intrinsics.areEqual((Object)this.$methodCall.getMethodName(), (Object)"using")) break block6;
                            v0 = this.$functionalObject.getUastParent();
                            if (!(v0 instanceof UCallExpression)) {
                                v0 = null;
                            }
                            if ((v1 /* !! */  = (UCallExpression)v0) == null || (v1 /* !! */  = v1 /* !! */ .getReturnType()) == null) ** GOTO lbl-1000
                            var1_1 = v1 /* !! */ ;
                            var2_2 = false;
                            var3_3 = false;
                            returnType = var1_1;
                            $i$a$-let-ReactorReactiveStreamsImplementation$createThrowReplacementInfo$1$replaceType$1 = false;
                            var6_6 = CollectionsKt.listOf((Object[])new String[]{"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"});
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (String)element$iv;
                                $i$a$-firstOrNull-ReactorReactiveStreamsImplementation$createThrowReplacementInfo$1$replaceType$1$1 = false;
                                if (!InheritanceUtil.isInheritor((PsiType)returnType, (String)it)) continue;
                                v2 = element$iv;
                                break block5;
                            }
                            v2 = null;
                        }
                        if ((v3 = (String)v2) == null) {
                            v3 = v1 /* !! */  = "reactor.core.publisher.Flux";
                        }
                        if (v3 != null) {
                            var1_1 = v1 /* !! */ ;
                            var2_2 = false;
                            var3_3 = false;
                            it = var1_1;
                            $i$a$-let-ReactorReactiveStreamsImplementation$createThrowReplacementInfo$1$replaceType$2 = false;
                            v4 = new ThrowReplacementInfo.ReplaceType.ReplaceWithReturnType("error", (String)it);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = null;
                        }
                        v5 = v4;
                        break block7;
                    }
                    v5 = new ThrowReplacementInfo.ReplaceType.ReplaceWithMethodCallType("error", ReactorReactiveStreamsImplementation.access$lambdaParameterIndexByMethod(this.this$0, this.$methodCall));
                }
                return v5;
            }

            @NotNull
            public ThrowReplacementInfo.MethodType getMethodType() {
                String string = this.$methodCall.getMethodName();
                boolean bl = false;
                boolean bl2 = false;
                String methodName = string;
                boolean bl3 = false;
                return Intrinsics.areEqual((Object)methodName, (Object)"flatMap") || Intrinsics.areEqual((Object)methodName, (Object)"handle") ? ThrowReplacementInfo.MethodType.OPERATOR : ThrowReplacementInfo.MethodType.FACTORY;
            }

            @NotNull
            public String getFrameworkName() {
                return "Reactor";
            }

            @NotNull
            public UCallExpression getCallExpression() {
                return this.$methodCall;
            }
            {
                this.this$0 = this$0;
                this.$methodCall = $captured_local_variable$1;
                this.$functionalObject = $captured_local_variable$2;
            }
        };
    }

    @Override
    @NotNull
    public ReactiveStreamsImplementation.NonBlockingAnalysisManager getBlockingNonBlockingAnalysisManager() {
        return new ReactorNonBlockingAnalysisManager();
    }

    @Override
    @Nullable
    public Boolean canMethodLambdaReturnNull(@NotNull PsiMethod method, @Nullable PsiParameter functionalParameter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!ReactorLibraryUtil.isReactorPublisher(method.getContainingClass()) || !ReactorLibraryUtil.isReactorPublisher(method.getReturnType())) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"reactor.core.publisher.Mono")) {
            String string = method.getName();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            boolean bl4 = Intrinsics.areEqual((Object)it, (Object)"fromCallable") || Intrinsics.areEqual((Object)it, (Object)"fromSupplier");
            if (bl4) {
                return true;
            }
        }
        if (ReactorLibraryUtil.isReactorPublisher(method.getContainingClass()) && Intrinsics.areEqual((Object)method.getName(), (Object)"mapNotNull")) {
            return true;
        }
        return ReactiveStreamsUtils.isLambdaReturnTypeAcceptsNulls(functionalParameter);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<LocalQuickFix> provideQuickFixForLambdaReturningNull(@NotNull PsiMethod method, @Nullable PsiParameter functionalParameter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"map") ^ true) {
            return CollectionsKt.emptyList();
        }
        v0 = method.getContainingClass();
        var3_3 = v0 != null ? v0.findMethodsByName("mapNotNull", true) : null;
        var4_4 = false;
        var5_5 = false;
        if (var3_3 == null) ** GOTO lbl-1000
        var5_6 = var3_3;
        var6_7 = false;
        if (var5_6.length == 0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (v1) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)ReactorReplaceMapWithMapNotNullQuickFix.INSTANCE);
    }

    @Override
    @NotNull
    public Iterable<String> getPublisherImplementationsTypes() {
        Set<String> set = ReactorConstants.ALL_REACTIVE_ROOT_TYPES;
        Intrinsics.checkNotNullExpressionValue(set, (String)"ReactorConstants.ALL_REACTIVE_ROOT_TYPES");
        return set;
    }

    @Override
    @NotNull
    public Iterable<String> getPublisherInterfacesTypes() {
        return CollectionsKt.emptyList();
    }

    private final int lambdaIndexByMethod(UCallExpression methodCall) {
        return Intrinsics.areEqual((Object)methodCall.getMethodName(), (Object)"using") ? this.USING_LAMBDA_INDEX : 0;
    }

    private final int lambdaParameterIndexByMethod(UCallExpression methodCall) {
        return Intrinsics.areEqual((Object)methodCall.getMethodName(), (Object)"handle") ? this.HANDLE_LAMBDA_PARAMETER_INDEX : 0;
    }

    private final boolean isFunctionalObjectInRightPosition(UCallExpression methodCall, UElement argument) {
        return Intrinsics.areEqual((Object)methodCall.getArgumentForParameter(this.lambdaIndexByMethod(methodCall)), (Object)argument);
    }

    private final boolean isReferencesOnReactorPublisher(UExpression $this$isReferencesOnReactorPublisher) {
        UExpression uExpression = $this$isReferencesOnReactorPublisher;
        if (!(uExpression instanceof UReferenceExpression)) {
            uExpression = null;
        }
        UReferenceExpression uReferenceExpression = (UReferenceExpression)uExpression;
        Object object = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
        if (!(object instanceof PsiClass)) {
            object = null;
        }
        PsiClass psiClass = (PsiClass)object;
        return psiClass != null && ReactorLibraryUtil.isReactorPublisher(psiClass);
    }

    public ReactorReactiveStreamsImplementation() {
        this.USING_LAMBDA_INDEX = 1;
        this.HANDLE_LAMBDA_PARAMETER_INDEX = 1;
    }

    public static final /* synthetic */ int access$lambdaParameterIndexByMethod(ReactorReactiveStreamsImplementation $this, UCallExpression methodCall) {
        return $this.lambdaParameterIndexByMethod(methodCall);
    }
}

