/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.intention;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0010"}, d2={"Lcom/intellij/reactivestreams/intention/ReactiveStreamsUastIntentionBase;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailableInternal", "isEnabledByKotlin", "language", "Lcom/intellij/lang/Language;", "isImplementationAvailable", "intellij.reactivestreams"})
public abstract class ReactiveStreamsUastIntentionBase
extends PsiElementBaseIntentionAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!ReactiveStreamsUtils.hasReactiveStreamsInProject(project)) return false;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"element.containingFile.language");
        if (UastCodeGenerationPlugin.Companion.byLanguage(language) == null) return false;
        PsiFile psiFile2 = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
        Language language2 = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"element.containingFile.language");
        if (!this.isEnabledByKotlin(language2)) return false;
        if (!this.isImplementationAvailable(project)) return false;
        if (!this.isAvailableInternal(project, editor, element)) return false;
        return true;
    }

    private final boolean isEnabledByKotlin(Language language) {
        return Intrinsics.areEqual((Object)language.getDisplayName(), (Object)"Kotlin") ^ true || Registry.is((String)"reactive.kotlin.quickfixes.enabled");
    }

    public abstract boolean isImplementationAvailable(@NotNull Project var1);

    protected abstract boolean isAvailableInternal(@NotNull Project var1, @Nullable Editor var2, @NotNull PsiElement var3);
}

