/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.reactivestreams.inspections.InternalCountStrategy;
import com.intellij.reactivestreams.inspections.InternalReplacementStrategy;
import com.intellij.reactivestreams.inspections.ReactorThrowInOperatorQuickfix;
import com.intellij.reactivestreams.intention.IntentionUtilKt;
import com.intellij.reactivestreams.intention.ReactiveStreamsOperatorsIntention;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J#\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactorThrowInOperatorQuickfix;", "Lcom/intellij/reactivestreams/intention/ReactiveStreamsOperatorsIntention;", "Lcom/intellij/codeInspection/LocalQuickFix;", "replacementStrategy", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "countStrategy", "Lcom/intellij/reactivestreams/inspections/InternalCountStrategy;", "(Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;Lcom/intellij/reactivestreams/inspections/InternalCountStrategy;)V", "getCountStrategy", "()Lcom/intellij/reactivestreams/inspections/InternalCountStrategy;", "getReplacementStrategy", "()Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailableInternal", "", "isImplementationAvailable", "intellij.reactivestreams.core"})
final class ReactorThrowInOperatorQuickfix
extends ReactiveStreamsOperatorsIntention
implements LocalQuickFix {
    @NotNull
    private final InternalReplacementStrategy replacementStrategy;
    @NotNull
    private final InternalCountStrategy countStrategy;

    @Override
    public boolean isImplementationAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @Override
    protected boolean isAvailableInternal(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return this.countStrategy.getQuickFixMessage(this.replacementStrategy.getText());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UThrowExpression uThrowExpression = (UThrowExpression)UastUtils.findContaining((PsiElement)element, UThrowExpression.class);
        if (uThrowExpression == null) {
            return;
        }
        UThrowExpression throwExpression = uThrowExpression;
        UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent((UElement)throwExpression, invoke.functionalObject.1.INSTANCE);
        if (uFunctionalObject == null) {
            return;
        }
        UFunctionalObject functionalObject2 = uFunctionalObject;
        this.countStrategy.invoke(functionalObject2, throwExpression, (Function1<? super UThrowExpression, Unit>)((Function1)new Function1<UThrowExpression, Unit>(this, project, functionalObject2){
            final /* synthetic */ ReactorThrowInOperatorQuickfix this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ UFunctionalObject $functionalObject;

            public final void invoke(@NotNull UThrowExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!this.this$0.getReplacementStrategy().replace(it, this.$project, this.$functionalObject)) {
                    Void void_ = IntentionUtilKt.fail((UElement)it, "cannot replace throw statement");
                    throw new KotlinNothingValueException();
                }
            }
            {
                this.this$0 = reactorThrowInOperatorQuickfix;
                this.$project = project;
                this.$functionalObject = uFunctionalObject;
                super(1);
            }
        }));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"descriptor.psiElement");
        this.invoke(project, null, psiElement);
    }

    @NotNull
    public final InternalReplacementStrategy getReplacementStrategy() {
        return this.replacementStrategy;
    }

    @NotNull
    public final InternalCountStrategy getCountStrategy() {
        return this.countStrategy;
    }

    public ReactorThrowInOperatorQuickfix(@NotNull InternalReplacementStrategy replacementStrategy, @NotNull InternalCountStrategy countStrategy) {
        Intrinsics.checkNotNullParameter((Object)replacementStrategy, (String)"replacementStrategy");
        Intrinsics.checkNotNullParameter((Object)countStrategy, (String)"countStrategy");
        this.replacementStrategy = replacementStrategy;
        this.countStrategy = countStrategy;
    }
}

