/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.inspections.ReactiveStreamsNullableInLambdaInTransformInspectionKt;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import com.intellij.reactivestreams.uast.ex.FunctionalObjectsUtil;
import com.intellij.reactivestreams.uast.ex.UCallExpressionContext;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import com.intellij.ultimate.PluginVerifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNullableInLambdaInTransformInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsUastInspectionBase;", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "intellij.reactivestreams.core"})
public final class ReactiveStreamsNullableInLambdaInTransformInspection
extends ReactiveStreamsUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder, onTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $onTheFly;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                UExpression uElement = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{ULambdaExpression.class, UObjectLiteralExpression.class, UCallableReferenceExpression.class});
                if (uElement == null) {
                    return;
                }
                if (Intrinsics.areEqual((Object)uElement.getSourcePsi(), (Object)element) ^ true) {
                    return;
                }
                UElement uElement2 = uElement.getUastParent();
                if (!(uElement2 instanceof UCallExpression)) {
                    uElement2 = null;
                }
                UCallExpression uCallExpression = (UCallExpression)uElement2;
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression methodCall = uCallExpression;
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
                ReactiveStreamsInspectionsManager inspectionsManager = ReactiveStreamsInspectionsManager.Companion.getInstance(project);
                PsiMethod psiMethod = methodCall.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod resolvedMethod = psiMethod;
                Boolean bl = inspectionsManager.canMethodLambdaReturnNull(resolvedMethod, UastUtils.getParameterForArgument((UCallExpression)methodCall, (UExpression)uElement));
                if (bl == null) {
                    return;
                }
                boolean canLambdaReturnNull = bl;
                if (canLambdaReturnNull) {
                    return;
                }
                List<LocalQuickFix> quickFixes = inspectionsManager.provideQuickFixForLambdaReturningNull(resolvedMethod, UastUtils.getParameterForArgument((UCallExpression)methodCall, (UExpression)uElement));
                if (uElement instanceof UCallableReferenceExpression) {
                    Project project2 = this.$holder.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"holder.project");
                    if (ReactiveStreamsNullableInLambdaInTransformInspectionKt.access$isNullableByExpression(uElement, project2)) {
                        ReactiveStreamsNullableInLambdaInTransformInspectionKt.access$addProblemToHolder(uElement, this.$holder, this.$onTheFly, quickFixes);
                        return;
                    }
                }
                UFunctionalObject<T> uFunctionalObject = UFunctionalObject.Companion.from((UElement)uElement, (Function1)new Function1<UElement, UCallExpressionContext>(methodCall){
                    final /* synthetic */ UCallExpression $methodCall;

                    @Nullable
                    public final UCallExpressionContext invoke(@NotNull UElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return FunctionalObjectsUtil.asContext(this.$methodCall);
                    }
                    {
                        this.$methodCall = uCallExpression;
                        super(1);
                    }
                });
                if (uFunctionalObject == null) {
                    return;
                }
                UFunctionalObject<T> functionalObject2 = uFunctionalObject;
                ReactiveStreamsNullableInLambdaInTransformInspectionKt.access$markAllNullableReturns(functionalObject2, this.$holder, this.$onTheFly, quickFixes);
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
            }
        };
    }

    public ReactiveStreamsNullableInLambdaInTransformInspection() {
        super(new Class[0]);
        PluginVerifier.verifyUltimatePlugin();
    }
}

