/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

public abstract class ReactiveStreamsInterfaceImplementationInspectionBase
extends ReactiveStreamsUastInspectionBase {
    protected ReactiveStreamsInterfaceImplementationInspectionBase() {
        super(UClass.class);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(1);
        }
        if (!this.isClassImplementingTargetInterface(aClass)) {
            return null;
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor(ReactiveStreamsInterfaceImplementationInspectionBase.getProblemElement(aClass), this.getProblemDescription(), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
    }

    private boolean isClassImplementingTargetInterface(@NotNull UClass aClass) {
        if (aClass == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(2);
        }
        if (aClass.getSourcePsi() instanceof PsiTypeParameter) {
            return false;
        }
        return aClass.getUastSuperTypes().stream().anyMatch(e -> this.getInterfaceQualifiedName().equals(e.getQualifiedName()));
    }

    @NotNull
    private static PsiElement getProblemElement(UClass aClass) {
        UElement anchor = aClass.getUastAnchor();
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)anchor);
        PsiElement psiElement = Objects.requireNonNullElseGet(identifier, () -> ((UClass)aClass).getPsi());
        if (psiElement == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    protected abstract String getInterfaceQualifiedName();

    @NotNull
    @InspectionMessage
    protected abstract String getProblemDescription();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/inspections/ReactiveStreamsInterfaceImplementationInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/inspections/ReactiveStreamsInterfaceImplementationInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isClassImplementingTargetInterface";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

