/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.intellij.updates;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.io.HttpRequests;
import io.ktor.initializr.intellij.options.KtorSettings;
import io.ktor.initializr.intellij.run.KtorLibraryUtilKt;
import io.ktor.initializr.intellij.updates.KtorUpdateComponent;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lio/ktor/initializr/intellij/updates/KtorUpdateComponent;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "()V", "checkForUpdates", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorCreated", "intellij.ktor.starter"})
public final class KtorUpdateComponent
implements EditorFactoryListener {
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"event.editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.editor.document");
        Document document2 = document;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
        VirtualFile file = virtualFile;
        String string2 = file.getExtension();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        if (Intrinsics.areEqual(string, (Object)"kt")) {
            this.checkForUpdates(event, file);
        }
    }

    private final void checkForUpdates(EditorFactoryEvent event, VirtualFile currentFile) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        long lastUpdate = propertiesComponent.getOrInitLong("ktor.last.update.timestamp", 0L);
        if (lastUpdate == 0L || System.currentTimeMillis() - lastUpdate > TimeUnit.DAYS.toMillis(1L)) {
            ReadAction.nonBlocking((Runnable)new Runnable(event, currentFile){
                final /* synthetic */ EditorFactoryEvent $event;
                final /* synthetic */ VirtualFile $currentFile;

                public final void run() {
                    Editor editor = this.$event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"event.editor");
                    Project project = editor.getProject();
                    if (project == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.editor.project ?: return@nonBlocking");
                    Project project2 = project;
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(this.$currentFile);
                    if (psiFile == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026le) ?: return@nonBlocking");
                    PsiFile psiFile2 = psiFile;
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
                    if (!KtorLibraryUtilKt.hasKtorLibrary(module)) {
                        return;
                    }
                    try {
                        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                        String string = applicationInfo.getBuild().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
                        String buildNumber = string;
                        PluginDescriptor pluginDescriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName((String)KtorSettings.class.getName());
                        Intrinsics.checkNotNull((Object)pluginDescriptor);
                        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"PluginManagerCore.getPlu\u2026tings::class.java.name)!!");
                        PluginDescriptor plugin = pluginDescriptor;
                        String pluginVersion = plugin.getVersion();
                        PluginId pluginId = plugin.getPluginId();
                        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
                        String string2 = pluginId.getIdString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.pluginId.idString");
                        String pluginId2 = string2;
                        String os = URLEncoder.encode(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, "UTF-8");
                        String uid = PluginDownloader.getMarketplaceDownloadsUUID();
                        String url = "https://plugins.jetbrains.com/plugins/list?pluginId=" + pluginId2 + "&build=" + buildNumber + "&pluginVersion=" + pluginVersion + "&os=" + os + "&uuid=" + uid;
                        PropertiesComponent.getInstance().setValue("ktor.last.update.timestamp", String.valueOf(System.currentTimeMillis()));
                        HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)checkForUpdates.1.INSTANCE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                {
                    this.$event = editorFactoryEvent;
                    this.$currentFile = virtualFile;
                }
            });
        }
    }
}

