/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.intellij.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import io.ktor.initializr.intellij.run.KtorLibraryUtilKt;
import io.ktor.initializr.intellij.run.KtorRunConfiguration;
import io.ktor.initializr.intellij.run.KtorRunConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lio/ktor/initializr/intellij/run/KtorRunConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lio/ktor/initializr/intellij/run/KtorRunConfiguration;", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "Companion", "intellij.ktor.starter"})
public final class KtorRunConfigurationProducer
extends JavaRunConfigurationProducerBase<KtorRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return KtorRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    protected boolean setupConfigurationFromContext(@NotNull KtorRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Module module = context.getModule();
        if (!KtorLibraryUtilKt.hasKtorLibrary(module)) {
            return false;
        }
        Pair pair = KtorRunConfigurationProducer.Companion.findKtorApplication((PsiElement)sourceElement.get());
        if (pair == null) {
            return false;
        }
        Pair classWithAnchor = pair;
        if (classWithAnchor.second != null) {
            sourceElement.set(classWithAnchor.second);
        }
        configuration.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)classWithAnchor.first)));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull KtorRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Module configurationModule;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
        Object object = configurationModule = javaRunConfigurationModule != null ? javaRunConfigurationModule.getModule() : null;
        if (!Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
            return false;
        }
        Pair pair = KtorRunConfigurationProducer.Companion.findKtorApplication(context.getPsiLocation());
        if (pair == null) {
            return false;
        }
        Pair contextClassWithAnchor = pair;
        PsiClass psiClass = configuration.getMainClass();
        String configFqn = psiClass != null ? psiClass.getName() : null;
        Object object2 = contextClassWithAnchor.first;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"contextClassWithAnchor.first");
        return Comparing.strEqual((String)configFqn, (String)((PsiClass)object2).getQualifiedName());
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        RunConfigurationModule runConfigurationModule;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RunConfiguration runConfiguration = other.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"other.configuration");
        RunConfiguration configuration = runConfiguration;
        return configuration instanceof ModuleBasedConfiguration && configuration instanceof CommonJavaRunConfigurationParameters && (runConfigurationModule = ((ModuleBasedConfiguration)configuration).getConfigurationModule()) instanceof JavaRunConfigurationModule;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"Lio/ktor/initializr/intellij/run/KtorRunConfigurationProducer$Companion;", "", "()V", "findKtorApplication", "Lcom/intellij/psi/PsiClass;", "mainClass", "uClass", "Lorg/jetbrains/uast/UClass;", "file", "Lorg/jetbrains/uast/UFile;", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "psiElement", "intellij.ktor.starter"})
    public static final class Companion {
        private final Pair<PsiClass, PsiElement> findKtorApplication(PsiElement psiElement) {
            if (psiElement == null) {
                return null;
            }
            UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType$default((PsiElement)psiElement, UMethod.class, (boolean)false, (int)2, null);
            if (uMethod != null) {
                PsiClass psiClass = UastUtils.getMainMethodClass((UMethod)uMethod);
                if (psiClass == null) {
                    return null;
                }
                PsiClass mainClass = psiClass;
                UFile uFile = (UFile)UastContextKt.getUastParentOfType$default((PsiElement)psiElement, UFile.class, (boolean)false, (int)2, null);
                if (uFile == null) {
                    return null;
                }
                UFile file = uFile;
                PsiClass psiClass2 = this.findKtorApplication(mainClass, file);
                if (psiClass2 == null) {
                    return null;
                }
                PsiClass psiClass3 = psiClass2;
                return Pair.create((Object)psiClass3, null);
            }
            UFile file = (UFile)UastContextKt.toUElement((PsiElement)psiElement, UFile.class);
            if (file != null) {
                for (UClass uClass : file.getClasses()) {
                    if (UastUtils.findMainInClass((UClass)uClass) == null) continue;
                    PsiClass psiClass = this.findKtorApplication(uClass.getJavaPsi(), file);
                    if (psiClass == null) {
                        return null;
                    }
                    PsiClass psiClass4 = psiClass;
                    return Pair.create((Object)psiClass4, (Object)UElementKt.getSourcePsiElement((UElement)((UElement)uClass)));
                }
                return null;
            }
            PsiClass psiClass = ApplicationConfigurationType.getMainClass((PsiElement)psiElement);
            if (psiClass == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"ApplicationConfiguration\u2026siElement) ?: return null");
            PsiClass mainClass = psiClass;
            file = (UFile)UastContextKt.getUastParentOfType$default((PsiElement)psiElement, UFile.class, (boolean)false, (int)2, null);
            if (file == null) {
                return null;
            }
            PsiClass psiClass5 = this.findKtorApplication(mainClass, file);
            if (psiClass5 == null) {
                return null;
            }
            PsiClass psiClass6 = psiClass5;
            return Pair.pair((Object)psiClass6, (Object)mainClass);
        }

        private final PsiClass findKtorApplication(PsiClass mainClass, UFile file) {
            if (KtorLibraryUtilKt.isKtorApplication(mainClass)) {
                return mainClass;
            }
            if (mainClass.getContainingClass() != null) {
                return null;
            }
            for (UClass uClass : file.getClasses()) {
                PsiClass psiClass = this.findKtorApplication(mainClass, uClass);
                if (psiClass == null) continue;
                return psiClass;
            }
            return null;
        }

        private final PsiClass findKtorApplication(PsiClass mainClass, UClass uClass) {
            PsiClass psiClass = uClass.getJavaPsi();
            if (psiClass != null && KtorLibraryUtilKt.isKtorApplication(psiClass) && Intrinsics.areEqual((Object)mainClass, (Object)KtorLibraryUtilKt.findMainClassCandidate(psiClass))) {
                return psiClass;
            }
            PsiClass psiClass2 = psiClass;
            if ((psiClass2 != null ? psiClass2.getContainingClass() : null) == null || psiClass.hasModifierProperty("static")) {
                for (UClass innerClass : uClass.getInnerClasses()) {
                    psiClass = this.findKtorApplication(mainClass, innerClass);
                    if (psiClass == null) continue;
                    return psiClass;
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

