/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.intellij.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import io.ktor.initializr.intellij.run.KtorLibraryUtilKt;
import io.ktor.initializr.intellij.run.KtorRunConfiguration;
import io.ktor.initializr.intellij.run.KtorRunConfigurationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0006\u0010\u000f\u001a\u00020\rJ\u0014\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/ktor/initializr/intellij/run/KtorRunConfigUtil;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "ktorMains", "", "", "ktorType", "Lio/ktor/initializr/intellij/run/KtorRunConfigurationType;", "runManager", "Lcom/intellij/execution/RunManager;", "createKtorRunConfigurationForClass", "", "ktorAppName", "createKtorRunConfigurations", "findKtorMains", "engineMains", "Lcom/intellij/psi/PsiMethod;", "hasKtorRunConfiguration", "", "ktorMainClass", "Companion", "intellij.ktor.starter"})
public final class KtorRunConfigUtil {
    private final RunManager runManager;
    private final KtorRunConfigurationType ktorType;
    private List<String> ktorMains;
    private final Module myModule;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void findKtorMains(@NotNull List<? extends PsiMethod> engineMains) {
        Intrinsics.checkNotNullParameter(engineMains, (String)"engineMains");
        this.ktorMains = KtorLibraryUtilKt.getKtorMainClasses(this.myModule, engineMains);
    }

    /*
     * WARNING - void declaration
     */
    public final void createKtorRunConfigurations() {
        void $this$forEach$iv;
        Iterable iterable = this.ktorMains;
        KtorRunConfigUtil ktorRunConfigUtil = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p1 = (String)element$iv;
            boolean bl = false;
            ktorRunConfigUtil.createKtorRunConfigurationForClass(p1);
        }
    }

    private final void createKtorRunConfigurationForClass(String ktorAppName) {
        ReadAction.nonBlocking((Callable)new Callable(this, ktorAppName){
            final /* synthetic */ KtorRunConfigUtil this$0;
            final /* synthetic */ String $ktorAppName;

            public final Boolean call() {
                return KtorRunConfigUtil.access$hasKtorRunConfiguration(this.this$0, this.$ktorAppName);
            }
            {
                this.this$0 = ktorRunConfigUtil;
                this.$ktorAppName = string;
            }
        }).finishOnUiThread(ModalityState.any(), new Consumer(this, ktorAppName){
            final /* synthetic */ KtorRunConfigUtil this$0;
            final /* synthetic */ String $ktorAppName;

            public final void accept(Boolean configExists) {
                if (!configExists.booleanValue()) {
                    try {
                        RunnerAndConfigurationSettings settings = KtorRunConfigUtil.access$getRunManager$p(this.this$0).createConfiguration("", KtorRunConfigUtil.access$getKtorType$p(this.this$0).getDefaultConfigurationFactory());
                        RunConfiguration runConfiguration = settings.getConfiguration();
                        if (runConfiguration == null) {
                            throw new NullPointerException("null cannot be cast to non-null type io.ktor.initializr.intellij.run.KtorRunConfiguration");
                        }
                        KtorRunConfiguration newRunConfig = (KtorRunConfiguration)runConfiguration;
                        newRunConfig.setModule(KtorRunConfigUtil.access$getMyModule$p(this.this$0));
                        newRunConfig.setMainClassName(this.$ktorAppName);
                        settings.setName(newRunConfig.suggestedName());
                        KtorRunConfigUtil.access$getRunManager$p(this.this$0).setUniqueNameIfNeeded(settings);
                        KtorRunConfigUtil.access$getRunManager$p(this.this$0).addConfiguration(settings);
                        if (KtorRunConfigUtil.access$getRunManager$p(this.this$0).getAllSettings().size() == 1) {
                            KtorRunConfigUtil.access$getRunManager$p(this.this$0).setSelectedConfiguration(settings);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Throwable t) {
                        KtorRunConfigUtil.Companion.getLOG().error("Error creating Ktor run configuration for " + this.$ktorAppName, t);
                    }
                }
            }
            {
                this.this$0 = ktorRunConfigUtil;
                this.$ktorAppName = string;
            }
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private final boolean hasKtorRunConfiguration(String ktorMainClass) {
        List list = ContainerUtil.findAll((Collection)this.runManager.getConfigurationsList((ConfigurationType)this.ktorType), KtorRunConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.findAll(\n \u2026uration::class.java\n    )");
        List allKtorRunConfigs = list;
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(allKtorRunConfigs, ktorMainClass){
            final /* synthetic */ List $allKtorRunConfigs;
            final /* synthetic */ String $ktorMainClass;

            /*
             * WARNING - void declaration
             */
            public final Boolean compute() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$allKtorRunConfigs;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtorRunConfiguration ktorRunConfiguration = (KtorRunConfiguration)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v0 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
                    PsiClass psiClass = v0.getMainClass();
                    String string = psiClass != null ? psiClass.getQualifiedName() : null;
                    collection.add(string);
                }
                return ((List)destination$iv$iv).contains(this.$ktorMainClass);
            }
            {
                this.$allKtorRunConfigs = list;
                this.$ktorMainClass = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Boole\u2026nClass?.qualifiedName } }");
        return (Boolean)object;
    }

    public KtorRunConfigUtil(@NotNull Module myModule) {
        Intrinsics.checkNotNullParameter((Object)myModule, (String)"myModule");
        this.myModule = myModule;
        Project project = this.myModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myModule.project");
        this.runManager = RunManager.Companion.getInstance(project);
        this.ktorType = KtorRunConfigurationType.Companion.getInstance();
        this.ktorMains = CollectionsKt.emptyList();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)KtorRunConfigUtil.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(KtorR\u2026il::class.java.getName())");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$hasKtorRunConfiguration(KtorRunConfigUtil $this, String ktorMainClass) {
        return $this.hasKtorRunConfiguration(ktorMainClass);
    }

    public static final /* synthetic */ RunManager access$getRunManager$p(KtorRunConfigUtil $this) {
        return $this.runManager;
    }

    public static final /* synthetic */ KtorRunConfigurationType access$getKtorType$p(KtorRunConfigUtil $this) {
        return $this.ktorType;
    }

    public static final /* synthetic */ Module access$getMyModule$p(KtorRunConfigUtil $this) {
        return $this.myModule;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/ktor/initializr/intellij/run/KtorRunConfigUtil$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ktor.starter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

