/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.intellij.run;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import io.ktor.initializr.intellij.run.EmbeddedServerSearcher;
import io.ktor.initializr.intellij.run.KtorLibraryUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a1\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005H\u0002\u001a\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\t\u001a\n\u0010 \u001a\u00020\u0001*\u00020!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"EMBEDDED_SERVER_FUNCTION", "", "ENGINE_MAIN_WORD", "KTOR_APPLICATION_FQNAME", "KTOR_ENGINE_MAINS", "", "getKTOR_ENGINE_MAINS", "()Ljava/util/List;", "findMainClassCandidate", "Lcom/intellij/psi/PsiClass;", "ktorClass", "findRootCallingMethods", "Lorg/jetbrains/uast/UMethod;", "element", "Lorg/jetbrains/uast/UElement;", "moduleScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getEmbeddedServerReferences", "module", "Lcom/intellij/openapi/module/Module;", "getEngineMainReferences", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/NotNull;", "engineMains", "Lcom/intellij/psi/PsiMethod;", "getKtorMainClasses", "hasKtorLibrary", "", "project", "Lcom/intellij/openapi/project/Project;", "isKtorApplication", "mainClass", "classFqName", "Lorg/jetbrains/uast/UFile;", "intellij.ktor.starter"})
public final class KtorLibraryUtilKt {
    @NotNull
    public static final String KTOR_APPLICATION_FQNAME = "io.ktor.application.Application";
    @NotNull
    public static final String ENGINE_MAIN_WORD = "EngineMain";
    @NotNull
    private static final List<String> KTOR_ENGINE_MAINS = CollectionsKt.listOf((Object[])new String[]{"io.ktor.server.cio.EngineMain", "io.ktor.server.tomcat.EngineMain", "io.ktor.server.jetty.EngineMain", "io.ktor.server.netty.EngineMain"});
    @NotNull
    public static final String EMBEDDED_SERVER_FUNCTION = "embeddedServer";

    public static final boolean hasKtorLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)KTOR_APPLICATION_FQNAME);
    }

    public static final boolean hasKtorLibrary(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)KTOR_APPLICATION_FQNAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKtorApplication(@NotNull PsiClass mainClass) {
        PsiMethod psiMethod;
        int n;
        block14: {
            Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
            if (!PsiMethodUtil.MAIN_CLASS.value((Object)mainClass)) return false;
            if (mainClass.hasModifierProperty("private")) {
                return false;
            }
            PsiMethod[] psiMethodArray = mainClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"mainClass.methods");
            PsiMethod[] psiMethodArray2 = psiMethodArray;
            boolean bl = false;
            PsiMethod[] psiMethodArray3 = psiMethodArray2;
            boolean bl2 = false;
            PsiMethod[] psiMethodArray4 = psiMethodArray3;
            n = psiMethodArray4.length;
            int n2 = 0;
            while (n2 < n) {
                PsiMethod it = psiMethod = psiMethodArray4[n2];
                boolean bl3 = false;
                PsiMethod psiMethod2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"it");
                if (!(Intrinsics.areEqual((Object)psiMethod2.getName(), (Object)"main") && !it.hasParameters() && Intrinsics.areEqual((Object)it.getReturnType(), (Object)PsiType.VOID))) {
                    ++n2;
                    continue;
                }
                break block14;
            }
            return false;
        }
        PsiMethod psiMethod3 = psiMethod;
        if (psiMethod3 == null) return false;
        PsiMethod mainMethod = psiMethod3;
        PsiCodeBlock psiCodeBlock = mainMethod.getBody();
        if (psiCodeBlock == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)psiCodeBlock, (String)"mainMethod.body ?: return false");
        PsiCodeBlock mainMethodBody = psiCodeBlock;
        PsiStatement[] psiStatementArray = mainMethodBody.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)psiStatementArray, (String)"mainMethodBody\n    .statements");
        PsiStatement[] $this$any$iv = psiStatementArray;
        boolean $i$f$any = false;
        PsiStatement[] psiStatementArray2 = $this$any$iv;
        int n3 = psiStatementArray2.length;
        n = 0;
        while (n < n3) {
            boolean bl;
            PsiStatement element$iv;
            PsiStatement statement = element$iv = psiStatementArray2[n];
            boolean bl4 = false;
            PsiElement $this$getUastParentOfType$iv = (PsiElement)statement;
            boolean strict$iv = false;
            boolean $i$f$getUastParentOfType = false;
            if ((UCallExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType$iv, UCallExpression.class, (boolean)strict$iv) == null) {
                bl = false;
            } else {
                UCallExpression uMthodCall;
                PsiType receiverType;
                PsiType psiType = receiverType = uMthodCall.getReceiverType();
                if (psiType == null) {
                    bl = Intrinsics.areEqual((Object)uMthodCall.getMethodName(), (Object)EMBEDDED_SERVER_FUNCTION);
                } else {
                    if (Intrinsics.areEqual((Object)uMthodCall.getMethodName(), (Object)"main")) {
                        boolean bl5;
                        Iterable $this$any$iv2 = KTOR_ENGINE_MAINS;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String p1 = (String)element$iv2;
                                boolean bl6 = false;
                                if (!receiverType.equalsToText(p1)) continue;
                                return true;
                            }
                            bl5 = false;
                        }
                        if (bl5) {
                            return true;
                        }
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Nullable
    public static final PsiClass findMainClassCandidate(@Nullable PsiClass ktorClass) {
        if (ktorClass == null) {
            return null;
        }
        UFile uFile = (UFile)UastContextKt.getUastParentOfType$default((PsiElement)((PsiElement)ktorClass), UFile.class, (boolean)false, (int)2, null);
        if (uFile == null) {
            return ktorClass;
        }
        UFile file = uFile;
        SmartList mainMethodCandidates = new SmartList();
        for (UClass uClass : file.getClasses()) {
            for (UMethod method : uClass.getMethods()) {
                if (UastUtils.getMainMethodClass((UMethod)method) == null) continue;
                mainMethodCandidates.add((Object)method);
            }
        }
        if (mainMethodCandidates.size() == 1) {
            PsiMethod psiMethod = ((UMethod)mainMethodCandidates.get(0)).getJavaPsi();
            return psiMethod.getContainingClass();
        }
        return ktorClass;
    }

    @NotNull
    public static final List<String> getKTOR_ENGINE_MAINS() {
        return KTOR_ENGINE_MAINS;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<String> getKtorMainClasses(@NotNull Module module, @NotNull List<? extends PsiMethod> engineMains) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterator it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(engineMains, (String)"engineMains");
        if (module.isDisposed()) return CollectionsKt.emptyList();
        if (DumbService.isDumb((Project)module.getProject())) return CollectionsKt.emptyList();
        if (!KtorLibraryUtilKt.hasKtorLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        Language language = Language.findLanguageByID((String)"kotlin");
        LanguageFileType kotlinFileType = language != null ? language.getAssociatedFileType() : null;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)module.getModuleContentWithDependenciesScope(), (FileType[])new FileType[]{(FileType)kotlinFileType});
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026e,\n    kotlinFileType\n  )");
        GlobalSearchScope moduleScope = globalSearchScope;
        Iterable $this$map$iv = KtorLibraryUtilKt.getEngineMainReferences(module, moduleScope, engineMains);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UElement uElement = UastContextKt.toUElement((PsiElement)it);
            collection.add(uElement);
        }
        List engineMainRefs = (List)destination$iv$iv;
        List<UElement> embeddedServerRefs = KtorLibraryUtilKt.getEmbeddedServerReferences(module, moduleScope);
        $this$mapTo$iv$iv = CollectionsKt.plus((Collection)engineMainRefs, (Iterable)embeddedServerRefs);
        boolean $i$f$flatMap22 = false;
        void $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        it = $this$flatMapTo$iv$iv.iterator();
        while (true) {
            List list;
            boolean $i$f$filter;
            block17: {
                UMethod it2;
                Iterable $this$filterTo$iv$iv;
                boolean $i$f$filterTo;
                Collection destination$iv$iv3;
                block16: {
                    block15: {
                        if (!it.hasNext()) break;
                        Object element$iv$iv = it.next();
                        UElement it3 = (UElement)element$iv$iv;
                        boolean bl = false;
                        Object object2 = it3;
                        if (object2 == null) break block15;
                        UElement uElement = object2;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        UElement engineMain = uElement;
                        boolean bl4 = false;
                        object2 = KtorLibraryUtilKt.findRootCallingMethods(engineMain, moduleScope);
                        if (object2 == null) break block15;
                        Iterable iterable2 = (Iterable)object2;
                        $i$f$filter = false;
                        Iterable iterable3 = iterable2;
                        destination$iv$iv3 = new ArrayList();
                        $i$f$filterTo = false;
                        object = $this$filterTo$iv$iv.iterator();
                        break block16;
                    }
                    list = null;
                    break block17;
                }
                while (object.hasNext()) {
                    Object t = object.next();
                    it2 = (UMethod)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it2.getName(), (Object)"main") && it2.getParameters().length <= 1)) continue;
                    destination$iv$iv3.add(t);
                }
                Iterable iterable4 = (List)destination$iv$iv3;
                $i$f$filter = false;
                $this$filterTo$iv$iv = iterable4;
                destination$iv$iv3 = new ArrayList();
                $i$f$filterTo = false;
                for (Object e : $this$filterTo$iv$iv) {
                    boolean bl;
                    JvmParameter[] jvmParameterArray;
                    it2 = (UMethod)e;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2.getParameters(), (String)"it.parameters");
                    boolean bl6 = false;
                    if (jvmParameterArray.length == 0) {
                        bl = true;
                    } else {
                        JvmType argType;
                        JvmParameter jvmParameter = it2.getParameters()[0];
                        Intrinsics.checkNotNullExpressionValue((Object)jvmParameter, (String)"it.parameters[0]");
                        Intrinsics.checkNotNullExpressionValue((Object)jvmParameter.getType(), (String)"it.parameters[0].type");
                        UClass parentClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)it2), UClass.class, (boolean)false, (int)2, null);
                        UFile parentFile = (UFile)UastUtils.getParentOfType$default((UElement)((UElement)it2), UFile.class, (boolean)false, (int)2, null);
                        UClass uClass = parentClass;
                        UFile uFile = parentFile;
                        bl = Intrinsics.areEqual((Object)(uClass != null ? uClass.getQualifiedName() : null), (Object)(uFile != null ? KtorLibraryUtilKt.classFqName(uFile) : null)) && argType instanceof PsiArrayType && ((PsiArrayType)argType).getComponentType().equalsToText("java.lang.String");
                    }
                    if (!bl) continue;
                    destination$iv$iv3.add(e);
                }
                Iterable iterable5 = (List)destination$iv$iv3;
                $i$f$filter = false;
                $this$filterTo$iv$iv = iterable5;
                destination$iv$iv3 = new ArrayList();
                $i$f$filterTo = false;
                object = $this$filterTo$iv$iv.iterator();
                while (object.hasNext()) {
                    boolean bl;
                    Object e = object.next();
                    UMethod mainMathod = (UMethod)e;
                    boolean bl7 = false;
                    UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)mainMathod));
                    if (uFile != null && (uFile = uFile.getSourcePsi()) != null && (uFile = uFile.getVirtualFile()) != null) {
                        UFile file = uFile;
                        bl = module.getModuleContentScope().contains((VirtualFile)file);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination$iv$iv3.add(e);
                }
                list = (List)destination$iv$iv3;
            }
            List list2 = list;
            $i$f$filter = false;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List ktorMains = (List)destination$iv$iv2;
        Iterable $i$f$flatMap22 = ktorMains;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object t;
            Object element$iv$iv = t = iterator.next();
            boolean bl = false;
            UMethod it4 = (UMethod)element$iv$iv;
            boolean bl8 = false;
            if ((UFile)UastUtils.getParentOfType$default((UElement)((UElement)it4), UFile.class, (boolean)false, (int)2, null) != null) {
                boolean bl9 = false;
                boolean bl10 = false;
                UFile it5 = object;
                boolean bl11 = false;
                string = KtorLibraryUtilKt.classFqName(it5);
            } else {
                string = null;
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl12 = false;
            boolean bl13 = false;
            String it$iv$iv = string2;
            boolean bl14 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UMethod> findRootCallingMethods(UElement element, GlobalSearchScope moduleScope) {
        void $this$mapNotNullTo$iv$iv;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)element, UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return CollectionsKt.emptyList();
        }
        UMethod method = uMethod;
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement methodPsi = psiElement;
        Query query = ReferencesSearch.search((PsiElement)methodPsi, (SearchScope)((SearchScope)moduleScope));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(methodPsi, moduleScope)");
        Iterable $this$mapNotNull$iv = (Iterable)query;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiElement psiElement2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiReference it = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            PsiReference psiReference = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"it");
            if (psiReference.getElement() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiElement it$iv$iv = psiElement2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List refs = (List)destination$iv$iv;
        if (refs.isEmpty()) {
            return CollectionsKt.listOf((Object)method);
        }
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)refs), (Function1)findRootCallingMethods.1.INSTANCE), (Function1)((Function1)new Function1<UCallExpression, List<? extends UMethod>>(moduleScope){
            final /* synthetic */ GlobalSearchScope $moduleScope;

            @NotNull
            public final List<UMethod> invoke(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                return KtorLibraryUtilKt.access$findRootCallingMethods((UElement)call, this.$moduleScope);
            }
            {
                this.$moduleScope = globalSearchScope;
                super(1);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PsiElement> getEngineMainReferences(Module module, GlobalSearchScope moduleScope, List<? extends PsiMethod> engineMains) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = engineMains;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            GlobalSearchScope engineMainScope;
            void it;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            PsiMethod psiMethod = (PsiMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)CacheManager.getInstance((Project)module.getProject()).getFilesWithWord(ENGINE_MAIN_WORD, (short)1, moduleScope, true), (String)"CacheManager.getInstance\u2026_CODE, moduleScope, true)");
            boolean $i$f$map22 = false;
            void var14_16 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            void var17_21 = $this$mapTo$iv$iv2;
            int n = ((void)var17_21).length;
            for (int i = 0; i < n; ++i) {
                void p1;
                void item$iv$iv2;
                void var21_26 = item$iv$iv2 = var17_21[i];
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                VirtualFile virtualFile = p1.getVirtualFile();
                collection2.add(virtualFile);
            }
            List filesWithEngineMain = (List)destination$iv$iv2;
            Intrinsics.checkNotNullExpressionValue((Object)GlobalSearchScope.filesScope((Project)module.getProject(), (Collection)filesWithEngineMain), (String)"GlobalSearchScope.filesS\u2026ect, filesWithEngineMain)");
            Query query = ReferencesSearch.search((PsiElement)((PsiElement)it), (SearchScope)((SearchScope)engineMainScope));
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(it, engineMainScope)");
            Iterable $i$f$map22 = (Iterable)query;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement psiElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                PsiReference it2 = (PsiReference)element$iv$iv;
                boolean bl4 = false;
                PsiReference psiReference = it2;
                Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"it");
                if (psiReference.getElement() == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                PsiElement it$iv$iv = psiElement;
                boolean bl7 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UElement> getEmbeddedServerReferences(Module module, GlobalSearchScope moduleScope) {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = CacheManager.getInstance((Project)module.getProject()).getFilesWithWord(EMBEDDED_SERVER_FUNCTION, (short)1, moduleScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"CacheManager.getInstance\u2026_CODE, moduleScope, true)");
        Iterable $this$mapNotNull$iv = ArraysKt.asIterable((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UElement uElement;
            void $this$getUastParentOfType$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiFile p1 = (PsiFile)element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement = (PsiElement)p1;
            boolean strict$iv = false;
            boolean $i$f$getUastParentOfType = false;
            if (UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType$iv, UElement.class, (boolean)strict$iv) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            UElement it$iv$iv = uElement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filesWithEmbeddedServer = (List)destination$iv$iv;
        EmbeddedServerSearcher searcher = new EmbeddedServerSearcher();
        Iterable $this$forEach$iv = filesWithEmbeddedServer;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            UElement it = (UElement)element$iv;
            boolean bl = false;
            it.accept((UastVisitor)searcher);
        }
        return searcher.getReferences();
    }

    @NotNull
    public static final String classFqName(@NotNull UFile $this$classFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$classFqName, (String)"$this$classFqName");
        StringBuilder stringBuilder = new StringBuilder().append($this$classFqName.getPackageName()).append('.');
        String string = $this$classFqName.getSourcePsi().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcePsi.name");
        return stringBuilder.append(StringsKt.replace$default((String)string, (String)".kt", (String)"Kt", (boolean)false, (int)4, null)).toString();
    }

    public static final /* synthetic */ List access$findRootCallingMethods(UElement element, GlobalSearchScope moduleScope) {
        return KtorLibraryUtilKt.findRootCallingMethods(element, moduleScope);
    }
}

