/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.intellij.features;

import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import io.ktor.initializr.api.json.KtorFeatureSearchResult;
import io.ktor.initializr.intellij.features.KtorFeatureEventHandler;
import io.ktor.initializr.intellij.features.KtorFeaturesGroup;
import io.ktor.initializr.intellij.features.ListKtorFeatureComponent;
import io.ktor.initializr.intellij.features.UIKtorFeatureGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\bJ.\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001bH\u0002J\b\u0010(\u001a\u00020\u0017H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010-\u001a\u00020\u00172\b\b\u0002\u0010.\u001a\u00020/H\u0007J\u0016\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\bJ\u000e\u00101\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00102\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\tJ\u0014\u00102\u001a\u00020\u00172\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t0\fJ\u0014\u00104\u001a\u00020\u00172\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000006R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u00068"}, d2={"Lio/ktor/initializr/intellij/features/KtorFeaturesGroupComponent;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "layout", "Ljava/awt/LayoutManager;", "myEventHandler", "Lio/ktor/initializr/intellij/features/KtorFeatureEventHandler;", "myFunction", "Lkotlin/Function1;", "Lio/ktor/initializr/api/json/KtorFeatureSearchResult;", "Lio/ktor/initializr/intellij/features/ListKtorFeatureComponent;", "(Ljava/awt/LayoutManager;Lio/ktor/initializr/intellij/features/KtorFeatureEventHandler;Lkotlin/jvm/functions/Function1;)V", "groups", "", "Lio/ktor/initializr/intellij/features/UIKtorFeatureGroup;", "getGroups", "()Ljava/util/List;", "getMyEventHandler", "()Lio/ktor/initializr/intellij/features/KtorFeatureEventHandler;", "myGroups", "", "selection", "getSelection", "addGroup", "", "group", "Lio/ktor/initializr/intellij/features/KtorFeaturesGroup;", "groupIndex", "", "descriptors", "addLazyGroup", "scrollBar", "Ljavax/swing/JScrollBar;", "gapSize", "uiCallback", "Ljava/lang/Runnable;", "addToGroup", "feature", "features", "index", "eventIndex", "clear", "getComponentIndex", "component", "Ljava/awt/Component;", "getEventIndexForGroup", "initialSelection", "scrollAndFocus", "", "removeFromGroup", "removeGroup", "setSelection", "components", "setSelectionListener", "listener", "Ljava/util/function/Consumer;", "Companion", "intellij.ktor.starter"})
public class KtorFeaturesGroupComponent
extends JBPanelWithEmptyText {
    private final List<UIKtorFeatureGroup> myGroups;
    @NotNull
    private final KtorFeatureEventHandler myEventHandler;
    private final Function1<KtorFeatureSearchResult, ListKtorFeatureComponent> myFunction;
    @NotNull
    private static final Color SECTION_HEADER_FOREGROUND;
    private static final Color SECTION_HEADER_BACKGROUND;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<UIKtorFeatureGroup> getGroups() {
        return this.myGroups;
    }

    public final void setSelectionListener(@NotNull Consumer<KtorFeaturesGroupComponent> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.myEventHandler.setSelectionListener(listener2);
    }

    @NotNull
    public final List<ListKtorFeatureComponent> getSelection() {
        return this.myEventHandler.getSelection();
    }

    public final void setSelection(@NotNull ListKtorFeatureComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myEventHandler.setSelection(component);
    }

    public final void setSelection(@NotNull List<ListKtorFeatureComponent> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.myEventHandler.setSelection(components);
    }

    @JvmOverloads
    public final void addGroup(@NotNull KtorFeaturesGroup group, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.addGroup(group, group.getElements(), groupIndex);
    }

    public static /* synthetic */ void addGroup$default(KtorFeaturesGroupComponent ktorFeaturesGroupComponent, KtorFeaturesGroup ktorFeaturesGroup, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGroup");
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        ktorFeaturesGroupComponent.addGroup(ktorFeaturesGroup, n);
    }

    @JvmOverloads
    public final void addGroup(@NotNull KtorFeaturesGroup group) {
        KtorFeaturesGroupComponent.addGroup$default(this, group, 0, 2, null);
    }

    public final void addLazyGroup(@NotNull KtorFeaturesGroup group, @NotNull JScrollBar scrollBar, int gapSize, @NotNull Runnable uiCallback) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)scrollBar, (String)"scrollBar");
        Intrinsics.checkNotNullParameter((Object)uiCallback, (String)"uiCallback");
        if (group.getElements().size() <= gapSize) {
            KtorFeaturesGroupComponent.addGroup$default(this, group, 0, 2, null);
        } else {
            this.addGroup(group, group.getElements().subList(0, gapSize), -1);
            AdjustmentListener listener2 = new AdjustmentListener(this, scrollBar, group, gapSize, uiCallback){
                final /* synthetic */ KtorFeaturesGroupComponent this$0;
                final /* synthetic */ JScrollBar $scrollBar;
                final /* synthetic */ KtorFeaturesGroup $group;
                final /* synthetic */ int $gapSize;
                final /* synthetic */ Runnable $uiCallback;

                public void adjustmentValueChanged(@NotNull AdjustmentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.$scrollBar.getValue() + this.$scrollBar.getVisibleAmount() >= this.$scrollBar.getMaximum()) {
                        UIKtorFeatureGroup uIKtorFeatureGroup = this.$group.getUi();
                        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup);
                        int fromIndex = uIKtorFeatureGroup.getFeatures().size();
                        int toIndex = Math.min(fromIndex + this.$gapSize, this.$group.getElements().size());
                        UIKtorFeatureGroup uIKtorFeatureGroup2 = this.$group.getUi();
                        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup2);
                        ListKtorFeatureComponent lastComponent = uIKtorFeatureGroup2.getFeatures().get(fromIndex - 1);
                        int uiIndex = KtorFeaturesGroupComponent.access$getComponentIndex(this.this$0, lastComponent);
                        int eventIndex = this.this$0.getMyEventHandler().getCellIndex(lastComponent);
                        KtorFeaturesGroupComponent.access$addToGroup(this.this$0, this.$group, this.$group.getElements().subList(fromIndex, toIndex), uiIndex, eventIndex);
                        int n = this.$group.getElements().size();
                        UIKtorFeatureGroup uIKtorFeatureGroup3 = this.$group.getUi();
                        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup3);
                        if (n == uIKtorFeatureGroup3.getFeatures().size()) {
                            this.$scrollBar.removeAdjustmentListener(this);
                        }
                        this.$uiCallback.run();
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$scrollBar = $captured_local_variable$1;
                    this.$group = $captured_local_variable$2;
                    this.$gapSize = $captured_local_variable$3;
                    this.$uiCallback = $captured_local_variable$4;
                }
            };
            scrollBar.addAdjustmentListener(listener2);
        }
    }

    private final void addGroup(KtorFeaturesGroup group, List<KtorFeatureSearchResult> descriptors, int groupIndex) {
        UIKtorFeatureGroup uiGroup = new UIKtorFeatureGroup();
        group.setUi(uiGroup);
        this.myGroups.add(groupIndex == -1 ? this.myGroups.size() : groupIndex, uiGroup);
        OpaquePanel panel3 = new OpaquePanel((LayoutManager)new BorderLayout(), SECTION_HEADER_BACKGROUND);
        panel3.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JLabel title2 = new JLabel(group, group.getGroupTitle()){
            final /* synthetic */ KtorFeaturesGroup $group;

            @NotNull
            public Dimension getPreferredSize() {
                int n;
                Container parent;
                Dimension size = super.getPreferredSize();
                Container container = parent = this.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"parent");
                Insets insets = container.getInsets();
                int n2 = parent.getWidth() - insets.left - insets.right;
                if (parent.getComponentCount() == 2) {
                    Component component = parent.getComponent(1);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"parent.getComponent(1)");
                    n = component.getWidth() + JBUIScale.scale((int)20);
                } else {
                    n = 0;
                }
                size.width = Math.min(n2 - n, size.width);
                Dimension dimension = size;
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"size");
                return dimension;
            }

            @Nullable
            public String getToolTipText() {
                return super.getPreferredSize().width > this.getWidth() ? super.getToolTipText() : null;
            }
            {
                this.$group = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        title2.setToolTipText(group.getGroupTitle());
        title2.setForeground(SECTION_HEADER_FOREGROUND);
        panel3.add((Component)title2, (Object)"West");
        group.setTitleLabel(title2);
        int index2 = 0;
        int eventIndex = 0;
        if (groupIndex == 0) {
            this.add((Component)panel3, 0);
            index2 = 1;
            eventIndex = 0;
        } else if (groupIndex == -1) {
            this.add((Component)panel3);
            index2 = eventIndex = -1;
        } else {
            boolean bl = groupIndex < this.myGroups.size();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Component component = this.myGroups.get(groupIndex + 1).getPanel();
            Intrinsics.checkNotNull((Object)component);
            index2 = this.getComponentIndex(component);
            bl = index2 != -1;
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.add((Component)panel3, index2++);
            eventIndex = this.getEventIndexForGroup(groupIndex + 1);
        }
        uiGroup.setPanel((Component)panel3);
        this.addToGroup(group, descriptors, index2, eventIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final int getEventIndexForGroup(int groupIndex) {
        int n = groupIndex;
        boolean bl = false;
        while (n >= 0) {
            void i;
            List<ListKtorFeatureComponent> plugins = this.myGroups.get((int)i).getFeatures();
            if (!plugins.isEmpty()) {
                return this.myEventHandler.getCellIndex(plugins.get(0));
            }
            --i;
        }
        return -1;
    }

    private final void addToGroup(KtorFeaturesGroup group, List<KtorFeatureSearchResult> features, int index2, int eventIndex) {
        int index3 = index2;
        int eventIndex2 = eventIndex;
        for (KtorFeatureSearchResult feature : features) {
            ListKtorFeatureComponent featureComponent = (ListKtorFeatureComponent)this.myFunction.invoke((Object)feature);
            UIKtorFeatureGroup uIKtorFeatureGroup = group.getUi();
            Intrinsics.checkNotNull((Object)uIKtorFeatureGroup);
            uIKtorFeatureGroup.getFeatures().add(featureComponent);
            this.add(featureComponent, index3);
            this.myEventHandler.addCell(featureComponent, eventIndex2);
            featureComponent.setListeners(this.myEventHandler);
            if (index3 != -1) {
                ++index3;
            }
            if (eventIndex2 == -1) continue;
            ++eventIndex2;
        }
    }

    public final void addToGroup(@NotNull KtorFeaturesGroup group, @NotNull KtorFeatureSearchResult feature) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        int index2 = group.addWithIndex(feature);
        ListKtorFeatureComponent anchor = null;
        int uiIndex = -1;
        UIKtorFeatureGroup uIKtorFeatureGroup = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup);
        if (index2 == uIKtorFeatureGroup.getFeatures().size()) {
            UIKtorFeatureGroup uIKtorFeatureGroup2 = group.getUi();
            Intrinsics.checkNotNull((Object)uIKtorFeatureGroup2);
            int groupIndex = this.myGroups.indexOf(uIKtorFeatureGroup2);
            if (groupIndex < this.myGroups.size() - 1) {
                UIKtorFeatureGroup nextGroup = this.myGroups.get(groupIndex + 1);
                anchor = nextGroup.getFeatures().get(0);
                Component component = nextGroup.getPanel();
                Intrinsics.checkNotNull((Object)component);
                uiIndex = this.getComponentIndex(component);
            }
        } else {
            UIKtorFeatureGroup uIKtorFeatureGroup3 = group.getUi();
            Intrinsics.checkNotNull((Object)uIKtorFeatureGroup3);
            anchor = uIKtorFeatureGroup3.getFeatures().get(index2);
            uiIndex = this.getComponentIndex(anchor);
        }
        ListKtorFeatureComponent pluginComponent = (ListKtorFeatureComponent)this.myFunction.invoke((Object)feature);
        UIKtorFeatureGroup uIKtorFeatureGroup4 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup4);
        uIKtorFeatureGroup4.getFeatures().add(index2, pluginComponent);
        this.add(pluginComponent, uiIndex);
        this.myEventHandler.addCell(pluginComponent, anchor);
        pluginComponent.setListeners(this.myEventHandler);
    }

    public final void removeGroup(@NotNull KtorFeaturesGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Collection collection = this.myGroups;
        UIKtorFeatureGroup uIKtorFeatureGroup = group.getUi();
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(uIKtorFeatureGroup);
        UIKtorFeatureGroup uIKtorFeatureGroup2 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup2);
        this.remove(uIKtorFeatureGroup2.getPanel());
        UIKtorFeatureGroup uIKtorFeatureGroup3 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup3);
        for (ListKtorFeatureComponent plugin : uIKtorFeatureGroup3.getFeatures()) {
            this.remove(plugin);
            this.myEventHandler.removeCell(plugin);
        }
        this.myEventHandler.updateSelection();
    }

    public final void removeFromGroup(@NotNull KtorFeaturesGroup group, @NotNull KtorFeatureSearchResult feature) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        UIKtorFeatureGroup uIKtorFeatureGroup = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup);
        int index2 = ContainerUtil.indexOf(uIKtorFeatureGroup.getFeatures(), (Condition)new Condition(feature){
            final /* synthetic */ KtorFeatureSearchResult $feature;

            public final boolean value(@NotNull ListKtorFeatureComponent component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return component.getFeatureId() == this.$feature.getId();
            }
            {
                this.$feature = ktorFeatureSearchResult;
            }
        });
        boolean bl = index2 != -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        UIKtorFeatureGroup uIKtorFeatureGroup2 = group.getUi();
        Intrinsics.checkNotNull((Object)uIKtorFeatureGroup2);
        ListKtorFeatureComponent component = uIKtorFeatureGroup2.getFeatures().remove(index2);
        this.remove(component);
        this.myEventHandler.removeCell(component);
        if (component.getSelection() == EventHandler.SelectionType.SELECTION) {
            this.myEventHandler.updateSelection();
        }
        group.getElements().remove(feature);
    }

    /*
     * WARNING - void declaration
     */
    private final int getComponentIndex(Component component) {
        int components = this.getComponentCount();
        int n = 0;
        int n2 = components;
        while (n < n2) {
            void i;
            if (this.getComponent((int)i) == component) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public void clear() {
        this.myGroups.clear();
        this.myEventHandler.clear();
        this.removeAll();
    }

    @JvmOverloads
    public final void initialSelection(boolean scrollAndFocus) {
        SwingUtilities.invokeLater(new Runnable(this, scrollAndFocus){
            final /* synthetic */ KtorFeaturesGroupComponent this$0;
            final /* synthetic */ boolean $scrollAndFocus;

            public final void run() {
                this.this$0.getMyEventHandler().initialSelection(this.$scrollAndFocus);
                Collection collection = KtorFeaturesGroupComponent.access$getMyGroups$p(this.this$0);
                boolean bl = false;
                if (!collection.isEmpty()) {
                    Component component = ((UIKtorFeatureGroup)KtorFeaturesGroupComponent.access$getMyGroups$p(this.this$0).get(0)).getPanel();
                    Intrinsics.checkNotNull((Object)component);
                    this.this$0.scrollRectToVisible(component.getBounds());
                }
            }
            {
                this.this$0 = ktorFeaturesGroupComponent;
                this.$scrollAndFocus = bl;
            }
        });
    }

    public static /* synthetic */ void initialSelection$default(KtorFeaturesGroupComponent ktorFeaturesGroupComponent, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialSelection");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        ktorFeaturesGroupComponent.initialSelection(bl);
    }

    @JvmOverloads
    public final void initialSelection() {
        KtorFeaturesGroupComponent.initialSelection$default(this, false, 1, null);
    }

    @NotNull
    public final KtorFeatureEventHandler getMyEventHandler() {
        return this.myEventHandler;
    }

    public KtorFeaturesGroupComponent(@NotNull LayoutManager layout, @NotNull KtorFeatureEventHandler myEventHandler, @NotNull Function1<? super KtorFeatureSearchResult, ListKtorFeatureComponent> myFunction) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)myEventHandler, (String)"myEventHandler");
        Intrinsics.checkNotNullParameter(myFunction, (String)"myFunction");
        super(layout);
        this.myEventHandler = myEventHandler;
        this.myFunction = myFunction;
        this.myGroups = new ArrayList();
        this.myEventHandler.connect(this);
        this.setOpaque(true);
        this.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
    }

    static {
        Companion = new Companion(null);
        JBColor jBColor = JBColor.namedColor((String)"Plugins.SectionHeader.foreground", (Color)((Color)new JBColor(0x787878, 0x999999)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Plug\u2026olor(0x787878, 0x999999))");
        SECTION_HEADER_FOREGROUND = (Color)jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Plugins.SectionHeader.background", (Color)((Color)new JBColor(0xF7F7F7, 3948353)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"JBColor.namedColor(\"Plug\u2026olor(0xF7F7F7, 0x3C3F41))");
        SECTION_HEADER_BACKGROUND = (Color)jBColor2;
    }

    public static final /* synthetic */ int access$getComponentIndex(KtorFeaturesGroupComponent $this, Component component) {
        return $this.getComponentIndex(component);
    }

    public static final /* synthetic */ void access$addToGroup(KtorFeaturesGroupComponent $this, KtorFeaturesGroup group, List features, int index2, int eventIndex) {
        $this.addToGroup(group, features, index2, eventIndex);
    }

    public static final /* synthetic */ List access$getMyGroups$p(KtorFeaturesGroupComponent $this) {
        return $this.myGroups;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/ktor/initializr/intellij/features/KtorFeaturesGroupComponent$Companion;", "", "()V", "SECTION_HEADER_BACKGROUND", "Ljava/awt/Color;", "SECTION_HEADER_FOREGROUND", "getSECTION_HEADER_FOREGROUND", "()Ljava/awt/Color;", "intellij.ktor.starter"})
    public static final class Companion {
        @NotNull
        public final Color getSECTION_HEADER_FOREGROUND() {
            return SECTION_HEADER_FOREGROUND;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

