/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.intellij.features;

import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.JBValue;
import io.ktor.initializr.intellij.features.KtorFeaturesGroupComponent;
import io.ktor.initializr.intellij.features.ListKtorFeatureComponent;
import io.ktor.initializr.intellij.features.PageKtorFeatureLayout;
import io.ktor.initializr.intellij.features.UIKtorFeatureGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ktor/initializr/intellij/features/KtorFeatureListLayout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "Lio/ktor/initializr/intellij/features/PageKtorFeatureLayout;", "()V", "myGroupGap", "Lcom/intellij/util/ui/JBValue;", "myMiddleLineHeight", "", "calculateLineHeight", "", "lines", "getPageCount", "parent", "Ljavax/swing/JComponent;", "layoutContainer", "Ljava/awt/Container;", "preferredLayoutSize", "Ljava/awt/Dimension;", "intellij.ktor.starter"})
public final class KtorFeatureListLayout
extends AbstractLayoutManager
implements PageKtorFeatureLayout {
    private final JBValue myGroupGap = (JBValue)new JBValue.Float(10.0f);
    private int myMiddleLineHeight;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int height = 0;
        int count = parent.getComponentCount();
        int lines = 0;
        this.myMiddleLineHeight = 0;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            Component component = parent.getComponent((int)i);
            if (!(component instanceof AnimatedIcon)) {
                Component component2 = component;
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
                int lineHeight = component2.getPreferredSize().height;
                height += lineHeight;
                if (component instanceof ListKtorFeatureComponent) {
                    this.myMiddleLineHeight += lineHeight;
                    ++lines;
                }
            }
            ++i;
        }
        this.calculateLineHeight(lines);
        int size = ((KtorFeaturesGroupComponent)((Object)parent)).getGroups().size();
        if (size > 1) {
            height += this.myGroupGap.get() * (size - 1);
        }
        return new Dimension(0, height);
    }

    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        List<UIKtorFeatureGroup> groups = ((KtorFeaturesGroupComponent)((Object)parent)).getGroups();
        int width = parent.getWidth();
        int y = 0;
        int groupGap = this.myGroupGap.get();
        int lines = 0;
        this.myMiddleLineHeight = 0;
        for (UIKtorFeatureGroup group : groups) {
            Component component;
            Component component2 = component = group.getPanel();
            Intrinsics.checkNotNull((Object)component2);
            int height = component2.getPreferredSize().height;
            component.setBounds(0, y, width, height);
            y += height;
            for (ListKtorFeatureComponent KtorFeature : group.getFeatures()) {
                int lineHeight = KtorFeature.getPreferredSize().height;
                KtorFeature.setBounds(0, y, width, lineHeight);
                y += lineHeight;
                this.myMiddleLineHeight += lineHeight;
            }
            lines += group.getFeatures().size();
            y += groupGap;
        }
        this.calculateLineHeight(lines);
    }

    public final void calculateLineHeight(int lines) {
        this.myMiddleLineHeight = lines == 0 || this.myMiddleLineHeight == 0 ? 10 : (this.myMiddleLineHeight /= lines);
    }

    @Override
    public int getPageCount(@NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getVisibleRect().height / this.myMiddleLineHeight;
    }
}

