/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ktor.initializr.api.json.KtorBuildSystem;
import io.ktor.initializr.api.json.KtorConfiguration;
import io.ktor.initializr.api.json.KtorEngine;
import io.ktor.initializr.api.json.KtorKotlinVersion;
import io.ktor.initializr.api.json.KtorSettingOption;
import io.ktor.initializr.api.json.KtorVersion;
import io.ktor.initializr.api.json.OptionalSetting;
import io.ktor.initializr.api.json.ProjectSettingsTemplate;
import io.ktor.initializr.api.json.ProjectSettingsTemplateKt;
import io.ktor.initializr.api.json.TextSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a4\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u00060\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001f\u0010\u0010\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\u00060\u0005\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0001\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0001\u00a8\u0006\u001c"}, d2={"parseOption", "Lio/ktor/initializr/api/json/OptionalSetting$Option;", "jsonObject", "Lcom/google/gson/JsonObject;", "parseOptionalSetting", "Lio/ktor/initializr/api/json/OptionalSetting;", "T", "Lio/ktor/initializr/api/json/KtorSettingOption;", "parseType", "Lkotlin/Function1;", "parseProjectSettingsTemplate", "Lio/ktor/initializr/api/json/ProjectSettingsTemplate;", "jsonRootElement", "Lcom/google/gson/JsonElement;", "parseTextSetting", "Lio/ktor/initializr/api/json/TextSetting;", "defaultOption", "(Lio/ktor/initializr/api/json/OptionalSetting;)Lio/ktor/initializr/api/json/KtorSettingOption;", "toKotlinVersion", "Lio/ktor/initializr/api/json/KtorKotlinVersion;", "toKtorBuildSystem", "Lio/ktor/initializr/api/json/KtorBuildSystem;", "toKtorConfiguration", "Lio/ktor/initializr/api/json/KtorConfiguration;", "toKtorEngine", "Lio/ktor/initializr/api/json/KtorEngine;", "toKtorVersion", "Lio/ktor/initializr/api/json/KtorVersion;", "intellij.ktor.starter"})
public final class ProjectSettingsTemplateKt {
    @NotNull
    public static final ProjectSettingsTemplate parseProjectSettingsTemplate(@NotNull JsonElement jsonRootElement) {
        Intrinsics.checkNotNullParameter((Object)jsonRootElement, (String)"jsonRootElement");
        JsonElement jsonElement = jsonRootElement.getAsJsonObject().get("project_name");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonRootElement.asJsonOb\u2026ct[TEMPLATE_PROJECT_NAME]");
        JsonObject projectName2 = jsonElement.getAsJsonObject();
        JsonElement jsonElement2 = jsonRootElement.getAsJsonObject().get("company_website");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonRootElement.asJsonOb\u2026TEMPLATE_COMPANY_WEBSITE]");
        JsonObject companyWebsite = jsonElement2.getAsJsonObject();
        JsonElement jsonElement3 = jsonRootElement.getAsJsonObject().get("engine");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"jsonRootElement.asJsonObject[TEMPLATE_ENGINE]");
        JsonObject engine = jsonElement3.getAsJsonObject();
        JsonElement jsonElement4 = jsonRootElement.getAsJsonObject().get("ktor_version");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"jsonRootElement.asJsonOb\u2026ct[TEMPLATE_KTOR_VERSION]");
        JsonObject ktorVersion = jsonElement4.getAsJsonObject();
        JsonElement jsonElement5 = jsonRootElement.getAsJsonObject().get("kotlin_version");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"jsonRootElement.asJsonOb\u2026[TEMPLATE_KOTLIN_VERSION]");
        JsonObject kotlinVersion = jsonElement5.getAsJsonObject();
        JsonElement jsonElement6 = jsonRootElement.getAsJsonObject().get("build_system");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"jsonRootElement.asJsonOb\u2026ct[TEMPLATE_BUILD_SYSTEM]");
        JsonObject buildSystem = jsonElement6.getAsJsonObject();
        JsonElement jsonElement7 = jsonRootElement.getAsJsonObject().get("configuration_in");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"jsonRootElement.asJsonOb\u2026EMPLATE_CONFIGURATION_IN]");
        JsonObject configuration = jsonElement7.getAsJsonObject();
        JsonObject jsonObject = projectName2;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"projectName");
        TextSetting textSetting = ProjectSettingsTemplateKt.parseTextSetting(jsonObject);
        JsonObject jsonObject2 = companyWebsite;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"companyWebsite");
        TextSetting textSetting2 = ProjectSettingsTemplateKt.parseTextSetting(jsonObject2);
        JsonObject jsonObject3 = engine;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"engine");
        OptionalSetting<KtorEngine> optionalSetting = ProjectSettingsTemplateKt.parseOptionalSetting(jsonObject3, parseProjectSettingsTemplate.1.INSTANCE);
        JsonObject jsonObject4 = ktorVersion;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject4, (String)"ktorVersion");
        OptionalSetting<KtorVersion> optionalSetting2 = ProjectSettingsTemplateKt.parseOptionalSetting(jsonObject4, parseProjectSettingsTemplate.2.INSTANCE);
        JsonObject jsonObject5 = kotlinVersion;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject5, (String)"kotlinVersion");
        OptionalSetting<KtorKotlinVersion> optionalSetting3 = ProjectSettingsTemplateKt.parseOptionalSetting(jsonObject5, parseProjectSettingsTemplate.3.INSTANCE);
        JsonObject jsonObject6 = buildSystem;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject6, (String)"buildSystem");
        OptionalSetting<KtorBuildSystem> optionalSetting4 = ProjectSettingsTemplateKt.parseOptionalSetting(jsonObject6, parseProjectSettingsTemplate.4.INSTANCE);
        JsonObject jsonObject7 = configuration;
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject7, (String)"configuration");
        return new ProjectSettingsTemplate(textSetting, textSetting2, optionalSetting, optionalSetting2, optionalSetting3, optionalSetting4, ProjectSettingsTemplateKt.parseOptionalSetting(jsonObject7, parseProjectSettingsTemplate.5.INSTANCE));
    }

    private static final TextSetting parseTextSetting(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("default");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[\"default\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject[\"default\"].asString");
        return new TextSetting(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends KtorSettingOption> OptionalSetting<T> parseOptionalSetting(JsonObject jsonObject, Function1<? super OptionalSetting.Option, ? extends T> parseType) {
        Collection<KtorSettingOption> collection;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        JsonElement jsonElement = jsonObject.get("options");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[\"options\"]");
        JsonArray optionsArray = jsonElement.getAsJsonArray();
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)optionsArray.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            JsonElement jsonElement2 = optionsArray.get((int)it);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"optionsArray[it]");
            JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"optionsArray[it].asJsonObject");
            OptionalSetting.Option option = ProjectSettingsTemplateKt.parseOption(jsonObject2);
            collection2.add(option);
        }
        List options = (List)destination$iv$iv;
        JsonElement jsonElement3 = jsonObject.get("default_id");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"jsonObject[TEMPLATE_OPTION_DEFAULT]");
        String defaultId = jsonElement3.getAsString();
        Iterable $this$map$iv2 = options;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OptionalSetting.Option bl = (OptionalSetting.Option)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            KtorSettingOption ktorSettingOption = (KtorSettingOption)parseType.invoke((Object)it);
            collection.add(ktorSettingOption);
        }
        collection = (List)destination$iv$iv2;
        String string = defaultId;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultId");
        String string2 = string;
        List list = collection;
        return new OptionalSetting(list, string2);
    }

    private static final OptionalSetting.Option parseOption(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("id");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[\"id\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject[\"id\"].asString");
        JsonElement jsonElement2 = jsonObject.get("name");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonObject[\"name\"]");
        String string2 = jsonElement2.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject[\"name\"].asString");
        JsonElement jsonElement3 = jsonObject.get("tooltip");
        return new OptionalSetting.Option(string, string2, jsonElement3 != null ? jsonElement3.getAsString() : null);
    }

    @NotNull
    public static final KtorVersion toKtorVersion(@NotNull OptionalSetting.Option $this$toKtorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorVersion, (String)"$this$toKtorVersion");
        return new KtorVersion($this$toKtorVersion.getId(), $this$toKtorVersion.getName());
    }

    @NotNull
    public static final KtorKotlinVersion toKotlinVersion(@NotNull OptionalSetting.Option $this$toKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinVersion, (String)"$this$toKotlinVersion");
        return new KtorKotlinVersion($this$toKotlinVersion.getId(), $this$toKotlinVersion.getName());
    }

    @NotNull
    public static final KtorEngine toKtorEngine(@NotNull OptionalSetting.Option $this$toKtorEngine) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorEngine, (String)"$this$toKtorEngine");
        return new KtorEngine($this$toKtorEngine.getId(), $this$toKtorEngine.getName());
    }

    @NotNull
    public static final KtorBuildSystem toKtorBuildSystem(@NotNull OptionalSetting.Option $this$toKtorBuildSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorBuildSystem, (String)"$this$toKtorBuildSystem");
        return new KtorBuildSystem($this$toKtorBuildSystem.getId(), $this$toKtorBuildSystem.getName());
    }

    @NotNull
    public static final KtorConfiguration toKtorConfiguration(@NotNull OptionalSetting.Option $this$toKtorConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorConfiguration, (String)"$this$toKtorConfiguration");
        return new KtorConfiguration($this$toKtorConfiguration.getId(), $this$toKtorConfiguration.getName());
    }

    @NotNull
    public static final <T extends KtorSettingOption> T defaultOption(@NotNull OptionalSetting<T> $this$defaultOption) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$defaultOption, (String)"$this$defaultOption");
            Iterable iterable = $this$defaultOption.getOptions();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KtorSettingOption it = (KtorSettingOption)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$defaultOption.getDefaultId())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return (T)((KtorSettingOption)v0);
    }
}

