/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.initializr.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import io.ktor.initializr.api.KtorGeneratorWebAPI;
import io.ktor.initializr.api.KtorGeneratorWebAPIImpl;
import io.ktor.initializr.api.json.KtorFeatureDocumentation;
import io.ktor.initializr.api.json.KtorFeatureSearchResult;
import io.ktor.initializr.api.json.ProjectSettingsTemplate;
import io.ktor.initializr.api.json.SelectedProjectConfiguration;
import io.ktor.initializr.fus.KtorFusCollectorsKt;
import io.ktor.initializr.intellij.KtorStarterBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J/\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u000f0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002\u00a8\u0006\""}, d2={"Lio/ktor/initializr/api/KtorGeneratorWebAPIImpl;", "Lio/ktor/initializr/api/KtorGeneratorWebAPI;", "()V", "getFeatureDocumentation", "Lio/ktor/initializr/api/json/KtorFeatureDocumentation;", "featureId", "", "featureVersion", "getFeaturesList", "", "Lio/ktor/initializr/api/json/KtorFeatureSearchResult;", "ktorVersion", "getSettingsTemplate", "Lio/ktor/initializr/api/json/ProjectSettingsTemplate;", "parseJsonResponseFrom", "T", "path", "parse", "Lkotlin/Function1;", "Lcom/google/gson/JsonElement;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "postGenerateProject", "", "projectConfiguration", "Lio/ktor/initializr/api/json/SelectedProjectConfiguration;", "outputLocation", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "unzipSubfolder", "tempZipFile", "contentEntryDir", "Companion", "UnexpectedArchiveStructureException", "intellij.ktor.starter"})
public final class KtorGeneratorWebAPIImpl
implements KtorGeneratorWebAPI {
    @NotNull
    private static final String PROJECT_SETTINGS_PATH;
    @NotNull
    private static final String GEN_PROJECT_PATH;
    @NotNull
    private static final String USER_AGENT;
    private static final int CONNECT_TIMEOUT;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final <T> T parseJsonResponseFrom(String path, Function1<? super JsonElement, ? extends T> parse) {
        return (T)HttpRequests.request((String)(Companion.getKTOR_STARTER_URL() + path)).userAgent(USER_AGENT).connectTimeout(CONNECT_TIMEOUT).isReadResponseOnError(true).connect(new HttpRequests.RequestProcessor(parse){
            final /* synthetic */ Function1 $parse;

            public final T process(@NotNull HttpRequests.Request request) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                BufferedReader reader = null;
                try {
                    BufferedReader bufferedReader = request.getReader();
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"request.reader");
                    object = bufferedReader;
                }
                catch (IOException e) {
                    KtorGeneratorWebAPIImpl.Companion.getLOG().info("IOException loading JSON response from " + request.getURL(), (Throwable)e);
                    throw (Throwable)new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)false), e);
                }
                reader = object;
                try {
                    JsonElement jsonRootElement;
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonElement jsonElement = jsonRootElement = JsonParser.parseReader((JsonReader)jsonReader);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonRootElement");
                    object = this.$parse.invoke((Object)jsonElement);
                }
                catch (Throwable e) {
                    KtorGeneratorWebAPIImpl.Companion.getLOG().info("Error processing JSON response from " + request.getURL(), e);
                    throw (Throwable)new IOException("Error parsing JSON response", e);
                }
                return (T)object;
            }
            {
                this.$parse = function1;
            }
        });
    }

    @Override
    @NotNull
    public ProjectSettingsTemplate getSettingsTemplate() {
        return (ProjectSettingsTemplate)this.parseJsonResponseFrom(PROJECT_SETTINGS_PATH, getSettingsTemplate.1.INSTANCE);
    }

    @Override
    @NotNull
    public List<KtorFeatureSearchResult> getFeaturesList(@NotNull String ktorVersion) {
        Intrinsics.checkNotNullParameter((Object)ktorVersion, (String)"ktorVersion");
        Object t = this.parseJsonResponseFrom(Companion.featuresListPath(ktorVersion), getFeaturesList.1.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        List it = (List)t;
        boolean bl3 = false;
        KtorFusCollectorsKt.getKTOR_FUS_EVENT_FEATURES_REQUESTED().log();
        return (List)t;
    }

    @Override
    @NotNull
    public KtorFeatureDocumentation getFeatureDocumentation(@NotNull String featureId, @NotNull String featureVersion) {
        Intrinsics.checkNotNullParameter((Object)featureId, (String)"featureId");
        Intrinsics.checkNotNullParameter((Object)featureVersion, (String)"featureVersion");
        Object t = this.parseJsonResponseFrom(Companion.featureDocumentationPath(featureId, featureVersion), getFeatureDocumentation.1.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        KtorFeatureDocumentation it = (KtorFeatureDocumentation)t;
        boolean bl3 = false;
        KtorFusCollectorsKt.getKTOR_FUS_EVENT_DOCUMENTATION_REQUESTED().log((Object)featureId, (Object)featureVersion);
        return (KtorFeatureDocumentation)t;
    }

    @Override
    public void postGenerateProject(@NotNull SelectedProjectConfiguration projectConfiguration, @NotNull File outputLocation, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)projectConfiguration, (String)"projectConfiguration");
        Intrinsics.checkNotNullParameter((Object)outputLocation, (String)"outputLocation");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        HttpRequests.post((String)(Companion.getKTOR_STARTER_URL() + '/' + GEN_PROJECT_PATH), (String)"application/json").userAgent(USER_AGENT).connectTimeout(CONNECT_TIMEOUT).connect(new HttpRequests.RequestProcessor(this, projectConfiguration, outputLocation, indicator){
            final /* synthetic */ KtorGeneratorWebAPIImpl this$0;
            final /* synthetic */ SelectedProjectConfiguration $projectConfiguration;
            final /* synthetic */ File $outputLocation;
            final /* synthetic */ ProgressIndicator $indicator;

            public final void process(@NotNull HttpRequests.Request request) {
                Path outputFilePath;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                request.write(this.$projectConfiguration.toJson().toString());
                Path outputDirPath = Paths.get(this.$outputLocation.getPath(), new String[0]);
                Path path = outputFilePath = outputDirPath.resolve("project.zip");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputFilePath");
                File outputZipFile = PathKt.createFile((Path)path).toFile();
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)request.saveToFile(outputZipFile, this.$indicator), (String)"request.saveToFile(outputZipFile, indicator)");
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(e){
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            Messages.showErrorDialog((String)this.$e.getMessage(), (String)KtorStarterBundle.INSTANCE.message("ktor.failed.to.generate.project", new Object[0]));
                        }
                        {
                            this.$e = exception;
                        }
                    });
                }
                this.$outputLocation.mkdirs();
                File file = outputZipFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputZipFile");
                KtorGeneratorWebAPIImpl.access$unzipSubfolder(this.this$0, file, this.$outputLocation);
                outputZipFile.delete();
                KtorFusCollectorsKt.getKTOR_FUS_EVENT_PROJECT_GENERATED().log(new EventPair[]{new EventPair((EventField)KtorFusCollectorsKt.getKTOR_FUS_ENGINE_FIELD(), (Object)this.$projectConfiguration.getSettings().getEngine()), new EventPair((EventField)KtorFusCollectorsKt.getKTOR_FUS_BUILDSYSTEM_FIELD(), (Object)this.$projectConfiguration.getSettings().getBuildSystemType()), new EventPair((EventField)KtorFusCollectorsKt.getKTOR_FUS_KTORVERSION_FIELD(), (Object)this.$projectConfiguration.getSettings().getKtorVersion()), new EventPair((EventField)KtorFusCollectorsKt.getKTOR_FUS_FEATURES_FIELD(), this.$projectConfiguration.getFeatureIds())});
            }
            {
                this.this$0 = ktorGeneratorWebAPIImpl;
                this.$projectConfiguration = selectedProjectConfiguration;
                this.$outputLocation = file;
                this.$indicator = progressIndicator;
            }
        });
    }

    private final void unzipSubfolder(File tempZipFile, File contentEntryDir) {
        new Decompressor.Zip(tempZipFile).extract(contentEntryDir);
    }

    static {
        Companion = new Companion(null);
        PROJECT_SETTINGS_PATH = "/project/settings";
        GEN_PROJECT_PATH = "/project/generate";
        StringBuilder stringBuilder = new StringBuilder();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        StringBuilder stringBuilder2 = stringBuilder.append(applicationNamesInfo.getFullProductName()).append("/");
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        USER_AGENT = stringBuilder2.append(applicationInfo.getFullVersion()).toString();
        CONNECT_TIMEOUT = 10000;
        Logger logger = Logger.getInstance(KtorGeneratorWebAPIImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(KtorG\u2026orWebAPIImpl::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$unzipSubfolder(KtorGeneratorWebAPIImpl $this, File tempZipFile, File contentEntryDir) {
        $this.unzipSubfolder(tempZipFile, contentEntryDir);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/initializr/api/KtorGeneratorWebAPIImpl$UnexpectedArchiveStructureException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "intellij.ktor.starter"})
    private static final class UnexpectedArchiveStructureException
    extends Exception {
        public UnexpectedArchiveStructureException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/ktor/initializr/api/KtorGeneratorWebAPIImpl$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "getCONNECT_TIMEOUT", "()I", "GEN_PROJECT_PATH", "", "getGEN_PROJECT_PATH", "()Ljava/lang/String;", "KTOR_STARTER_URL", "Lorg/jetbrains/annotations/NotNull;", "getKTOR_STARTER_URL", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PROJECT_SETTINGS_PATH", "getPROJECT_SETTINGS_PATH", "USER_AGENT", "getUSER_AGENT", "featureDocumentationPath", "featureId", "featureVersion", "featuresListPath", "ktorVersion", "intellij.ktor.starter"})
    public static final class Companion {
        @NotNull
        public final String getKTOR_STARTER_URL() {
            String string = Registry.stringValue((String)"ktor.generator.service.url");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Registry.stringValue(\"ktor.generator.service.url\")");
            return string;
        }

        @NotNull
        public final String getPROJECT_SETTINGS_PATH() {
            return PROJECT_SETTINGS_PATH;
        }

        @NotNull
        public final String getGEN_PROJECT_PATH() {
            return GEN_PROJECT_PATH;
        }

        @NotNull
        public final String featuresListPath(@NotNull String ktorVersion) {
            Intrinsics.checkNotNullParameter((Object)ktorVersion, (String)"ktorVersion");
            return "/features/" + ktorVersion;
        }

        @NotNull
        public final String featureDocumentationPath(@NotNull String featureId, @NotNull String featureVersion) {
            Intrinsics.checkNotNullParameter((Object)featureId, (String)"featureId");
            Intrinsics.checkNotNullParameter((Object)featureVersion, (String)"featureVersion");
            return "/feature/" + featureId + '/' + featureVersion + "/documentation";
        }

        @NotNull
        public final String getUSER_AGENT() {
            return USER_AGENT;
        }

        public final int getCONNECT_TIMEOUT() {
            return CONNECT_TIMEOUT;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

