/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import io.ktor.ide.KtorRoutingVisitor;
import io.ktor.ide.KtorUastSearchUtilsKt;
import io.ktor.ide.KtorUrlMapping;
import io.ktor.ide.KtorUrlResolver;
import io.ktor.ide.KtorUrlTargetInfo;
import io.ktor.initializr.intellij.run.KtorLibraryUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/ktor/ide/KtorUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "modules", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/module/Module;", "getModules", "()Lkotlin/sequences/Sequence;", "getAllUrlMappings", "Lio/ktor/ide/KtorUrlMapping;", "module", "getAuthoritiesByModule", "", "Lcom/intellij/microservices/url/Authority;", "getMatchingUrlMappings", "urlPath", "Lcom/intellij/microservices/url/UrlPath;", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.ktor.starter"})
public final class KtorUrlResolver
extends HttpUrlResolver {
    private final Project project;

    private final Sequence<Module> getModules() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(project).modules");
        return ArraysKt.asSequence((Object[])objectArray);
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap(this.getModules(), (Function1)((Function1)new Function1<Module, Sequence<? extends KtorUrlTargetInfo>>(this, request){
            final /* synthetic */ KtorUrlResolver this$0;
            final /* synthetic */ UrlResolveRequest $request;

            @NotNull
            public final Sequence<KtorUrlTargetInfo> invoke(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(this.$request.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends KtorUrlTargetInfo>>(this, module){
                    final /* synthetic */ resolve.1 this$0;
                    final /* synthetic */ Module $module;

                    @NotNull
                    public final Sequence<KtorUrlTargetInfo> invoke(@NotNull UrlPath path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        Sequence sequence = KtorUrlResolver.access$getMatchingUrlMappings(this.this$0.this$0, this.$module, path);
                        boolean bl = false;
                        return SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<KtorUrlMapping, KtorUrlTargetInfo>(this){
                            final /* synthetic */ resolve.1 this$0;

                            @NotNull
                            public final KtorUrlTargetInfo invoke(@NotNull KtorUrlMapping resolved) {
                                Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
                                return new KtorUrlTargetInfo(resolved, KtorUrlResolver.access$getAuthoritiesByModule(this.this$0.this$0.this$0, this.this$0.$module));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = ktorUrlResolver;
                this.$request = urlResolveRequest;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        Iterable res2 = SequencesKt.asIterable((Sequence)SequencesKt.flatMap(this.getModules(), (Function1)((Function1)new Function1<Module, Sequence<? extends KtorUrlTargetInfo>>(this){
            final /* synthetic */ KtorUrlResolver this$0;

            @NotNull
            public final Sequence<KtorUrlTargetInfo> invoke(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Sequence sequence = KtorUrlResolver.access$getAllUrlMappings(this.this$0, module);
                boolean bl = false;
                return SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<KtorUrlMapping, KtorUrlTargetInfo>(this, module){
                    final /* synthetic */ getVariants.res.1 this$0;
                    final /* synthetic */ Module $module;

                    @NotNull
                    public final KtorUrlTargetInfo invoke(@NotNull KtorUrlMapping urlPath) {
                        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
                        return new KtorUrlTargetInfo(urlPath, KtorUrlResolver.access$getAuthoritiesByModule(this.this$0.this$0, this.$module));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = ktorUrlResolver;
                super(1);
            }
        })));
        return res2;
    }

    private final Sequence<KtorUrlMapping> getMatchingUrlMappings(Module module, UrlPath urlPath) {
        return SequencesKt.filter(this.getAllUrlMappings(module), (Function1)((Function1)new Function1<KtorUrlMapping, Boolean>(urlPath){
            final /* synthetic */ UrlPath $urlPath;

            public final boolean invoke(@NotNull KtorUrlMapping it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getUrlPath().isCompatibleWith(this.$urlPath);
            }
            {
                this.$urlPath = urlPath;
                super(1);
            }
        }));
    }

    private final Sequence<KtorUrlMapping> getAllUrlMappings(Module module) {
        KtorRoutingVisitor visitor = new KtorRoutingVisitor();
        Iterable $this$forEach$iv = KtorUastSearchUtilsKt.searchRoutingCalls(module);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UCallExpression routing = (UCallExpression)element$iv;
            boolean bl = false;
            routing.accept((UastVisitor)visitor);
        }
        $this$forEach$iv = KtorUastSearchUtilsKt.searchRouteExtensions(module);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UMethod extension = (UMethod)element$iv;
            boolean bl = false;
            extension.accept((UastVisitor)visitor);
        }
        return SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)visitor.getUrlMappings()));
    }

    private final List<Authority> getAuthoritiesByModule(Module module) {
        return CollectionsKt.emptyList();
    }

    public KtorUrlResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Sequence access$getMatchingUrlMappings(KtorUrlResolver $this, Module module, UrlPath urlPath) {
        return $this.getMatchingUrlMappings(module, urlPath);
    }

    public static final /* synthetic */ List access$getAuthoritiesByModule(KtorUrlResolver $this, Module module) {
        return $this.getAuthoritiesByModule(module);
    }

    public static final /* synthetic */ Sequence access$getAllUrlMappings(KtorUrlResolver $this, Module module) {
        return $this.getAllUrlMappings(module);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/ktor/ide/KtorUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ktor.starter"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return KtorLibraryUtilKt.hasKtorLibrary(project) ? (UrlResolver)new KtorUrlResolver(project) : null;
        }
    }
}

