/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.IdeScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptAcceptedLocation;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptIdeConfigurationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007JR\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u0004H\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\"\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/util/ProjectRootsUtil;", "", "()V", "isInContent", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeProjectSource", "includeLibrarySource", "includeLibraryClasses", "includeScriptDependencies", "includeScriptsOutsideSourceRoots", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "element", "Lcom/intellij/psi/PsiElement;", "isInContentWithoutScriptDefinitionCheck", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isInProjectOrLibSource", "isInProjectOrLibraryClassFile", "isInProjectOrLibraryContent", "isInProjectSource", "isLibraryClassFile", "isLibraryFile", "isLibrarySourceFile", "isProjectSourceFile", "kotlin.core"})
public final class ProjectRootsUtil {
    @NotNull
    public static final ProjectRootsUtil INSTANCE;

    @JvmStatic
    public static final boolean isInContent(@NotNull Project project, @NotNull VirtualFile file, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, boolean includeScriptsOutsideSourceRoots, @NotNull ProjectFileIndex fileIndex) {
        List scriptScope;
        boolean kotlinExcludeLibrarySources;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileIndex, (String)"fileIndex");
        ProgressManager.checkCanceled();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getNameSequence());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"FileTypeManager.getInsta\u2026leName(file.nameSequence)");
        FileType fileType2 = fileType;
        boolean bl = kotlinExcludeLibrarySources = Intrinsics.areEqual((Object)fileType2, (Object)KotlinFileType.INSTANCE) && !includeLibrarySource && !includeScriptsOutsideSourceRoots;
        if (kotlinExcludeLibrarySources && !includeProjectSource) {
            return false;
        }
        if (ProjectRootsUtilKt.isInSourceContentWithoutInjected((FileIndex)fileIndex, file)) {
            return includeProjectSource;
        }
        if (kotlinExcludeLibrarySources) {
            return false;
        }
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition((VirtualFile)file, (Project)project);
        ScriptDefinition scriptDefinition2 = scriptDefinition;
        List list = scriptDefinition2 != null && (scriptDefinition2 = scriptDefinition2.getCompilationConfiguration()) != null ? (List)scriptDefinition2.get(ScriptIdeConfigurationKt.getAcceptedLocations((IdeScriptCompilationConfigurationKeys)((IdeScriptCompilationConfigurationKeys)ScriptIdeConfigurationKt.getIde((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))))) : (scriptScope = null);
        if (scriptScope != null) {
            boolean includeAll = scriptScope.contains(ScriptAcceptedLocation.Everywhere) || scriptScope.contains(ScriptAcceptedLocation.Project) || ScratchUtil.isScratch((VirtualFile)file);
            boolean includeAllOrScriptLibraries = includeAll || scriptScope.contains(ScriptAcceptedLocation.Libraries);
            return INSTANCE.isInContentWithoutScriptDefinitionCheck(project, file, fileType2, includeProjectSource && (includeAll || scriptScope.contains(ScriptAcceptedLocation.Sources) || scriptScope.contains(ScriptAcceptedLocation.Tests)), includeLibrarySource && includeAllOrScriptLibraries, includeLibraryClasses && includeAllOrScriptLibraries, includeScriptDependencies && includeAllOrScriptLibraries, includeScriptsOutsideSourceRoots && includeAll, fileIndex);
        }
        return INSTANCE.isInContentWithoutScriptDefinitionCheck(project, file, fileType2, includeProjectSource, includeLibrarySource, includeLibraryClasses, includeScriptDependencies, false, fileIndex);
    }

    public static /* synthetic */ boolean isInContent$default(Project project, VirtualFile virtualFile, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ProjectFileIndex projectFileIndex, int n, Object object) {
        if ((n & 0x80) != 0) {
            ProjectFileIndex projectFileIndex2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex2, (String)"ProjectFileIndex.SERVICE.getInstance(project)");
            projectFileIndex = projectFileIndex2;
        }
        return ProjectRootsUtil.isInContent(project, virtualFile, bl, bl2, bl3, bl4, bl5, projectFileIndex);
    }

    private final boolean isInContentWithoutScriptDefinitionCheck(Project project, VirtualFile file, FileType fileType, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, boolean includeScriptsOutsideSourceRoots, ProjectFileIndex fileIndex) {
        ScriptConfigurationManager scriptConfigurationManager;
        if (includeScriptsOutsideSourceRoots) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            if (projectRootManager.getFileIndex().isInContent(file) || ScratchUtil.isScratch((VirtualFile)file)) {
                return true;
            }
            Object object = DefinitionsKt.findScriptDefinition((VirtualFile)file, (Project)project);
            return object != null && (object = object.getCompilationConfiguration()) != null && (object = (List)object.get(ScriptIdeConfigurationKt.getAcceptedLocations((IdeScriptCompilationConfigurationKeys)((IdeScriptCompilationConfigurationKeys)ScriptIdeConfigurationKt.getIde((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))))) != null && object.contains(ScriptAcceptedLocation.Everywhere);
        }
        if (!includeLibraryClasses && !includeLibrarySource) {
            return false;
        }
        boolean canContainClassFiles = Intrinsics.areEqual((Object)fileType, (Object)ArchiveFileType.INSTANCE) || file.isDirectory();
        boolean isBinary = ProjectRootsUtilKt.isKotlinBinary(fileType);
        ScriptConfigurationManager scriptConfigurationManager2 = scriptConfigurationManager = includeScriptDependencies ? ScriptConfigurationManager.Companion.getInstance(project) : null;
        if (includeLibraryClasses && (isBinary || canContainClassFiles)) {
            if (fileIndex.isInLibraryClasses(file)) {
                return true;
            }
            ScriptConfigurationManager scriptConfigurationManager3 = scriptConfigurationManager;
            if (scriptConfigurationManager3 != null && (scriptConfigurationManager3 = scriptConfigurationManager3.getAllScriptsDependenciesClassFilesScope()) != null) {
                if (scriptConfigurationManager3.contains(file)) {
                    return true;
                }
            }
        }
        if (includeLibrarySource && !isBinary) {
            if (fileIndex.isInLibrarySource(file)) {
                return true;
            }
            ScriptConfigurationManager scriptConfigurationManager4 = scriptConfigurationManager;
            if (scriptConfigurationManager4 != null && (scriptConfigurationManager4 = scriptConfigurationManager4.getAllScriptDependenciesSourcesScope()) != null) {
                if (scriptConfigurationManager4.contains(file)) {
                    if (!ProjectRootsUtilKt.isInSourceContentWithoutInjected((FileIndex)fileIndex, file)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static /* synthetic */ boolean isInContentWithoutScriptDefinitionCheck$default(ProjectRootsUtil projectRootsUtil, Project project, VirtualFile virtualFile, FileType fileType, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ProjectFileIndex projectFileIndex, int n, Object object) {
        if ((n & 0x100) != 0) {
            ProjectFileIndex projectFileIndex2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex2, (String)"ProjectFileIndex.SERVICE.getInstance(project)");
            projectFileIndex = projectFileIndex2;
        }
        return projectRootsUtil.isInContentWithoutScriptDefinitionCheck(project, virtualFile, fileType, bl, bl2, bl3, bl4, bl5, projectFileIndex);
    }

    @JvmStatic
    public static final boolean isInContent(@NotNull PsiElement element2, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(element2, includeProjectSource, includeLibrarySource, includeLibraryClasses, includeScriptDependencies, includeScriptsOutsideSourceRoots){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ boolean $includeProjectSource;
            final /* synthetic */ boolean $includeLibrarySource;
            final /* synthetic */ boolean $includeLibraryClasses;
            final /* synthetic */ boolean $includeScriptDependencies;
            final /* synthetic */ boolean $includeScriptsOutsideSourceRoots;

            public final boolean invoke() {
                Object object;
                PsiElement psiElement = this.$element;
                if (psiElement instanceof PsiDirectory) {
                    object = ((PsiDirectory)this.$element).getVirtualFile();
                } else {
                    PsiFile psiFile = this.$element.getContainingFile();
                    object = psiFile != null ? psiFile.getVirtualFile() : null;
                }
                if (object == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (element) {\n       \u2026eturn@runReadAction false");
                VirtualFile virtualFile = object;
                Project project = this.$element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                Project project2 = project;
                return ProjectRootsUtil.isInContent$default(project2, virtualFile, this.$includeProjectSource, this.$includeLibrarySource, this.$includeLibraryClasses, this.$includeScriptDependencies, this.$includeScriptsOutsideSourceRoots, null, 128, null);
            }
            {
                this.$element = psiElement;
                this.$includeProjectSource = bl;
                this.$includeLibrarySource = bl2;
                this.$includeLibraryClasses = bl3;
                this.$includeScriptDependencies = bl4;
                this.$includeScriptsOutsideSourceRoots = bl5;
                super(0);
            }
        }));
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectSource(@NotNull PsiElement element2, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return ProjectRootsUtil.isInContent(element2, true, false, false, false, includeScriptsOutsideSourceRoots);
    }

    public static /* synthetic */ boolean isInProjectSource$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ProjectRootsUtil.isInProjectSource(psiElement, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectSource(@NotNull PsiElement element2) {
        return ProjectRootsUtil.isInProjectSource$default(element2, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isProjectSourceFile(@NotNull Project project, @NotNull VirtualFile file, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file, true, false, false, false, includeScriptsOutsideSourceRoots, null, 128, null);
    }

    public static /* synthetic */ boolean isProjectSourceFile$default(Project project, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return ProjectRootsUtil.isProjectSourceFile(project, virtualFile, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isProjectSourceFile(@NotNull Project project, @NotNull VirtualFile file) {
        return ProjectRootsUtil.isProjectSourceFile$default(project, file, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectOrLibSource(@NotNull PsiElement element2, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return ProjectRootsUtil.isInContent(element2, true, true, false, false, includeScriptsOutsideSourceRoots);
    }

    public static /* synthetic */ boolean isInProjectOrLibSource$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ProjectRootsUtil.isInProjectOrLibSource(psiElement, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectOrLibSource(@NotNull PsiElement element2) {
        return ProjectRootsUtil.isInProjectOrLibSource$default(element2, false, 2, null);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibraryContent(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return ProjectRootsUtil.isInContent(element2, true, true, true, true, false);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibraryClassFile(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return ProjectRootsUtil.isInContent(element2, true, false, true, false, false);
    }

    @JvmStatic
    public static final boolean isLibraryClassFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file, false, false, true, true, false, null, 128, null);
    }

    @JvmStatic
    public static final boolean isLibrarySourceFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file, false, true, false, true, false, null, 128, null);
    }

    @JvmStatic
    public static final boolean isLibraryFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file, false, true, true, true, false, null, 128, null);
    }

    private ProjectRootsUtil() {
    }

    static {
        ProjectRootsUtil projectRootsUtil;
        INSTANCE = projectRootsUtil = new ProjectRootsUtil();
    }
}

