/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProviderKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

public class TargetPlatformDetector {
    public static final TargetPlatformDetector INSTANCE = new TargetPlatformDetector();
    private static final Logger LOG = Logger.getInstance(TargetPlatformDetector.class);

    private TargetPlatformDetector() {
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull KtFile file) {
        Module moduleForFile;
        KtFile contextFile;
        TargetPlatform explicitPlatform;
        if (file == null) {
            TargetPlatformDetector.$$$reportNull$$$0(0);
        }
        if ((explicitPlatform = PlatformKt.getForcedTargetPlatform(file)) != null) {
            TargetPlatform targetPlatform = explicitPlatform;
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(1);
            }
            return targetPlatform;
        }
        if (file instanceof KtCodeFragment && (contextFile = ((KtCodeFragment)file).getContextContainingFile()) != null) {
            return TargetPlatformDetector.getPlatform(contextFile);
        }
        PsiElement context = KtPsiFactoryKt.getAnalysisContext((KtFile)file);
        if (context != null) {
            PsiFile contextFile2 = context.getContainingFile();
            TargetPlatform targetPlatform = contextFile2 instanceof KtFile ? TargetPlatformDetector.getPlatform((KtFile)contextFile2) : JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(2);
            }
            return targetPlatform;
        }
        ScriptDefinition scriptDefinition = (ScriptDefinition)ReadAction.compute(() -> file.isScript() ? DefinitionsKt.findScriptDefinition((PsiFile)file) : null);
        if (scriptDefinition != null) {
            return TargetPlatformDetector.getPlatform4Script(file.getProject(), file.getOriginalFile().getVirtualFile(), scriptDefinition);
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile != null && (moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)file.getProject()).getModuleForFile(virtualFile)) != null) {
            return TargetPlatformDetector.getPlatform(moduleForFile);
        }
        TargetPlatform targetPlatform = DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(3);
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Module module) {
        if (module == null) {
            TargetPlatformDetector.$$$reportNull$$$0(4);
        }
        TargetPlatform targetPlatform = ProjectStructureUtil.getCachedPlatformForModule(module);
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(5);
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getPlatform4Script(@NotNull Project project, @NotNull VirtualFile file, @NotNull ScriptDefinition scriptDefinition) {
        if (project == null) {
            TargetPlatformDetector.$$$reportNull$$$0(6);
        }
        if (file == null) {
            TargetPlatformDetector.$$$reportNull$$$0(7);
        }
        if (scriptDefinition == null) {
            TargetPlatformDetector.$$$reportNull$$$0(8);
        }
        TargetPlatformVersion targetPlatformVersion = IDELanguageSettingsProviderKt.getTargetPlatformVersionForScript(project, file, scriptDefinition);
        return TargetPlatformDetector.getPlatform4ScriptImpl(targetPlatformVersion, scriptDefinition);
    }

    @NotNull
    private static TargetPlatform getPlatform4ScriptImpl(TargetPlatformVersion targetPlatformVersion, @NotNull ScriptDefinition scriptDefinition) {
        if (scriptDefinition == null) {
            TargetPlatformDetector.$$$reportNull$$$0(9);
        }
        if (!targetPlatformVersion.equals(TargetPlatformVersion.NoVersion.INSTANCE)) {
            for (TargetPlatform compilerPlatform : CommonPlatforms.INSTANCE.getAllSimplePlatforms()) {
                SimplePlatform simplePlatform = (SimplePlatform)CollectionsKt.single((Iterable)compilerPlatform);
                if (simplePlatform.getTargetPlatformVersion() != targetPlatformVersion) continue;
                TargetPlatform targetPlatform = compilerPlatform;
                if (targetPlatform == null) {
                    TargetPlatformDetector.$$$reportNull$$$0(10);
                }
                return targetPlatform;
            }
        }
        String platformNameFromScriptDefinition = scriptDefinition.getPlatform();
        for (TargetPlatform compilerPlatform : CommonPlatforms.INSTANCE.getAllSimplePlatforms()) {
            SimplePlatform simplePlatform = (SimplePlatform)CollectionsKt.single((Iterable)compilerPlatform);
            if (!simplePlatform.getPlatformName().equals(platformNameFromScriptDefinition)) continue;
            TargetPlatform targetPlatform = compilerPlatform;
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(11);
            }
            return targetPlatform;
        }
        TargetPlatform targetPlatform = DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(12);
        }
        return targetPlatform;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform4ScriptImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform4Script";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform4ScriptImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

