/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.klib;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.testFramework.LightVirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataModuleDescriptorFactory;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.klib.CachingIdeKlibMetadataLoader;
import org.jetbrains.kotlin.idea.klib.KlibCompatibilityInfoKt;
import org.jetbrains.kotlin.idea.klib.UtilsKt$WhenMappings;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.metadata.PackageAccessHandler;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a4\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d\u001a6\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f*\u00020\u00102\u0006\u0010 \u001a\u0002H\u001f2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u001f0\"\u00a2\u0006\u0002\b#\u00a2\u0006\u0002\u0010$\u001a\f\u0010%\u001a\u00020\u0007*\u00020\u001dH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006&"}, d2={"isLegacyNativeKlibComponent", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "checkKlibComponent", "componentFile", "requestedBuiltInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "createFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "createKlibPackageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "metadataModuleDescriptorFactory", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataModuleDescriptorFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "isKlibLibraryRootForPlatform", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "safeRead", "T", "defaultValue", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toBuiltInsPlatform", "kotlin.core"})
public final class UtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKlibLibraryRootForPlatform(@NotNull VirtualFile $this$isKlibLibraryRootForPlatform, @NotNull TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter((Object)$this$isKlibLibraryRootForPlatform, (String)"$this$isKlibLibraryRootForPlatform");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        if (Intrinsics.areEqual((Object)$this$isKlibLibraryRootForPlatform.getFileType(), (Object)ArchiveFileType.INSTANCE)) {
            if (Intrinsics.areEqual((Object)$this$isKlibLibraryRootForPlatform.getExtension(), (Object)"klib") ^ true) return false;
        }
        if (!$this$isKlibLibraryRootForPlatform.isDirectory()) {
            return false;
        }
        BuiltInsPlatform requestedBuiltInsPlatform = UtilsKt.toBuiltInsPlatform(targetPlatform);
        if (requestedBuiltInsPlatform == BuiltInsPlatform.NATIVE && UtilsKt.checkKlibComponent($this$isKlibLibraryRootForPlatform, requestedBuiltInsPlatform)) {
            return true;
        }
        VirtualFile[] virtualFileArray = $this$isKlibLibraryRootForPlatform.getChildren();
        if (virtualFileArray == null) return false;
        VirtualFile[] $this$any$iv = virtualFileArray;
        boolean $i$f$any = false;
        VirtualFile[] virtualFileArray2 = $this$any$iv;
        int n = virtualFileArray2.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualFile element$iv;
            VirtualFile it = element$iv = virtualFileArray2[n2];
            boolean bl = false;
            VirtualFile virtualFile = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
            if (UtilsKt.checkKlibComponent(virtualFile, requestedBuiltInsPlatform)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkKlibComponent(VirtualFile componentFile, BuiltInsPlatform requestedBuiltInsPlatform) {
        Object object;
        boolean bl;
        Object object2;
        block20: {
            block19: {
                object2 = componentFile.findChild("manifest");
                if (object2 == null) break block19;
                VirtualFile virtualFile = object2;
                boolean bl2 = false;
                bl = false;
                VirtualFile it = virtualFile;
                boolean bl3 = false;
                VirtualFile virtualFile2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                object2 = !virtualFile2.isDirectory() ? virtualFile : null;
                if (object2 != null) break block20;
            }
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"componentFile.findChild(\u2026rectory } ?: return false");
        VirtualFile manifestFile = object2;
        try {
            Properties properties;
            object = manifestFile.getInputStream();
            bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl5 = false;
                Properties properties2 = new Properties();
                boolean bl6 = false;
                boolean bl7 = false;
                Properties $this$apply = properties2;
                boolean bl8 = false;
                $this$apply.load(it);
                properties = properties2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = properties;
        }
        catch (IOException _) {
            return false;
        }
        Object manifestProperties = object;
        if (!((Properties)manifestProperties).containsKey("unique_name")) {
            return false;
        }
        String string = ((Properties)manifestProperties).getProperty("builtins_platform");
        if (string == null) {
            boolean bl9;
            switch (UtilsKt$WhenMappings.$EnumSwitchMapping$0[requestedBuiltInsPlatform.ordinal()]) {
                case 1: {
                    bl9 = UtilsKt.isLegacyNativeKlibComponent(componentFile);
                    break;
                }
                case 2: {
                    if (!UtilsKt.isLegacyNativeKlibComponent(componentFile)) {
                        bl9 = true;
                        break;
                    }
                    bl9 = false;
                    break;
                }
                default: {
                    bl9 = false;
                }
            }
            return bl9;
        }
        String builtInsPlatformProperty = string;
        BuiltInsPlatform builtInsPlatform = BuiltInsPlatform.Companion.parseFromString(builtInsPlatformProperty);
        if (builtInsPlatform == null) {
            return false;
        }
        BuiltInsPlatform builtInsPlatform2 = builtInsPlatform;
        return builtInsPlatform2 == requestedBuiltInsPlatform;
    }

    private static final BuiltInsPlatform toBuiltInsPlatform(TargetPlatform $this$toBuiltInsPlatform) {
        BuiltInsPlatform builtInsPlatform;
        if (TargetPlatformKt.isCommon((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.COMMON;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.NATIVE;
        } else if (JvmPlatformKt.isJvm((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JVM;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JS;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown platform " + $this$toBuiltInsPlatform);
        }
        return builtInsPlatform;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isLegacyNativeKlibComponent(VirtualFile $this$isLegacyNativeKlibComponent) {
        VirtualFile irFolder = $this$isLegacyNativeKlibComponent.findChild("ir");
        if (irFolder == null) return false;
        VirtualFile[] virtualFileArray = irFolder.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"irFolder.children");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        boolean bl = false;
        VirtualFile[] virtualFileArray3 = virtualFileArray2;
        boolean bl2 = false;
        if (virtualFileArray3.length != 0) return true;
        return false;
    }

    public static final <T> T safeRead(@NotNull KotlinLibrary $this$safeRead, T defaultValue, @NotNull Function1<? super KotlinLibrary, ? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$safeRead, (String)"$this$safeRead");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        try {
            object = action2.invoke((Object)$this$safeRead);
        }
        catch (IOException _) {
            object = defaultValue;
        }
        return object;
    }

    @NotNull
    public static final PsiFileStub<?> createFileStub(@NotNull Project project, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        LightVirtualFile virtualFile = new LightVirtualFile("dummy.kt", (FileType)KotlinFileType.INSTANCE, (CharSequence)text2);
        virtualFile.setLanguage((Language)KotlinLanguage.INSTANCE);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)((VirtualFile)virtualFile));
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        if (psiFileFactory == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        PsiFileFactoryImpl psiFileFactory2 = (PsiFileFactoryImpl)psiFileFactory;
        PsiFile psiFile = psiFileFactory2.trySetupPsiForFile(virtualFile, (Language)KotlinLanguage.INSTANCE, false, false);
        Intrinsics.checkNotNull((Object)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiFileFactory.trySetupP\u2026INSTANCE, false, false)!!");
        PsiFile file = psiFile;
        KtFileElementType ktFileElementType = KtStubElementTypes.FILE;
        Intrinsics.checkNotNullExpressionValue((Object)ktFileElementType, (String)"KtStubElementTypes.FILE");
        StubElement stubElement = ktFileElementType.getBuilder().buildStubTree(file);
        if (stubElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.stubs.PsiFileStub<*>");
        }
        return (PsiFileStub)stubElement;
    }

    @Nullable
    public static final PackageFragmentProvider createKlibPackageFragmentProvider(@NotNull KotlinLibrary $this$createKlibPackageFragmentProvider, @NotNull StorageManager storageManager, @NotNull KlibMetadataModuleDescriptorFactory metadataModuleDescriptorFactory, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ModuleDescriptor moduleDescriptor, @NotNull LookupTracker lookupTracker) {
        Intrinsics.checkNotNullParameter((Object)$this$createKlibPackageFragmentProvider, (String)"$this$createKlibPackageFragmentProvider");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)metadataModuleDescriptorFactory, (String)"metadataModuleDescriptorFactory");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        if (!KlibCompatibilityInfoKt.getCompatibilityInfo($this$createKlibPackageFragmentProvider).isCompatible()) {
            return null;
        }
        ProtocolStringList packageFragmentNames = CachingIdeKlibMetadataLoader.INSTANCE.loadModuleHeader($this$createKlibPackageFragmentProvider).getPackageFragmentNameList();
        PackageAccessHandler packageAccessHandler = CachingIdeKlibMetadataLoader.INSTANCE;
        ProtocolStringList protocolStringList = packageFragmentNames;
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"packageFragmentNames");
        return metadataModuleDescriptorFactory.createPackageFragmentProvider($this$createKlibPackageFragmentProvider, packageAccessHandler, (List)protocolStringList, storageManager, moduleDescriptor, (DeserializationConfiguration)new CompilerDeserializationConfiguration(languageVersionSettings), null, lookupTracker);
    }
}

