/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.java;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.java.UnimplementedKotlinInterfaceMemberAnnotator;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "isBinaryOrigin", "", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)Z", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "findUnimplementedMethod", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "registerFixes", "errorAnnotation", "Lcom/intellij/lang/annotation/Annotation;", "report", "method", "kotlin.core"})
public final class UnimplementedKotlinInterfaceMemberAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (!(element2 instanceof PsiClass) || Intrinsics.areEqual((Object)((PsiClass)element2).getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
                return;
            }
            if (((PsiClass)element2).isInterface() || ((PsiClass)element2).hasModifierProperty("abstract")) {
                return;
            }
            JvmDefaultMode jvmDefaultMode = (JvmDefaultMode)PlatformKt.getLanguageVersionSettings(element2).getFlag(JvmAnalysisFlags.getJvmDefaultMode());
            if (jvmDefaultMode == JvmDefaultMode.ALL_COMPATIBILITY || jvmDefaultMode == JvmDefaultMode.ALL_INCOMPATIBLE) {
                return;
            }
            if (ClassUtil.getAnyMethodToImplement((PsiClass)((PsiClass)element2)) != null) {
                return;
            }
            KtLightMethod ktLightMethod = this.findUnimplementedMethod((PsiClass)element2);
            if (ktLightMethod == null) break block4;
            KtLightMethod ktLightMethod2 = ktLightMethod;
            boolean bl = false;
            boolean bl2 = false;
            KtLightMethod it = ktLightMethod2;
            boolean bl3 = false;
            this.report(it, holder, (PsiClass)element2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final KtLightMethod findUnimplementedMethod(PsiClass psiClass) {
        Object v8;
        block9: {
            Object element$iv;
            boolean bl;
            PsiClass kotlinSuperClass2;
            Object object;
            Object v2;
            List signaturesFromKotlinInterfaces;
            block8: {
                void $this$filterTo$iv$iv;
                Collection collection = psiClass.getVisibleSignatures();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"psiClass.visibleSignatures");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiMethod method;
                    HierarchicalMethodSignature signature = (HierarchicalMethodSignature)element$iv$iv;
                    boolean bl2 = false;
                    HierarchicalMethodSignature hierarchicalMethodSignature = signature;
                    Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature, (String)"signature");
                    Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature.getMethod(), (String)"signature.method");
                    if (!(method instanceof KtLightMethod && method.hasModifierProperty("default") && !method.hasModifierProperty("static"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection $this$ifEmpty$iv = (List)destination$iv$iv;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.isEmpty()) {
                    return null;
                }
                signaturesFromKotlinInterfaces = (List)$this$ifEmpty$iv;
                Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)psiClass, (Function1)findUnimplementedMethod.kotlinSuperClass.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    PsiClass it = (PsiClass)element$iv2;
                    boolean bl3 = false;
                    if (!(it instanceof KtLightClassForSourceDeclaration)) continue;
                    v2 = element$iv2;
                    break block8;
                }
                v2 = null;
            }
            if ((object = (kotlinSuperClass2 = (PsiClass)v2)) == null || (object = object.getVisibleSignatures()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object signaturesVisibleThroughKotlinSuperClass = object;
            Iterable $this$firstOrNull$iv = signaturesFromKotlinInterfaces;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            do {
                block12: {
                    boolean bl4;
                    block10: {
                        int n;
                        PsiAnnotation[] psiAnnotationArray;
                        block13: {
                            block11: {
                                PsiAnnotation[] $this$none$iv;
                                if (!iterator.hasNext()) break block11;
                                element$iv = iterator.next();
                                HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv;
                                boolean bl5 = false;
                                if (signaturesVisibleThroughKotlinSuperClass.contains(it)) break block12;
                                HierarchicalMethodSignature hierarchicalMethodSignature = it;
                                Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature, (String)"it");
                                PsiMethod psiMethod = hierarchicalMethodSignature.getMethod();
                                Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"it.method");
                                if (this.isBinaryOrigin(psiMethod)) break block12;
                                PsiMethod psiMethod2 = it.getMethod();
                                Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"it.method");
                                PsiModifierList psiModifierList = psiMethod2.getModifierList();
                                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"it.method.modifierList");
                                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList.getAnnotations(), (String)"it.method.modifierList.annotations");
                                boolean $i$f$none = false;
                                psiAnnotationArray = $this$none$iv;
                                n = psiAnnotationArray.length;
                                break block13;
                            }
                            v8 = null;
                            break block9;
                        }
                        for (int j = 0; j < n; ++j) {
                            PsiAnnotation element$iv3;
                            PsiAnnotation annotation = element$iv3 = psiAnnotationArray[j];
                            boolean bl6 = false;
                            PsiAnnotation psiAnnotation = annotation;
                            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"annotation");
                            String qualifiedName = psiAnnotation.getQualifiedName();
                            if (!(Intrinsics.areEqual((Object)qualifiedName, (Object)JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME().asString()) || Intrinsics.areEqual((Object)qualifiedName, (Object)AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME().asString()))) continue;
                            bl4 = false;
                            break block10;
                        }
                        bl4 = true;
                    }
                    if (bl4) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v8 = element$iv;
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = v8;
        Object object = hierarchicalMethodSignature != null ? hierarchicalMethodSignature.getMethod() : null;
        if (!(object instanceof KtLightMethod)) {
            object = null;
        }
        return (KtLightMethod)object;
    }

    private final boolean isBinaryOrigin(PsiMethod $this$isBinaryOrigin) {
        PsiClass psiClass = $this$isBinaryOrigin.getContainingClass();
        if (!(psiClass instanceof KtLightClassMarker)) {
            psiClass = null;
        }
        KtLightClassMarker ktLightClassMarker = (KtLightClassMarker)psiClass;
        return (ktLightClassMarker != null ? ktLightClassMarker.getOriginKind() : null) == LightClassOriginKind.BINARY;
    }

    private final void report(KtLightMethod method, AnnotationHolder holder, PsiClass psiClass) {
        Annotation errorAnnotation;
        String key = psiClass instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract";
        String string = JavaErrorBundle.message((String)key, (Object[])new Object[]{HighlightUtil.formatClass((PsiClass)psiClass, (boolean)false), JavaHighlightUtil.formatMethod((PsiMethod)((PsiMethod)method)), HighlightUtil.formatClass((PsiClass)method.getContainingClass(), (boolean)false)});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaErrorBundle.message(\u2026ngClass, false)\n        )");
        String message = string;
        Annotation annotation = errorAnnotation = holder.createErrorAnnotation(HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)psiClass), message);
        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"errorAnnotation");
        this.registerFixes(annotation, psiClass);
    }

    private final void registerFixes(Annotation errorAnnotation, PsiClass psiClass) {
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        errorAnnotation.registerFix((IntentionAction)quickFixFactory.createImplementMethodsFix(psiClass));
        if (!(psiClass instanceof PsiAnonymousClass)) {
            PsiModifierList psiModifierList = psiClass.getModifierList();
            if (psiModifierList == null || !psiModifierList.hasExplicitModifier("final")) {
                errorAnnotation.registerFix((IntentionAction)quickFixFactory.createModifierListFix((PsiModifierListOwner)psiClass, "abstract", true, false));
            }
        }
    }
}

