/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceAccess;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/OperatorToFunctionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "kotlin.core"})
public final class OperatorToFunctionIntention
extends SelfTargetingIntention<KtExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtExpression element2, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtExpression ktExpression = element2;
        return ktExpression instanceof KtUnaryExpression ? OperatorToFunctionIntention.Companion.isApplicableUnary((KtUnaryExpression)element2, caretOffset) : (ktExpression instanceof KtBinaryExpression ? OperatorToFunctionIntention.Companion.isApplicableBinary((KtBinaryExpression)element2, caretOffset) : (ktExpression instanceof KtArrayAccessExpression ? OperatorToFunctionIntention.Companion.isApplicableArrayAccess((KtArrayAccessExpression)element2, caretOffset) : (ktExpression instanceof KtCallExpression ? OperatorToFunctionIntention.Companion.isApplicableCall((KtCallExpression)element2, caretOffset) : false)));
    }

    @Override
    public void applyTo(@NotNull KtExpression element2, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Companion.convert(element2);
    }

    public OperatorToFunctionIntention() {
        super(KtExpression.class, KotlinIdeaAnalysisBundle.lazyMessage("replace.overloaded.operator.with.function.call", new Object[0]), null, 4, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/OperatorToFunctionIntention$Companion;", "", "()V", "convert", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "element", "convertArrayAccess", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "convertBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "convertCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "convertUnary", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "convertUnaryWithAssignFix", "findCallName", "result", "isApplicableArrayAccess", "", "caretOffset", "", "isApplicableBinary", "isApplicableCall", "isApplicableUnary", "isAssignmentLeftSide", "isUsedAsExpression", "parentIsUsedAsExpression", "Lcom/intellij/psi/PsiElement;", "replaceExplicitInvokeCallWithImplicit", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "kotlin.core"})
    public static final class Companion {
        @Nullable
        public final KtExpression replaceExplicitInvokeCallWithImplicit(@NotNull KtDotQualifiedExpression qualifiedExpression) {
            KtExpression ktExpression;
            boolean $i$f$replaced;
            PsiElement $this$replaced$iv;
            KtExpression selectorInReceiver;
            KtExpression receiverExpression;
            KtCallExpression ktCallExpression;
            Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
            KtExpression $this$safeAs$iv = qualifiedExpression.getSelectorExpression();
            boolean $i$f$safeAs = false;
            KtExpression ktExpression2 = $this$safeAs$iv;
            if (!(ktExpression2 instanceof KtCallExpression)) {
                ktExpression2 = null;
            }
            if ((ktCallExpression = (KtCallExpression)ktExpression2) == null || (ktCallExpression = (KtCallExpression)FrontendIndependentPsiUtilsKt.copied((PsiElement)((PsiElement)ktCallExpression))) == null) {
                return null;
            }
            KtCallExpression callExpression = ktCallExpression;
            KtExpression ktExpression3 = callExpression.getCalleeExpression();
            if (ktExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
            }
            KtNameReferenceExpression calleExpression = (KtNameReferenceExpression)ktExpression3;
            KtExpression $this$safeAs$iv2 = receiverExpression = qualifiedExpression.getReceiverExpression();
            boolean $i$f$safeAs2 = false;
            KtExpression ktExpression4 = $this$safeAs$iv2;
            if (!(ktExpression4 instanceof KtDotQualifiedExpression)) {
                ktExpression4 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression4;
            Object object = selectorInReceiver = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
            if (selectorInReceiver instanceof KtNameReferenceExpression) {
                PsiElement psiElement;
                calleExpression.rawReplace(FrontendIndependentPsiUtilsKt.copied((PsiElement)((PsiElement)selectorInReceiver)));
                ((KtNameReferenceExpression)selectorInReceiver).rawReplace((PsiElement)callExpression);
                $this$replaced$iv = (PsiElement)qualifiedExpression;
                $i$f$replaced = false;
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)receiverExpression);
                PsiElement psiElement2 = result$iv;
                if (!(psiElement2 instanceof KtExpression)) {
                    psiElement2 = null;
                }
                if ((psiElement = (PsiElement)((KtExpression)psiElement2)) == null) {
                    PsiElement psiElement3 = result$iv;
                    if (psiElement3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression5 = ((KtParenthesizedExpression)psiElement3).getExpression();
                    if (ktExpression5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression5;
                }
                ktExpression = (KtExpression)psiElement;
            } else {
                PsiElement psiElement;
                if ((receiverExpression instanceof KtCallExpression || receiverExpression instanceof KtDotQualifiedExpression) && callExpression.getValueArgumentList() == null && callExpression.getTypeArgumentList() == null) {
                    calleExpression.replace((PsiElement)receiverExpression);
                } else {
                    calleExpression.rawReplace((PsiElement)receiverExpression);
                }
                $this$replaced$iv = (PsiElement)qualifiedExpression;
                $i$f$replaced = false;
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)callExpression);
                PsiElement psiElement4 = result$iv;
                if (!(psiElement4 instanceof KtCallExpression)) {
                    psiElement4 = null;
                }
                if ((psiElement = (PsiElement)((KtCallExpression)psiElement4)) == null) {
                    PsiElement psiElement5 = result$iv;
                    if (psiElement5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression6 = ((KtParenthesizedExpression)psiElement5).getExpression();
                    if (ktExpression6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                    }
                    psiElement = (PsiElement)((KtCallExpression)ktExpression6);
                }
                ktExpression = (KtExpression)psiElement;
            }
            return ktExpression;
        }

        private final boolean isApplicableUnary(KtUnaryExpression element2, int caretOffset) {
            if (element2.getBaseExpression() == null) {
                return false;
            }
            KtSimpleNameExpression ktSimpleNameExpression = element2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
            KtSimpleNameExpression opRef = ktSimpleNameExpression;
            if (!opRef.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            IElementType iElementType = opRef.getReferencedNameElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCL) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS) ? !this.isUsedAsExpression((KtExpression)element2) : false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsedAsExpression(KtExpression element2) {
            PsiElement parent = element2.getParent();
            if (parent instanceof KtBlockExpression) {
                if (!Intrinsics.areEqual((Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)parent)), (Object)element2)) return false;
                PsiElement psiElement = ((KtBlockExpression)parent).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent.parent");
                if (!this.parentIsUsedAsExpression(psiElement)) return false;
                return true;
            }
            PsiElement psiElement = parent;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent");
            boolean bl = this.parentIsUsedAsExpression(psiElement);
            return bl;
        }

        private final boolean parentIsUsedAsExpression(PsiElement element2) {
            PsiElement parent = element2.getParent();
            return parent instanceof KtLoopExpression || parent instanceof KtFile ? false : (parent instanceof KtIfExpression || parent instanceof KtWhenExpression ? BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)parent), (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)parent), (BodyResolveMode)BodyResolveMode.PARTIAL_WITH_CFA)) : true);
        }

        private final boolean isApplicableBinary(KtBinaryExpression element2, int caretOffset) {
            boolean bl;
            block9: {
                if (element2.getLeft() == null || element2.getRight() == null) {
                    return false;
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = element2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                KtOperationReferenceExpression opRef = ktOperationReferenceExpression;
                if (!opRef.getTextRange().containsOffset(caretOffset)) {
                    return false;
                }
                IElementType iElementType = opRef.getReferencedNameElementType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERC) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
                    bl = true;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                    Iterable $this$none$iv = CollectionsKt.listOf((Object[])new KtExpression[]{element2.getLeft(), element2.getRight()});
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtExpression it = (KtExpression)element$iv;
                            boolean bl2 = false;
                            KtExpression ktExpression = it;
                            if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ktExpression.getNode()) != null ? ktExpression.getElementType() : null), (Object)KtNodeTypes.NULL)) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                } else {
                    bl = Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ) ? element2.getLeft() instanceof KtArrayAccessExpression : false;
                }
            }
            return bl;
        }

        private final boolean isApplicableArrayAccess(KtArrayAccessExpression element2, int caretOffset) {
            PsiElement psiElement = element2.getLeftBracket();
            if (psiElement == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.leftBracket ?: return false");
            PsiElement lbracket = psiElement;
            PsiElement psiElement2 = element2.getRightBracket();
            if (psiElement2 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.rightBracket ?: return false");
            PsiElement rbracket = psiElement2;
            ReferenceAccess access = ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)element2), (boolean)true);
            if (access == ReferenceAccess.READ_WRITE) {
                return false;
            }
            return lbracket.getTextRange().containsOffset(caretOffset) || rbracket.getTextRange().containsOffset(caretOffset);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isApplicableCall(KtCallExpression element2, int caretOffset) {
            ResolvedCall resolvedCall;
            UserDataHolder userDataHolder;
            KtValueArgumentList ktValueArgumentList = element2.getValueArgumentList();
            if (ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.getLeftParenthesis()) != null) {
                userDataHolder = (UserDataHolder)ktValueArgumentList;
            } else {
                List list = element2.getLambdaArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.lambdaArguments");
                KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
                userDataHolder = (UserDataHolder)(ktLambdaArgument != null && (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) != null ? ktLambdaArgument.getLeftCurlyBrace() : null);
            }
            if (userDataHolder == null) return false;
            if (userDataHolder == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
            }
            PsiElement lbrace = (PsiElement)userDataHolder;
            if (!lbrace.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            ResolvedCall resolvedCall2 = resolvedCall = ResolutionUtils.resolveToCall((KtElement)((KtElement)element2), (BodyResolveMode)BodyResolveMode.FULL);
            CallableDescriptor descriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            if (!(descriptor instanceof FunctionDescriptor)) return false;
            if (!Intrinsics.areEqual((Object)descriptor.getName(), (Object)OperatorNameConventions.INVOKE)) return false;
            if (element2.getParent() instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = element2.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)OperatorNameConventions.INVOKE.asString())) {
                    return false;
                }
            }
            if (element2.getValueArgumentList() != null) return true;
            List list = element2.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.lambdaArguments");
            Collection collection = list;
            boolean bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        private final KtExpression convertUnary(KtUnaryExpression element2) {
            Name name;
            IElementType iElementType = element2.getOperationReference().getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS)) {
                return this.convertUnaryWithAssignFix(element2);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS)) {
                name = OperatorNameConventions.UNARY_PLUS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS)) {
                name = OperatorNameConventions.UNARY_MINUS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCL)) {
                name = OperatorNameConventions.NOT;
            } else {
                return (KtExpression)element2;
            }
            Name operatorName = name;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element2), (boolean)false, (int)2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = element2.getBaseExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.baseExpression!!");
            objectArray[0] = ktExpression;
            objectArray[1] = operatorName;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0.$1()", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement psiElement = element2.replace((PsiElement)transformed2);
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement;
        }

        private final KtExpression convertUnaryWithAssignFix(KtUnaryExpression element2) {
            Name name;
            IElementType iElementType = element2.getOperationReference().getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS)) {
                name = OperatorNameConventions.INC;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS)) {
                name = OperatorNameConventions.DEC;
            } else {
                return (KtExpression)element2;
            }
            Name operatorName = name;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element2), (boolean)false, (int)2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = element2.getBaseExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.baseExpression!!");
            objectArray[0] = ktExpression;
            objectArray[1] = operatorName;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 = $0.$1()", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement psiElement = element2.replace((PsiElement)transformed2);
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement;
        }

        private final KtExpression convertBinary(KtBinaryExpression element2) {
            String string;
            IElementType op = element2.getOperationReference().getReferencedNameElementType();
            KtExpression ktExpression = element2.getLeft();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.left!!");
            KtExpression left = ktExpression;
            KtExpression ktExpression2 = element2.getRight();
            Intrinsics.checkNotNull((Object)ktExpression2);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.right!!");
            KtExpression right = ktExpression2;
            if (Intrinsics.areEqual((Object)op, (Object)KtTokens.EQ)) {
                if (left instanceof KtArrayAccessExpression) {
                    this.convertArrayAccess((KtArrayAccessExpression)left);
                }
                return (KtExpression)element2;
            }
            BindingContext context = ResolutionUtils.analyze((KtElement)((KtElement)element2), (BodyResolveMode)BodyResolveMode.PARTIAL);
            ResolvedCall functionCandidate = CallUtilKt.getResolvedCall((KtElement)((KtElement)element2), (BindingContext)context);
            ResolvedCall resolvedCall = functionCandidate;
            String functionName = String.valueOf(resolvedCall != null && (resolvedCall = resolvedCall.getCandidateDescriptor()) != null ? resolvedCall.getName() : null);
            KotlinType elemType = context.getType(left);
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS)) {
                string = "$0.plus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS)) {
                string = "$0.minus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL)) {
                string = "$0.times($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIV)) {
                string = "$0.div($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERC)) {
                string = "$0.rem($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE)) {
                string = "$0.rangeTo($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD)) {
                string = "$1.contains($0)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN)) {
                string = "!$1.contains($0)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"plusAssign") ? "$0.plusAssign($1)" : "$0 = $0.plus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"minusAssign") ? "$0.minusAssign($1)" : "$0 = $0.minus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"timesAssign") ? "$0.timesAssign($1)" : "$0 = $0.times($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"divAssign") ? "$0.divAssign($1)" : "$0 = $0.div($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
                boolean remSupported = PlatformKt.getLanguageVersionSettings((PsiElement)element2).supportsFeature(LanguageFeature.OperatorRem);
                string = remSupported && Intrinsics.areEqual((Object)functionName, (Object)"remAssign") ? "$0.remAssign($1)" : (Intrinsics.areEqual((Object)functionName, (Object)"modAssign") ? "$0.modAssign($1)" : (remSupported ? "$0 = $0.rem($1)" : "$0 = $0.mod($1)"));
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
                KotlinType kotlinType = elemType;
                string = kotlinType == null || kotlinType.isMarkedNullable() ? "$0?.equals($1) ?: ($1 == null)" : "$0.equals($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                KotlinType kotlinType = elemType;
                string = kotlinType == null || kotlinType.isMarkedNullable() ? "!($0?.equals($1) ?: ($1 == null))" : "!$0.equals($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
                string = "$0.compareTo($1) > 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
                string = "$0.compareTo($1) < 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
                string = "$0.compareTo($1) >= 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
                string = "$0.compareTo($1) <= 0";
            } else {
                return (KtExpression)element2;
            }
            String pattern = string;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element2), (boolean)false, (int)2, null), (String)pattern, (Object[])new Object[]{left, right}, (boolean)false, (int)4, null);
            PsiElement psiElement = element2.replace((PsiElement)transformed2);
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement;
        }

        /*
         * WARNING - void declaration
         */
        private final KtExpression convertArrayAccess(KtArrayAccessExpression element2) {
            void expressionToReplace;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (KtExpression)element2;
            KtExpression transformed2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element2), (boolean)false, (int)2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(element2, (Ref.ObjectRef)expressionToReplace){
                final /* synthetic */ KtArrayAccessExpression $element;
                final /* synthetic */ Ref.ObjectRef $expressionToReplace;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                    Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                    $this$buildExpression.appendExpression(this.$element.getArrayExpression());
                    $this$buildExpression.appendFixedText(".");
                    if (org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention$Companion.access$isAssignmentLeftSide(OperatorToFunctionIntention.Companion, this.$element)) {
                        PsiElement parent;
                        PsiElement psiElement = parent = this.$element.getParent();
                        if (psiElement == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                        }
                        this.$expressionToReplace.element = (KtExpression)((KtBinaryExpression)psiElement);
                        $this$buildExpression.appendFixedText("set(");
                        List list = this.$element.getIndexExpressions();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.indexExpressions");
                        BuilderByPattern.appendExpressions$default($this$buildExpression, (Iterable)list, null, (int)2, null);
                        $this$buildExpression.appendFixedText(",");
                        $this$buildExpression.appendExpression(((KtBinaryExpression)parent).getRight());
                    } else {
                        $this$buildExpression.appendFixedText("get(");
                        List list = this.$element.getIndexExpressions();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.indexExpressions");
                        BuilderByPattern.appendExpressions$default($this$buildExpression, (Iterable)list, null, (int)2, null);
                    }
                    $this$buildExpression.appendFixedText(")");
                }
                {
                    this.$element = ktArrayAccessExpression;
                    this.$expressionToReplace = objectRef;
                    super(1);
                }
            }), (int)1, null);
            PsiElement psiElement = ((KtExpression)expressionToReplace.element).replace((PsiElement)transformed2);
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement;
        }

        private final boolean isAssignmentLeftSide(KtArrayAccessExpression element2) {
            PsiElement parent = element2.getParent();
            return parent instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationReference().getReferencedNameElementType(), (Object)KtTokens.EQ) && Intrinsics.areEqual((Object)element2, (Object)((KtBinaryExpression)parent).getLeft());
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final KtExpression convertCall(KtCallExpression element) {
            block15: {
                block14: {
                    v0 = element.getCalleeExpression();
                    Intrinsics.checkNotNull((Object)v0);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"element.calleeExpression!!");
                    callee = v0;
                    v1 = element.getParent();
                    if (v1 == null) ** GOTO lbl-1000
                    $this$safeAs$iv = v1;
                    $i$f$safeAs = false;
                    v2 = $this$safeAs$iv;
                    if (!(v2 instanceof KtQualifiedExpression)) {
                        v2 = null;
                    }
                    if ((v1 = (KtQualifiedExpression)v2) != null) {
                        v3 = v1.getReceiverExpression();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = null;
                    }
                    receiver = v3;
                    isAnonymousFunctionWithReceiver = receiver != null && KotlinUtilsKt.deparenthesize((KtElement)((KtElement)callee)) instanceof KtNamedFunction != false;
                    argumentsList = element.getValueArgumentList();
                    v4 /* !! */  = argumentsList;
                    if (v4 /* !! */  == null || (v4 /* !! */  = v4 /* !! */ .getText()) == null || (v4 /* !! */  = StringsKt.removeSurrounding((String)v4 /* !! */ , (CharSequence)"(", (CharSequence)")")) == null) {
                        v4 /* !! */  = argumentString /* !! */  = "";
                    }
                    if (!isAnonymousFunctionWithReceiver) break block14;
                    v5 /* !! */  = receiver;
                    if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getText()) == null) {
                        v5 /* !! */  = "";
                    }
                    receiverText /* !! */  = v5 /* !! */ ;
                    var10_10 = (CharSequence)receiverText /* !! */ ;
                    var11_11 = false;
                    if (!(var10_10.length() > 0)) ** GOTO lbl-1000
                    var10_10 = (CharSequence)argumentString /* !! */ ;
                    var11_11 = false;
                    if (var10_10.length() > 0) {
                        v6 = ", ";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = "";
                    }
                    delimiter = v6;
                    v7 /* !! */  = (String)receiverText /* !! */  + delimiter + (String)argumentString /* !! */ ;
                    break block15;
                }
                v7 /* !! */  = argumentString /* !! */ ;
            }
            argumentsWithReceiverIfNeeded /* !! */  = v7 /* !! */ ;
            v8 = element.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"element.lambdaArguments");
            funcLitArgs = v8;
            calleeText = callee.getText();
            transformation = calleeText + '.' + OperatorNameConventions.INVOKE.asString() + '(' + (String)argumentsWithReceiverIfNeeded /* !! */  + ')';
            transformed = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element), (boolean)false, (int)2, null).createExpression(transformation);
            v9 = CallUtilKt.getCalleeExpressionIfAny((KtElement)((KtElement)transformed));
            v10 /* !! */  = v9 != null ? v9.getParent() : null;
            if (!(v10 /* !! */  instanceof KtCallExpression)) {
                v10 /* !! */  = null;
            }
            if ((callExpression = (KtCallExpression)v10 /* !! */ ) != null) {
                var13_16 = funcLitArgs;
                var14_17 = false;
                if (var13_16.isEmpty() == false) {
                    $this$forEach$iv = funcLitArgs;
                    $i$f$forEach = false;
                    var15_18 = $this$forEach$iv.iterator();
                    while (var15_18.hasNext()) {
                        element$iv = var15_18.next();
                        it = (KtLambdaArgument)element$iv;
                        $i$a$-forEach-OperatorToFunctionIntention$Companion$convertCall$1 = false;
                        callExpression.add((PsiElement)it);
                    }
                    $this$forEach$iv = (CharSequence)argumentsWithReceiverIfNeeded /* !! */ ;
                    var14_17 = false;
                    if ($this$forEach$iv.length() == 0) {
                        v11 = callExpression.getValueArgumentList();
                        if (v11 != null) {
                            v11.delete();
                        }
                    }
                }
            }
            elementToReplace = isAnonymousFunctionWithReceiver != false ? element.getParent() : callee.getParent();
            v12 = elementToReplace.replace((PsiElement)transformed);
            if (v12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)v12;
        }

        @NotNull
        public final Pair<KtExpression, KtSimpleNameExpression> convert(@NotNull KtExpression element2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            KtExpression elementToBeReplaced = element2;
            if (element2 instanceof KtArrayAccessExpression && this.isAssignmentLeftSide((KtArrayAccessExpression)element2)) {
                PsiElement psiElement = ((KtArrayAccessExpression)element2).getParent();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                elementToBeReplaced = (KtExpression)psiElement;
            }
            CommentSaver commentSaver = new CommentSaver((PsiElement)elementToBeReplaced, true);
            KtExpression ktExpression2 = element2;
            if (ktExpression2 instanceof KtUnaryExpression) {
                ktExpression = this.convertUnary((KtUnaryExpression)element2);
            } else if (ktExpression2 instanceof KtBinaryExpression) {
                ktExpression = this.convertBinary((KtBinaryExpression)element2);
            } else if (ktExpression2 instanceof KtArrayAccessExpression) {
                ktExpression = this.convertArrayAccess((KtArrayAccessExpression)element2);
            } else if (ktExpression2 instanceof KtCallExpression) {
                ktExpression = this.convertCall((KtCallExpression)element2);
            } else {
                throw (Throwable)new IllegalArgumentException(element2.toString());
            }
            KtExpression result = ktExpression;
            CommentSaver.restore$default(commentSaver, (PsiElement)result, false, 2, null);
            KtSimpleNameExpression ktSimpleNameExpression = this.findCallName(result);
            if (ktSimpleNameExpression == null) {
                String string = "No call name found in " + result.getText();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtSimpleNameExpression callName = ktSimpleNameExpression;
            return TuplesKt.to((Object)result, (Object)callName);
        }

        private final KtSimpleNameExpression findCallName(KtExpression result) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtExpression ktExpression = result;
            if (ktExpression instanceof KtBinaryExpression) {
                if (KtPsiUtil.isAssignment((PsiElement)((PsiElement)result))) {
                    KtExpression ktExpression2 = ((KtBinaryExpression)result).getRight();
                    Intrinsics.checkNotNull((Object)ktExpression2);
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"result.right!!");
                    ktSimpleNameExpression = this.findCallName(ktExpression2);
                } else {
                    KtExpression ktExpression3 = ((KtBinaryExpression)result).getLeft();
                    Intrinsics.checkNotNull((Object)ktExpression3);
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"result.left!!");
                    ktSimpleNameExpression = this.findCallName(ktExpression3);
                }
            } else if (ktExpression instanceof KtUnaryExpression) {
                KtExpression ktExpression4 = ((KtUnaryExpression)result).getBaseExpression();
                if (ktExpression4 != null) {
                    KtExpression ktExpression5 = ktExpression4;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtExpression it = ktExpression5;
                    boolean bl3 = false;
                    KtExpression ktExpression6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression6, (String)"it");
                    ktSimpleNameExpression = Companion.findCallName(ktExpression6);
                } else {
                    ktSimpleNameExpression = null;
                }
            } else if (ktExpression instanceof KtParenthesizedExpression) {
                KtExpression ktExpression7 = ((KtParenthesizedExpression)result).getExpression();
                if (ktExpression7 != null) {
                    KtExpression ktExpression8 = ktExpression7;
                    boolean bl = false;
                    boolean bl4 = false;
                    KtExpression it = ktExpression8;
                    boolean bl5 = false;
                    KtExpression ktExpression9 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression9, (String)"it");
                    ktSimpleNameExpression = Companion.findCallName(ktExpression9);
                } else {
                    ktSimpleNameExpression = null;
                }
            } else {
                ktSimpleNameExpression = (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)result));
            }
            return ktSimpleNameExpression;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isAssignmentLeftSide(Companion $this, KtArrayAccessExpression element2) {
            return $this.isAssignmentLeftSide(element2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

