/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.util.DumbUtilsKt;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportWrapper;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0004*\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingUtil;", "", "()V", "hasCustomPropertyDeclaration", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasExtensionReceiverParameter", "shouldHighlight", "psiElement", "Lcom/intellij/psi/PsiElement;", "shouldHighlightErrors", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldHighlightFile", "shouldHighlightScript", "shouldCheckScript", "(Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/Boolean;", "kotlin.core"})
public final class KotlinHighlightingUtil {
    @NotNull
    public static final KotlinHighlightingUtil INSTANCE;

    public final boolean shouldHighlight(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile psiFile = psiElement.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        return this.shouldHighlightFile(ktFile2);
    }

    public final boolean shouldHighlightFile(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        if (ktFile instanceof KtCodeFragment && ((KtCodeFragment)ktFile).getContext() != null) {
            return true;
        }
        VirtualFile virtualFile = ktFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"ktFile.virtualFile");
        if (OutsidersPsiFileSupportWrapper.INSTANCE.isOutsiderFile(virtualFile)) {
            Project project = ktFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ktFile.project");
            VirtualFile virtualFile2 = ktFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ktFile.virtualFile");
            VirtualFile virtualFile3 = OutsidersPsiFileSupportUtils.INSTANCE.getOutsiderFileOrigin(project, virtualFile2);
            if (virtualFile3 == null) {
                return false;
            }
            VirtualFile origin = virtualFile3;
            PsiFile psiFile = PsiManager.getInstance((Project)ktFile.getProject()).findFile(origin);
            if (psiFile == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(k\u2026e(origin) ?: return false");
            PsiFile psiFileOrigin = psiFile;
            return this.shouldHighlight((PsiElement)psiFileOrigin);
        }
        Boolean shouldCheckScript2 = this.shouldCheckScript(ktFile);
        if (Intrinsics.areEqual((Object)shouldCheckScript2, (Object)true)) {
            return this.shouldHighlightScript(ktFile);
        }
        return shouldCheckScript2 != null ? ProjectRootsUtil.isInProjectOrLibraryContent((PsiElement)ktFile) && !(GetModuleInfoKt.getModuleInfo((PsiElement)ktFile) instanceof NotUnderContentRootModuleInfo) : ProjectRootsUtil.isInContent((PsiElement)ktFile, true, true, true, true, true);
    }

    public final boolean shouldHighlightErrors(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        if (ktFile.isCompiled()) {
            return false;
        }
        if (ktFile instanceof KtCodeFragment && ((KtCodeFragment)ktFile).getContext() != null) {
            return true;
        }
        Boolean canCheckScript = this.shouldCheckScript(ktFile);
        if (Intrinsics.areEqual((Object)canCheckScript, (Object)true)) {
            return this.shouldHighlightScript(ktFile);
        }
        return ProjectRootsUtil.isInProjectSource((PsiElement)ktFile, canCheckScript == null);
    }

    private final Boolean shouldCheckScript(KtFile $this$shouldCheckScript) {
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>($this$shouldCheckScript){
            final /* synthetic */ KtFile $this_shouldCheckScript;

            @Nullable
            public final Boolean invoke() {
                Project project = this.$this_shouldCheckScript.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return DumbUtilsKt.isInDumbMode(project) ? null : (this.$this_shouldCheckScript.isScript() ? Boolean.valueOf(true) : Boolean.valueOf(false));
            }
            {
                this.$this_shouldCheckScript = ktFile;
                super(0);
            }
        }));
    }

    private final boolean shouldHighlightScript(KtFile ktFile) {
        boolean bl;
        block7: {
            if (CidrUtil.isRunningInCidrIde()) {
                return false;
            }
            Project project = ktFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ktFile.project");
            if (!ScriptConfigurationManager.Companion.getInstance(project).hasConfiguration(ktFile)) {
                return false;
            }
            Iterable $this$any$iv = IdeScriptReportSink.Companion.getReports(ktFile);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == ScriptDiagnostic.Severity.FATAL)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Project project = ktFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ktFile.project");
        if (!ScriptDefinitionsManager.Companion.getInstance(project).isReady()) {
            return false;
        }
        return ProjectRootsUtil.isInProjectSource((PsiElement)ktFile, true);
    }

    public final boolean hasCustomPropertyDeclaration(@NotNull PropertyDescriptor descriptor) {
        boolean hasCustomPropertyDeclaration;
        block1: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                hasCustomPropertyDeclaration = false;
                if (this.hasExtensionReceiverParameter(descriptor)) break block1;
                PropertyGetterDescriptor propertyGetterDescriptor = descriptor.getGetter();
                if (propertyGetterDescriptor != null && !propertyGetterDescriptor.isDefault()) break block2;
                PropertySetterDescriptor propertySetterDescriptor = descriptor.getSetter();
                if (propertySetterDescriptor == null) break block1;
                if (propertySetterDescriptor.isDefault()) break block1;
            }
            hasCustomPropertyDeclaration = true;
        }
        return hasCustomPropertyDeclaration;
    }

    public final boolean hasExtensionReceiverParameter(@NotNull PropertyDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return descriptor.getExtensionReceiverParameter() != null;
    }

    private KotlinHighlightingUtil() {
    }

    static {
        KotlinHighlightingUtil kotlinHighlightingUtil;
        INSTANCE = kotlinHighlightingUtil = new KotlinHighlightingUtil();
    }
}

