/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.icons.AllIcons;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.IncompatibleExpectedActualClassScopesRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.LanguageFeatureMessageRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.MultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.diagnostics.rendering.PlatformIncompatibilityDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.highlighter.ErrorIconUtil;
import org.jetbrains.kotlin.idea.highlighter.HtmlTabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.highlighter.IdeMultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataHtmlRenderer;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

public class IdeErrorMessages {
    private static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap("IDE");

    @NotNull
    public static String render(@NotNull UnboundDiagnostic diagnostic) {
        DiagnosticRenderer renderer2;
        if (diagnostic == null) {
            IdeErrorMessages.$$$reportNull$$$0(0);
        }
        if ((renderer2 = MAP.get(diagnostic.getFactory())) != null) {
            String string = renderer2.render(diagnostic);
            if (string == null) {
                IdeErrorMessages.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = DefaultErrorMessages.render((UnboundDiagnostic)diagnostic);
        if (string == null) {
            IdeErrorMessages.$$$reportNull$$$0(2);
        }
        return string;
    }

    @TestOnly
    public static boolean hasIdeSpecificMessage(@NotNull UnboundDiagnostic diagnostic) {
        if (diagnostic == null) {
            IdeErrorMessages.$$$reportNull$$$0(3);
        }
        return MAP.get(diagnostic.getFactory()) != null;
    }

    private IdeErrorMessages() {
    }

    static {
        MAP.put(Errors.TYPE_MISMATCH, KotlinIdeaAnalysisBundle.htmlMessage("html.type.mismatch.table.tr.td.required.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS, KotlinIdeaAnalysisBundle.htmlMessage("html.type.mismatch.table.tr.td.required.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_DUE_TO_TYPE_PROJECTIONS, KotlinIdeaAnalysisBundle.htmlMessage("html.type.mismatch.table.tr.td.required.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.br.projected.type.2.restricts.use.of.br.3.html", new Object[0]), object -> {
            RenderingContext context = RenderingContext.of((Object[])new Object[]{object.getExpectedType(), object.getExpressionType(), object.getReceiverType(), object.getCallableDescriptor()});
            return new String[]{IdeRenderers.HTML_RENDER_TYPE.render(object.getExpectedType(), context), IdeRenderers.HTML_RENDER_TYPE.render(object.getExpressionType(), context), IdeRenderers.HTML_RENDER_TYPE.render(object.getReceiverType(), context), IdeRenderers.HTML.render((DeclarationDescriptor)object.getCallableDescriptor(), context)};
        });
        MAP.put(Errors.ASSIGN_OPERATOR_AMBIGUITY, KotlinIdeaAnalysisBundle.htmlMessage("html.assignment.operators.ambiguity.all.these.functions.match.ul.0.ul.table.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS, KotlinIdeaAnalysisBundle.htmlMessage("html.type.inference.failed.0.html", new Object[0]), IdeRenderers.HTML_TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER, KotlinIdeaAnalysisBundle.htmlMessage("html.type.inference.failed.0.html", new Object[0]), IdeRenderers.HTML_TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR, KotlinIdeaAnalysisBundle.htmlMessage("html.type.inference.failed.0.html", new Object[0]), IdeRenderers.HTML_TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH, HtmlTabledDescriptorRenderer.tableForTypes(KotlinIdeaAnalysisBundle.message("type.inference.failed.expected.type.mismatch", new Object[0]), KotlinIdeaAnalysisBundle.message("required.space", new Object[0]), TabledDescriptorRenderer.TextElementType.STRONG, KotlinIdeaAnalysisBundle.message("found.space", new Object[0]), TabledDescriptorRenderer.TextElementType.ERROR), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED, "<html>{0}</html>", IdeRenderers.HTML_TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER);
        MAP.put(Errors.WRONG_SETTER_PARAMETER_TYPE, KotlinIdeaAnalysisBundle.htmlMessage("html.setter.parameter.type.must.be.equal.to.the.type.of.the.property.table.tr.td.expected.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.WRONG_GETTER_RETURN_TYPE, KotlinIdeaAnalysisBundle.htmlMessage("html.getter.return.type.must.be.equal.to.the.type.of.the.property.table.tr.td.expected.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.ITERATOR_AMBIGUITY, KotlinIdeaAnalysisBundle.htmlMessage("html.method.iterator.is.ambiguous.for.this.expression.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.UPPER_BOUND_VIOLATED, KotlinIdeaAnalysisBundle.htmlMessage("html.type.argument.is.not.within.its.bounds.table.tr.td.expected.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_IN_FOR_LOOP, KotlinIdeaAnalysisBundle.htmlMessage("html.loop.parameter.type.mismatch.table.tr.td.iterated.values.td.td.0.td.tr.tr.td.parameter.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE, KotlinIdeaAnalysisBundle.htmlMessage("html.return.type.is.0.which.is.not.a.subtype.of.overridden.br.1.html", new Object[0]), IdeRenderers.HTML_RENDER_RETURN_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_WITH_ANNOTATIONS_WHITELIST);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE, KotlinIdeaAnalysisBundle.htmlMessage("html.return.types.of.inherited.members.are.incompatible.br.0.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE, KotlinIdeaAnalysisBundle.htmlMessage("html.property.type.is.0.which.is.not.a.subtype.type.of.overridden.br.1.html", new Object[0]), IdeRenderers.HTML_RENDER_RETURN_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_TYPE_MISMATCH_ON_OVERRIDE, KotlinIdeaAnalysisBundle.htmlMessage("html.var.property.type.is.0.which.is.not.a.type.of.overridden.br.1.html", new Object[0]), IdeRenderers.HTML_RENDER_RETURN_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE, KotlinIdeaAnalysisBundle.htmlMessage("html.types.of.inherited.properties.are.incompatible.br.0.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_TYPE_MISMATCH_ON_INHERITANCE, KotlinIdeaAnalysisBundle.htmlMessage("html.types.of.inherited.var.properties.do.not.match.br.0.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL, KotlinIdeaAnalysisBundle.htmlMessage("html.val.property.cannot.override.var.property.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION, KotlinIdeaAnalysisBundle.htmlMessage("html.val.property.cannot.override.var.property.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED, KotlinIdeaAnalysisBundle.htmlMessage("html.0.is.not.abstract.and.does.not.implement.abstract.member.br.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED, KotlinIdeaAnalysisBundle.htmlMessage("html.0.is.not.abstract.and.does.not.implement.abstract.base.class.member.br.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED, KotlinIdeaAnalysisBundle.htmlMessage("html.0.must.override.1.br.because.it.inherits.many.implementations.of.it.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.RESULT_TYPE_MISMATCH, KotlinIdeaAnalysisBundle.htmlMessage("html.function.return.type.mismatch.table.tr.td.expected.td.td.1.td.tr.tr.td.found.td.td.2.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.STRING, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.OVERLOAD_RESOLUTION_AMBIGUITY, KotlinIdeaAnalysisBundle.htmlMessage("html.overload.resolution.ambiguity.all.these.functions.match.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.CALLABLE_REFERENCE_RESOLUTION_AMBIGUITY, KotlinIdeaAnalysisBundle.htmlMessage("html.overload.resolution.ambiguity.all.these.functions.match.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_REFERENCES);
        MAP.put(Errors.NONE_APPLICABLE, KotlinIdeaAnalysisBundle.htmlMessage("html.none.of.the.following.functions.can.be.called.with.the.arguments.supplied.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.CANNOT_COMPLETE_RESOLVE, KotlinIdeaAnalysisBundle.htmlMessage("html.cannot.choose.among.the.following.candidates.without.completing.type.inference.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER, KotlinIdeaAnalysisBundle.htmlMessage("html.unresolved.reference.br.none.of.the.following.candidates.is.applicable.because.of.receiver.type.mismatch.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY, KotlinIdeaAnalysisBundle.htmlMessage("html.overload.resolution.ambiguity.on.method.0.all.these.functions.match.ul.1.ul.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.STRING, IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE, KotlinIdeaAnalysisBundle.htmlMessage("html.property.delegate.must.have.a.0.method.none.of.the.following.functions.are.suitable.ul.1.ul.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.STRING, IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.DELEGATE_PD_METHOD_NONE_APPLICABLE, KotlinIdeaAnalysisBundle.htmlMessage("html.0.method.may.be.missing.none.of.the.following.functions.will.be.called.ul.1.ul.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.STRING, IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.COMPATIBILITY_WARNING, KotlinIdeaAnalysisBundle.htmlMessage("html.candidate.resolution.will.be.changed.soon.please.use.fully.qualified.name.to.invoke.the.following.closer.candidate.explicitly.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_COMPATIBILITY_CANDIDATE);
        MAP.put(ErrorsJvm.CONFLICTING_JVM_DECLARATIONS, KotlinIdeaAnalysisBundle.htmlMessage("html.platform.declaration.clash.0.html", new Object[0]), IdeRenderers.HTML_CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.ACCIDENTAL_OVERRIDE, KotlinIdeaAnalysisBundle.htmlMessage("html.accidental.override.0.html", new Object[0]), IdeRenderers.HTML_CONFLICTING_JVM_DECLARATIONS_DATA);
        URL errorIconUrl = AllIcons.class.getResource(ErrorIconUtil.getErrorIconUrl());
        MAP.put(Errors.EXCEPTION_FROM_ANALYZER, KotlinIdeaAnalysisBundle.htmlMessage("html.internal.error.occurred.while.analyzing.this.expression.br.table.cellspacing.0.cellpadding.0.tr.td.strong.please.use.the.strong.td.td.img.src.0.td.td.strong.icon.in.the.bottom.right.corner.to.report.this.error.strong.td.tr.table.br.pre.0.pre.html", errorIconUrl), IdeRenderers.HTML_THROWABLE);
        MAP.put(ErrorsJs.JSCODE_ERROR, KotlinIdeaAnalysisBundle.htmlMessage("html.javascript.0.html", new Object[0]), (DiagnosticParameterRenderer)JsCallDataHtmlRenderer.INSTANCE);
        MAP.put(ErrorsJs.JSCODE_WARNING, KotlinIdeaAnalysisBundle.htmlMessage("html.javascript.0.html", new Object[0]), (DiagnosticParameterRenderer)JsCallDataHtmlRenderer.INSTANCE);
        MAP.put(Errors.UNSUPPORTED_FEATURE, "<html>{0}</html>", (DiagnosticParameterRenderer)new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.UNSUPPORTED, true));
        MAP.put(Errors.EXPERIMENTAL_FEATURE_WARNING, "<html>{0}</html>", (DiagnosticParameterRenderer)new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.WARNING, true));
        MAP.put(Errors.EXPERIMENTAL_FEATURE_ERROR, "<html>{0}</html>", (DiagnosticParameterRenderer)new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.ERROR, true));
        MAP.put(Errors.NO_ACTUAL_FOR_EXPECT, KotlinIdeaAnalysisBundle.htmlMessage("html.expected.0.has.no.actual.declaration.in.module.1.2.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.DECLARATION_NAME_WITH_KIND, (DiagnosticParameterRenderer)Renderers.MODULE_WITH_PLATFORM, (DiagnosticParameterRenderer)new PlatformIncompatibilityDiagnosticRenderer((MultiplatformDiagnosticRenderingMode)IdeMultiplatformDiagnosticRenderingMode.INSTANCE));
        MAP.put(Errors.ACTUAL_WITHOUT_EXPECT, KotlinIdeaAnalysisBundle.htmlMessage("html.0.has.no.corresponding.expected.declaration.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM, (DiagnosticParameterRenderer)new PlatformIncompatibilityDiagnosticRenderer((MultiplatformDiagnosticRenderingMode)IdeMultiplatformDiagnosticRenderingMode.INSTANCE));
        MAP.put(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS, KotlinIdeaAnalysisBundle.htmlMessage("html.actual.class.0.has.no.corresponding.members.for.expected.class.members.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.NAME, (DiagnosticParameterRenderer)new IncompatibleExpectedActualClassScopesRenderer((MultiplatformDiagnosticRenderingMode)IdeMultiplatformDiagnosticRenderingMode.INSTANCE));
        String MESSAGE_FOR_CONCURRENT_HASH_MAP_CONTAINS = KotlinIdeaAnalysisBundle.htmlMessage("html.method.contains.from.concurrenthashmap.may.have.unexpected.semantics.it.calls.containsvalue.instead.of.containskey.br.use.explicit.form.of.the.call.to.containskey.containsvalue.contains.or.cast.the.value.to.kotlin.collections.map.instead.br.see.https.youtrack.jetbrains.com.issue.kt.18053.for.more.details.html", new Object[0]);
        MAP.put(ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR, MESSAGE_FOR_CONCURRENT_HASH_MAP_CONTAINS);
        MAP.put(ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR_ERROR, MESSAGE_FOR_CONCURRENT_HASH_MAP_CONTAINS);
        MAP.setImmutable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/highlighter/IdeErrorMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/highlighter/IdeErrorMessages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasIdeSpecificMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

