/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.jar.Attributes;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolution;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolutionKt;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt$WhenMappings;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinLibraryKindIndexKt;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a#\u0010\u000e\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010\"\u001b\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0002\b\u0003\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getPlatform", "(Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;)Lorg/jetbrains/kotlin/platform/TargetPlatform;", "detectLibraryKind", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getCommonRuntimeLibraryVersion", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "getLibraryJar", "jarPattern", "Ljava/util/regex/Pattern;", "([Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/regex/Pattern;)Lcom/intellij/openapi/vfs/VirtualFile;", "getLibraryJarVersion", "kotlin.core"})
public final class LibraryKindsKt {
    @NotNull
    public static final TargetPlatform getPlatform(@Nullable PersistentLibraryKind<?> $this$platform) {
        PersistentLibraryKind<?> persistentLibraryKind = $this$platform;
        return persistentLibraryKind instanceof KotlinLibraryKind ? ((KotlinLibraryKind)$this$platform).getCompilerPlatform() : DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform();
    }

    @Nullable
    public static final PersistentLibraryKind<?> detectLibraryKind(@NotNull VirtualFile[] roots) {
        Object v1;
        block9: {
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])roots);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile jarFile = virtualFile;
            if (jarFile.getFileSystem() instanceof JarFileSystem) {
                switch (LibraryKindsKt$WhenMappings.$EnumSwitchMapping$0[KotlinLibraryKindIndexKt.getLibraryKindForJar(jarFile).ordinal()]) {
                    case 1: {
                        return CommonLibraryKind.INSTANCE;
                    }
                    case 2: {
                        return JSLibraryKind.INSTANCE;
                    }
                    case 3: {
                        break;
                    }
                }
            }
            Iterable $this$firstOrNull$iv = IdePlatformKindResolution.Companion.getInstances();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdePlatformKindResolution it = (IdePlatformKindResolution)element$iv;
                boolean bl = false;
                if (!it.isLibraryFileForPlatform(jarFile)) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        IdePlatformKindResolution matchingResolution = v1;
        if (matchingResolution != null) {
            return matchingResolution.getLibraryKind();
        }
        return IdePlatformKindResolutionKt.getResolution(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform())).getLibraryKind();
    }

    @Nullable
    public static final VirtualFile getLibraryJar(@NotNull VirtualFile[] roots, @NotNull Pattern jarPattern) {
        VirtualFile virtualFile;
        block1: {
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)jarPattern, (String)"jarPattern");
            VirtualFile[] $this$firstOrNull$iv = roots;
            boolean $i$f$firstOrNull = false;
            VirtualFile[] virtualFileArray = $this$firstOrNull$iv;
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray[j];
                boolean bl = false;
                if (!jarPattern.matcher(it.getName()).matches()) continue;
                virtualFile = element$iv;
                break block1;
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public static final String getLibraryJarVersion(@NotNull Library library, @NotNull Pattern jarPattern) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)jarPattern, (String)"jarPattern");
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        VirtualFile virtualFile = LibraryKindsKt.getLibraryJar(virtualFileArray, jarPattern);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile libraryJar = virtualFile;
        return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)libraryJar), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Nullable
    public static final String getCommonRuntimeLibraryVersion(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return LibraryKindsKt.getLibraryJarVersion(library, PathUtil.INSTANCE.getKOTLIN_STDLIB_COMMON_JAR_PATTERN());
    }
}

