/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "findKotlinClassOrContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findMetadata", "hasMetadataPackage", "", "fqName", "kotlin.core"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        ClassId classId = JavaElementsKt.getClassId((JavaClass)javaClass);
        Intrinsics.checkNotNull((Object)classId);
        return this.findKotlinClassOrContent(classId);
    }

    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (Intrinsics.areEqual((Object)classId.getPackageFqName(), (Object)this.directoryPackageFqName) ^ true) {
            return null;
        }
        List list = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classId.relativeClassName.pathSegments()");
        String targetName = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"$", null, (CharSequence)".class", (int)0, null, null, (int)58, null);
        VirtualFile virtualFile = this.packageDirectory.findChild(targetName);
        if (virtualFile != null && ClassFileDecompilerUtilKt.isKotlinWithCompatibleAbiVersion(virtualFile)) {
            KotlinClassFinder.Result.KotlinClass kotlinClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = IDEKotlinBinaryClassCache.getKotlinBinaryClass$default(IDEKotlinBinaryClassCache.Companion.getInstance(), virtualFile, null, 2, null);
            if (kotlinJvmBinaryClass != null) {
                KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
                boolean bl = false;
                boolean bl2 = false;
                KotlinJvmBinaryClass p1 = kotlinJvmBinaryClass2;
                boolean bl3 = false;
                kotlinClass = new KotlinClassFinder.Result.KotlinClass(p1, null, 2, null);
            } else {
                kotlinClass = null;
            }
            return (KotlinClassFinder.Result)kotlinClass;
        }
        return null;
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return null;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return false;
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkNotNullParameter((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }
}

