/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.IsKotlinBinary;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\f\u001a\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f\"$\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/IsKotlinBinary;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "KOTLIN_COMPILED_FILE_ATTRIBUTE", "", "getKOTLIN_COMPILED_FILE_ATTRIBUTE", "()Ljava/lang/String;", "findMultifileClassParts", "", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "partNames", "isKotlinInternalCompiledFile", "", "fileContent", "", "isKotlinWithCompatibleAbiVersion", "kotlin.core"})
public final class ClassFileDecompilerUtilKt {
    @NotNull
    private static final String KOTLIN_COMPILED_FILE_ATTRIBUTE;
    @NotNull
    private static final Key<IsKotlinBinary> KEY;

    @NotNull
    public static final String getKOTLIN_COMPILED_FILE_ATTRIBUTE() {
        return KOTLIN_COMPILED_FILE_ATTRIBUTE;
    }

    @NotNull
    public static final Key<IsKotlinBinary> getKEY() {
        return KEY;
    }

    public static final boolean isKotlinWithCompatibleAbiVersion(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IDEKotlinBinaryClassCache ideKotlinBinaryClassCache = IDEKotlinBinaryClassCache.Companion.getInstance();
        if (!IDEKotlinBinaryClassCache.isKotlinJvmCompiledFile$default(ideKotlinBinaryClassCache, file, null, 2, null)) {
            return false;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinClass = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(ideKotlinBinaryClassCache, file, null, 2, null);
        return kotlinClass != null && kotlinClass.getMetadataVersion().isCompatible();
    }

    public static final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        boolean bl;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isValid() || fileContent != null && fileContent.length == 0) break block9;
                if (file.exists()) break block10;
            }
            return false;
        }
        IDEKotlinBinaryClassCache ideKotlinBinaryClassCache = IDEKotlinBinaryClassCache.Companion.getInstance();
        if (!ideKotlinBinaryClassCache.isKotlinJvmCompiledFile(file, fileContent)) {
            return false;
        }
        try {
            bl = fileContent == null ? ClassFileViewProvider.isInnerClass((VirtualFile)file) : ClassFileViewProvider.isInnerClass((VirtualFile)file, (byte[])fileContent);
        }
        catch (Exception exception) {
            Logger.getInstance((String)"org.jetbrains.kotlin.idea.decompiler.classFile.isKotlinInternalCompiledFile").debug(file.getPath(), (Throwable)exception);
            return false;
        }
        boolean innerClass = bl;
        if (innerClass) {
            return true;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = ideKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(file, fileContent);
        if (kotlinBinaryClassHeaderData == null) {
            return false;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData header = kotlinBinaryClassHeaderData;
        if (header.getClassId().isLocal()) {
            return true;
        }
        return header.getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS || header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    public static /* synthetic */ boolean isKotlinInternalCompiledFile$default(VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile, byArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file, @NotNull ClassId classId, @NotNull List<String> partNames) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(partNames, (String)"partNames");
        FqName fqName = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classId.packageFqName");
        FqName packageFqName = fqName;
        VirtualFile virtualFile = file.getParent();
        Intrinsics.checkNotNull((Object)virtualFile);
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        Iterable $this$mapNotNull$iv = partNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)partsFinder, (ClassId)new ClassId(packageFqName, Name.identifier((String)StringsKt.substringAfterLast$default((String)it, (char)'/', null, (int)2, null)))) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            KotlinJvmBinaryClass it$iv$iv = kotlinJvmBinaryClass;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        String string = "kotlin-compiled-file";
        boolean bl = false;
        boolean bl2 = false;
        String $this$apply = string;
        boolean bl3 = false;
        boolean $i$f$serviceOrNull = false;
        FileAttributeService fileAttributeService = (FileAttributeService)ApplicationManager.getApplication().getService(FileAttributeService.class);
        if (fileAttributeService != null) {
            FileAttributeService.DefaultImpls.register$default(fileAttributeService, $this$apply, 1, false, 4, null);
        }
        KOTLIN_COMPILED_FILE_ATTRIBUTE = string;
        Key key = Key.create((String)KOTLIN_COMPILED_FILE_ATTRIBUTE);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<IsKotlinBinar\u2026_COMPILED_FILE_ATTRIBUTE)");
        KEY = key;
    }
}

